/*
 * Decompiled with CFR 0.152.
 */
package dk.zlepper.itlt.client;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import dk.zlepper.itlt.client.helpers.ConfigUtils;
import dk.zlepper.itlt.client.helpers.Migration;
import dk.zlepper.itlt.itlt;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;

public final class ClientConfig {
    public static ForgeConfigSpec clientConfig;
    public static ForgeConfigSpec.BooleanValue enable64bitRequirement;
    public static ForgeConfigSpec.BooleanValue enable64bitWarning;
    public static ForgeConfigSpec.BooleanValue enableCustom64bitJavaGuide;
    public static ForgeConfigSpec.BooleanValue enableCustomJavaUpgradeGuide;
    public static ForgeConfigSpec.BooleanValue enableCustomJavaDowngradeGuide;
    public static ForgeConfigSpec.BooleanValue enableMinMemoryRequirement;
    public static ForgeConfigSpec.BooleanValue enableMinMemoryWarning;
    public static ForgeConfigSpec.BooleanValue enableMaxMemoryRequirement;
    public static ForgeConfigSpec.BooleanValue enableMaxMemoryWarning;
    public static ForgeConfigSpec.BooleanValue enableNearMaxMemoryWarning;
    public static ForgeConfigSpec.BooleanValue enableCustomMemoryAllocGuide;
    public static ForgeConfigSpec.BooleanValue enableMinJavaVerRequirement;
    public static ForgeConfigSpec.BooleanValue enableMinJavaVerWarning;
    public static ForgeConfigSpec.BooleanValue ignoreMinJavaVerWarningWhenVerForced;
    public static ForgeConfigSpec.BooleanValue enableMaxJavaVerRequirement;
    public static ForgeConfigSpec.BooleanValue enableMaxJavaVerWarning;
    public static ForgeConfigSpec.BooleanValue ignoreMaxJavaVerWarningWhenVerForced;
    public static ForgeConfigSpec.BooleanValue enableCustomWindowTitle;
    public static ForgeConfigSpec.BooleanValue enableEnhancedVanillaIcon;
    public static ForgeConfigSpec.BooleanValue enableCustomIcon;
    public static ForgeConfigSpec.BooleanValue enableUsingAutodetectedIcon;
    public static ForgeConfigSpec.BooleanValue enableCustomServerListEntries;
    public static ForgeConfigSpec.BooleanValue enableExplicitGC;
    public static ForgeConfigSpec.BooleanValue enableWelcomeScreen;
    public static ForgeConfigSpec.ConfigValue<String> modpackName;
    public static ForgeConfigSpec.ConfigValue<String> customWindowTitleText;
    public static ForgeConfigSpec.ConfigValue<String> custom64bitJavaGuideURL;
    public static ForgeConfigSpec.ConfigValue<String> customJavaUpgradeGuideURL;
    public static ForgeConfigSpec.ConfigValue<String> customJavaDowngradeGuideURL;
    public static ForgeConfigSpec.ConfigValue<String> customMemoryAllocGuideURL;
    public static ForgeConfigSpec.ConfigValue<String> customWelcomeHeaderModpackDisplayName;
    public static ForgeConfigSpec.ConfigValue<String> configVersion;
    public static ForgeConfigSpec.DoubleValue reqMinMemoryAmountInGB;
    public static ForgeConfigSpec.DoubleValue reqMaxMemoryAmountInGB;
    public static ForgeConfigSpec.DoubleValue warnMinMemoryAmountInGB;
    public static ForgeConfigSpec.DoubleValue warnMaxMemoryAmountInGB;
    public static ForgeConfigSpec.DoubleValue warnNearMaxMemoryWarningInGB;
    public static ForgeConfigSpec.IntValue requiredMinJavaVersion;
    public static ForgeConfigSpec.IntValue warnMinJavaVersion;
    public static ForgeConfigSpec.IntValue requiredMaxJavaVersion;
    public static ForgeConfigSpec.IntValue warnMaxJavaVersion;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> doExplicitGCWhen;
    public static List<String> explicitGCTriggersStrList;

    public static String getSimplifiedFloatStr(float floatNum) {
        if (floatNum == (float)((int)floatNum) && floatNum != 0.0f) {
            return String.valueOf((int)floatNum);
        }
        return String.valueOf(floatNum);
    }

    public static boolean areAnyWarningsEnabled() {
        return (Boolean)enableMinMemoryWarning.get() != false || (Boolean)enableMaxMemoryWarning.get() != false || (Boolean)enableMinJavaVerWarning.get() != false || (Boolean)enableMaxJavaVerWarning.get() != false || (Boolean)enable64bitWarning.get() != false;
    }

    public static void init() {
        UnmodifiableCommentedConfig oldConfig = null;
        File configFile = ConfigUtils.configDir.resolve("itlt-client.toml").toFile();
        File oldConfigFile = ConfigUtils.configDir.resolve("itlt-client.toml.bak").toFile();
        String detectedConfigVersion = "Unknown";
        boolean shouldMigrate = false;
        if (configFile.exists()) {
            ConfigUtils.backup();
            try {
                oldConfig = ConfigUtils.readToml(oldConfigFile);
            }
            catch (IOException e) {
                itlt.LOGGER.error((Object)e);
                e.printStackTrace();
            }
        } else {
            itlt.LOGGER.info("Couldn't find a config file, making one...");
        }
        if (oldConfig != null) {
            detectedConfigVersion = ConfigUtils.getConfigVersion(oldConfig);
            itlt.LOGGER.info("detectedConfigVersion: " + detectedConfigVersion);
            if (detectedConfigVersion.equals("2.2.1")) {
                itlt.LOGGER.info("Removing backup as no migration is necessary");
                ConfigUtils.delete(oldConfigFile.toPath());
            } else {
                ConfigUtils.delete(configFile.toPath());
                shouldMigrate = true;
            }
        }
        ForgeConfigSpec.Builder clientConfigBuilder = new ForgeConfigSpec.Builder();
        clientConfigBuilder.push("Java");
        clientConfigBuilder.push("Advanced");
        clientConfigBuilder.push("ExplicitGC");
        enableExplicitGC = clientConfigBuilder.comment(new String[]{" ", " Enable this to allow itlt to explicitly request a garbage collection whenever the user", " pauses the game or opens an screen with an opaque background while keeping auto GC.", " (e.g. the Resource Packs screen)", " ", " Doing this can help reduce memory usage in certain situations and also slightly", " reduces the chances of a large GC happening in the middle of early gameplay.", " ", " Note: For best performance with this option, include -XX:+AlwaysPreTouch in your", " JVM args and have Xms and Xmx be the same value. Omit/don't include the AlwaysPreTouch", " arg for lower physical memory usage (thus allowing other apps to use memory the game isn't", " currently using, at the cost of memory allocation slowdowns when the game needs it).", " ", " Warning: This option has no effect if the -XX:+DisableExplicitGC JVM arg is present.", " ", " Turn this on to help prevent and/or reduce GC-related lag spikes, turn it off for", " Vanilla behaviour (only rely on the pressure-based automatic GC). This is off by", " default as it may actually hurt performance if Xms and Xmx aren't the same!"}).define("enableExplicitGC", false);
        doExplicitGCWhen = clientConfigBuilder.comment(new String[]{" ", " A list of triggers of when to run explicit GC.", " ", " Pause: When the player pauses the game.", " Sleep: When the player is sleeping in a bed.", " Menu: When navigating one of the following opaque background screens: ", "     Singleplayer world selection, Multiplayer server selection,", "     Resource Pack selection, Language selection, Chat options, Controls options,", "     Accessibility options, Realms main screen and Stats menu.", " ", " Note: It's mainly useful to remove \"Pause\" from this list if you usually only", " have the game paused for a tiny amount of time (i.e. less than ~2s).", " ", " Note: It's mainly useful to remove \"Menu\" from this list for speedruns that", " start the timer when the main menu is shown.", " ", " Note: enableExplicitGC must be true for this to have any effect."}).defineList("doExplicitGCWhen", explicitGCTriggersStrList, entry -> explicitGCTriggersStrList.contains(entry.toString()));
        clientConfigBuilder.pop();
        clientConfigBuilder.pop();
        clientConfigBuilder.push("Arch");
        clientConfigBuilder.push("Guide");
        enableCustom64bitJavaGuide = clientConfigBuilder.comment(new String[]{" ", " Enable this if you want to be able to change the link your users are sent to when", " they ask for instructions on how to get 64bit Java.", " ", " This is mainly useful for when you're using an unsupported version of this mod and", " the default guide's outdated or you're using your own custom launcher."}).define("enableCustom64bitJavaGuide", false);
        custom64bitJavaGuideURL = clientConfigBuilder.comment(new String[]{" ", " The URL of the guide you want users to visit when they want 64bit Java.", " ", " Note: enableCustom64bitJavaGuide must be enabled for this to take effect.", " Note: The URL must start with \"https://\" for security reasons.", " Note: itlt supports the following *optional* string insertions, useful for being", " able to show an exact guide: %launcher, %reason, %type, %desire, %subject."}).define("custom64bitJavaGuideURL", (Object)"https://zlepper.github.io/itlt/guide?launcher=%launcher&reason=%reason&type=%type&desire=%desire&subject=%subject&debug=false");
        clientConfigBuilder.pop();
        clientConfigBuilder.push("Requirement");
        enable64bitRequirement = clientConfigBuilder.comment(new String[]{" ", " Whether or not to require 64bit Java to be able to launch the modpack.", " ", " If this is enabled and someone tries to launch the modpack with 32bit Java, they'll", " get a message telling them how to upgrade and the modpack will close until they", " relaunch it with 64bit Java.", " ", " Note: Enabling this overrides enable64bitWarning."}).define("enable64bitRequirement", true);
        clientConfigBuilder.pop();
        clientConfigBuilder.push("Warning");
        enable64bitWarning = clientConfigBuilder.comment(new String[]{" ", " Whether or not to warn when someone tries to launch the modpack with 32bit Java.", " ", " If this is enabled and someone tries to launch the modpack with 32bit Java, they'll", " get a message asking them to upgrade with instructions and the option to ask later", " and continue launching the modpack."}).define("enable64bitWarning", true);
        clientConfigBuilder.pop();
        clientConfigBuilder.pop();
        clientConfigBuilder.push("Version");
        clientConfigBuilder.push("Min");
        clientConfigBuilder.push("Guide");
        enableCustomJavaUpgradeGuide = clientConfigBuilder.comment(new String[]{" ", " Enable this if you want to be able to change the link your users are sent to when", " they ask for instructions on how to upgrade Java.", " ", " This is mainly useful for when you're using an unsupported version of this mod", " and the default guide is outdated or you're using your own custom launcher."}).define("enableCustomJavaUpgradeGuide", false);
        customJavaUpgradeGuideURL = clientConfigBuilder.comment(new String[]{" ", " The URL of the guide you want users to visit when they want to upgrade Java.", " ", " Note: enableCustomJavaUpgradeGuide must be enabled for this to take effect.", " Note: The URL must start with \"https://\" for security reasons.", " Note: itlt supports the following *optional* string insertions, useful for being", " able to show an exact guide: %launcher, %reason, %type, %desire, %subject."}).define("customJavaUpgradeGuideURL", (Object)"https://zlepper.github.io/itlt/guide?launcher=%launcher&reason=%reason&type=%type&desire=%desire&subject=%subject&debug=false");
        clientConfigBuilder.pop();
        clientConfigBuilder.push("Requirement");
        enableMinJavaVerRequirement = clientConfigBuilder.comment(new String[]{" ", " Whether or not to require a certain version of Java to be able to launch the modpack.", " ", " If someone tries to launch the modpack with a version of Java older than what's", " specified in requiredMinJavaVersion, they'll get a message telling them how to", " upgrade and that the modpack will close until they relaunch it with more modern Java.", " ", " Note: This is *separate* from enableMinJavaVerWarning - you can have a separate", " version requirement and warning."}).define("enableMinJavaVerRequirement", true);
        requiredMinJavaVersion = clientConfigBuilder.comment(new String[]{" ", " The minimum version of Java needed to be able to launch the modpack.", " ", " Note: itlt handles Java version naming scheme differences for you, meaning you can", " put \"7\" here and itlt will correctly check against \"Java 1.7\" internally,", " while values such as \"15\" will check against \"Java 15\" internally."}).defineInRange("requiredMinJavaVersion", 17, 6, 127);
        clientConfigBuilder.pop();
        clientConfigBuilder.push("Warning");
        enableMinJavaVerWarning = clientConfigBuilder.comment(new String[]{" ", " Whether or not to warn when someone tries to launch the modpack with a version", " of Java older than that specified in warnMinJavaVersion.", " ", " If this is enabled and someone does that, they'll get a message telling them how", " to upgrade with the option to ask later and continue launching the modpack.", " ", " Note: This is *separate* from enableMinJavaVerRequirement - you can have a", " separate version requirement and warning."}).define("enableMinJavaVerWarning", true);
        warnMinJavaVersion = clientConfigBuilder.comment(new String[]{" ", " The minimum recommended version of Java needed to skip the warning message when", " launching the modpack."}).defineInRange("warnMinJavaVersion", 17, 6, 127);
        ignoreMinJavaVerWarningWhenVerForced = clientConfigBuilder.comment(new String[]{" ", " Some launchers (such as Twitch/CurseForge launcher) do not allow the Java version", " to be changed beyond Java 8.", " ", " Enable this option to ignore the MinJavaVerWarning on launchers where the users", " are unable to change the version of Java used to launch the game."}).define("ignoreMinJavaVerWarningWhenVerForced", true);
        clientConfigBuilder.pop();
        clientConfigBuilder.pop();
        clientConfigBuilder.push("Max");
        clientConfigBuilder.push("Guide");
        enableCustomJavaDowngradeGuide = clientConfigBuilder.comment(new String[]{" ", " Enable this if you want to be able to change the link your users are sent to when", " they ask for instructions on how to downgrade Java.", " ", " Note: I recommend stating in your guide why you want your users to use an older", " version of Java than what Forge supports (Java 15 works in Forge 1.16.5 at the", " time of writing). You should ideally be using the latest supported version of", " Java if it works with your mods.", " ", " This is mainly useful for when you're using an unsupported version of this mod", " and the default guide is outdated or you're using your own custom launcher."}).define("enableCustomJavaDowngradeGuide", false);
        customJavaDowngradeGuideURL = clientConfigBuilder.comment(new String[]{" ", " The URL of the guide you want users to visit when they want 64bit Java.", " ", " Note: enableCustomJavaDowngradeGuide must be enabled for this to take effect.", " Note: The URL must start with \"https://\" for security reasons.", " Note: itlt supports the following *optional* string insertions, useful for being", " able to show an exact guide: %launcher, %reason, %type, %desire, %subject."}).define("customJavaDowngradeGuideURL", (Object)"https://zlepper.github.io/itlt/guide?launcher=%launcher&reason=%reason&type=%type&desire=%desire&subject=%subject&debug=false");
        clientConfigBuilder.pop();
        clientConfigBuilder.push("Requirement");
        enableMaxJavaVerRequirement = clientConfigBuilder.comment(new String[]{" ", " Whether or not to require a certain version of Java to be able to launch the modpack.", " ", " If someone tries to launch the modpack with a version of Java newer than what's", " specified in requiredMaxJavaVersion, they'll get a message telling them how to", " downgrade and that the modpack will close until they relaunch it with older Java.", " ", " Note: If your version of Forge doesn't support the max version of Java you're", " trying to prevent, this mod won't be able to kick into action and show the message", " to users.", " ", " Note: This is *separate* from enableMaxJavaVerWarning - you can have a separate ", " version requirement and warning."}).define("enableMaxJavaVerRequirement", false);
        requiredMaxJavaVersion = clientConfigBuilder.comment(new String[]{" ", " The maximum version of Java needed to be able to launch the modpack.", " ", " Note: itlt handles Java version naming scheme differences for you, meaning you can", " put \"7\" here and itlt will correctly check against \"Java 1.7\" internally,", " while values such as \"15\" will check against \"Java 15\" internally."}).defineInRange("requiredMaxJavaVersion", 19, 6, 127);
        clientConfigBuilder.pop();
        clientConfigBuilder.push("Warning");
        enableMaxJavaVerWarning = clientConfigBuilder.comment(new String[]{" ", " Whether or not to warn when someone tries to launch the modpack with a version", " of Java newer than that specified in warnMaxJavaVersion.", " ", " If this is enabled and someone does that, they'll get a message telling them how", " to downgrade with the option to ask later and continue launching the modpack.", " ", " Note: This is *separate* from enableMaxJavaVerRequirement - you can have a", " separate version requirement and warning."}).define("enableMaxJavaVerWarning", false);
        warnMaxJavaVersion = clientConfigBuilder.comment(new String[]{" ", " The minimum recommended version of Java needed to skip the warning message when", " launching the modpack."}).defineInRange("warnMaxJavaVersion", 19, 6, 127);
        ignoreMaxJavaVerWarningWhenVerForced = clientConfigBuilder.comment(new String[]{" ", " Some launchers (such as Twitch/CurseForge launcher) do not allow the Java version", " to be changed from Java 8.", " ", " Enable this option to ignore the MaxJavaVerWarning on launchers where the users", " are unable to change the version of Java used to launch the game."}).define("ignoreMaxJavaVerWarningWhenVerForced", true);
        clientConfigBuilder.pop();
        clientConfigBuilder.pop();
        clientConfigBuilder.pop();
        clientConfigBuilder.push("Memory");
        clientConfigBuilder.push("Guide");
        enableCustomMemoryAllocGuide = clientConfigBuilder.comment(new String[]{" ", " Enable this if you want to be able to change the link your users are sent to when", " they ask for instructions on how to change their memory allocation settings.", " ", " This is mainly useful for when you're using an unsupported version of this mod and", " the default guide is outdated or you're using your own custom launcher."}).define("enableCustomMemoryGuide", false);
        customMemoryAllocGuideURL = clientConfigBuilder.comment(new String[]{" ", " The URL of the guide you want users to visit when they want to change their memory", " allocation settings.", " ", " Note: enableCustomJavaUpgradeGuide must be enabled for this to take effect", " ", " Note: The URL must start with \"https://\" for security reasons.", " Note: itlt supports the following *optional* string insertions, useful for being", " able to show an exact guide: %launcher, %reason, %type, %desire, %subject."}).define("customMemoryAllocGuideURL", (Object)"https://zlepper.github.io/itlt/guide?launcher=%launcher&reason=%reason&type=%type&desire=%desire&subject=%subject&debug=false");
        clientConfigBuilder.pop();
        clientConfigBuilder.push("Min");
        clientConfigBuilder.push("Requirement");
        enableMinMemoryRequirement = clientConfigBuilder.comment(new String[]{" ", " Enable this to require that at least X amount of RAM is available to the modpack", " for allocating.", " ", " This is useful if you have users complaining about \"OutOfMemory\" crashes.", " ", " Note: This is *separate* from enableMinMemoryWarning - you can have a separate", " min RAM allocation requirement and warning."}).define("enableMinMemoryRequirement", true);
        reqMinMemoryAmountInGB = clientConfigBuilder.comment(new String[]{" ", " The minimum amount of allocated RAM in GB needed to be able to launch the modpack."}).defineInRange("reqMinMemoryAmountInGB", 0.5, 0.1, 1024.0);
        clientConfigBuilder.pop();
        clientConfigBuilder.push("Warning");
        enableMinMemoryWarning = clientConfigBuilder.comment(new String[]{" ", " Enable this to show a warning when less than X amount of RAM is available to", " the modpack for allocating.", " ", " Think of this like a recommended amount while the requirement is a minimum amount.", " ", " Warning: Setting this too high could make it impossible for some of your users", " to allocate the amount you're recommending and may actually hurt performance", " (see the max memory section for details).", " ", " Note: This is *separate* from enableMinMemoryRequirement - you can have a", " separate min RAM allocation requirement and warning."}).define("enableMinMemoryWarning", true);
        warnMinMemoryAmountInGB = clientConfigBuilder.comment(new String[]{" ", " The minimum recommended amount of allocated RAM in GB needed to skip the warning", " message when launching the modpack."}).defineInRange("warnMinMemoryAmountInGB", 1.0, 0.1, 1024.0);
        clientConfigBuilder.pop();
        clientConfigBuilder.pop();
        clientConfigBuilder.push("Max");
        clientConfigBuilder.push("Requirement");
        enableMaxMemoryRequirement = clientConfigBuilder.comment(new String[]{" ", " Enable this to require that no more than X amount of RAM is available to the", " modpack for allocating.", " ", " This is useful for preventing users from allocating excessive amounts of RAM", " to the point of causing nasty GC-related lag spikes as a result."}).define("enableMaxMemoryRequirement", true);
        reqMaxMemoryAmountInGB = clientConfigBuilder.comment(new String[]{" ", " The maximum amount of allocated RAM in GB to be able to launch the modpack."}).defineInRange("reqMaxMemoryAmountInGB", 16.0, 0.1, 1024.0);
        clientConfigBuilder.pop();
        clientConfigBuilder.push("Warning");
        enableMaxMemoryWarning = clientConfigBuilder.comment(new String[]{" ", " Enable this to show a warning when more than X amount of RAM is available to", " the modpack for allocating.", " ", " This is useful for warning users that are allocating excessive amounts of RAM", " to the point of causing nasty GC-related lag spikes as a result."}).define("enableMaxMemoryWarning", true);
        warnMaxMemoryAmountInGB = clientConfigBuilder.comment(new String[]{" ", " The maximum recommended amount of allocated RAM in GB needed to skip the warning", " message when launching the modpack."}).defineInRange("warnMaxMemoryAmountInGB", 14.0, 0.1, 1024.0);
        clientConfigBuilder.pop();
        clientConfigBuilder.pop();
        clientConfigBuilder.push("NearMax");
        clientConfigBuilder.push("Warning");
        enableNearMaxMemoryWarning = clientConfigBuilder.comment(new String[]{" ", " Enable this to show a warning when not enough RAM is left over for the OS and", " drivers to use.", " ", " This is useful for warning users that are allocating so much RAM that there ", " isn't enough left over for other important processes to use without hitting", " the much slower swap space, hurting performance as a result."}).define("enableNearMaxMemoryWarning", true);
        warnNearMaxMemoryWarningInGB = clientConfigBuilder.comment(new String[]{" ", " The minimum recommended amount of memory left over after allocation in GB needed", " to skip the warning message when launching the modpack."}).defineInRange("warnNearMaxMemoryWarningInGB", 1.0, 0.1, 2.0);
        clientConfigBuilder.pop();
        clientConfigBuilder.pop();
        clientConfigBuilder.pop();
        clientConfigBuilder.pop();
        clientConfigBuilder.push("Display");
        clientConfigBuilder.push("General");
        modpackName = clientConfigBuilder.comment(new String[]{" ", " The name of your modpack.", " If blank, the modpack name will be auto-detected from supported launchers.", " This auto-detection isn't perfect, so you can override it here if needed."}).define("modpackName", (Object)"");
        clientConfigBuilder.pop();
        clientConfigBuilder.push("WindowTitle");
        enableCustomWindowTitle = clientConfigBuilder.comment(new String[]{" ", " Enable this if you want to change the name of the Minecraft window."}).define("enableCustomWindowTitle", true);
        customWindowTitleText = clientConfigBuilder.comment(new String[]{" ", " The name you want your Minecraft window to be. Put \"%mc\" to include the original", " window title's contents to help identify the Minecraft version for example.", " ", " Warning: Mojang have asked people to not change their branding entirely and made it", " harder for modders to change it at all as of MC 1.15 and newer. They clearly don't like", " people taking full credit for their work and I understand that.", " Please make sure you keep the \"%mc\" in your customWindowTitleText as a sign of respect.", " Keeping it also helps others troubleshoot your pack by knowing what Minecraft version", " it's based on - especially useful if your modpack has multiple major releases that", " span across different Minecraft versions.", " ", " Note: Put \"%modpackName\" to fill in your modpack's display name from [Display.General] modpackName.", " ", " Examples:", " - \"%modpackName - %mc\" = \"ModpackName - Minecraft* 1.19.3\"", " - \"%mc - %modpackName\" = \"Minecraft* 1.19.3 - ModpackName\"", " - \"%modpackName (%mc)\" = \"ModpackName (Minecraft* 1.19.3)\"", " - \"%modpackName (%mc)\" = \"ModpackName (Minecraft* 1.19.3)\"", " - \"ModpackName v2 based on %mc\" = \"ModpackName v2 based on Minecraft* 1.19.3\"", " ", " Note: enableCustomWindowTitle must be enabled for this to take effect."}).define("customWindowTitleText", (Object)"%modpackName - %mc");
        clientConfigBuilder.pop();
        clientConfigBuilder.push("Icon");
        enableEnhancedVanillaIcon = clientConfigBuilder.comment(new String[]{" ", " Enable this if you want itlt to use its HiDPI-aware (aka Retina support) icon setting", " feature with the Vanilla game icon, obtained directly from the game's resources.", " ", " Turning this on should give you a more crisp and detailed icon on higher resolution displays,", " rather than the comparatively blurry 32px PNG that is normally used."}).define("enableEnhancedVanillaIcon", true);
        enableCustomIcon = clientConfigBuilder.comment(new String[]{" ", " Enable this if you want to change the window and taskbar icon of the Minecraft window.", " ICO, ICNS and PNG icons provided to this mod are supported on all operating systems.", " ", " Note: The icon needs to be placed in config" + File.separator + "itlt" + File.separator + "icon.(ico/icns/png).", " ", " Note: See the itlt wiki for more info.", " ", " Note: This will override the enableEnhancedVanillaIcon when a valid custom icon is found."}).define("enableCustomIcon", true);
        enableUsingAutodetectedIcon = clientConfigBuilder.comment(new String[]{" ", " Enable this if you want itlt to automatically detect your modpack's icon when launching", " from a supported launcher. If unable to auto-detect, it will fallback to a provided", " icon.ico/icon.icns/icon.png file if available.", " ", " Note: enableCustomIcon must be enabled for this to take effect."}).define("enableUsingAutodetectedIcon", true);
        clientConfigBuilder.pop();
        clientConfigBuilder.push("WelcomeScreen");
        enableWelcomeScreen = clientConfigBuilder.comment(new String[]{" ", " Enable this if you want to show a welcome screen to your users the first time they", " start your modpack. You can customise the text shown using a text file.", " ", " Note: The text file needs to be placed in config" + File.separator + "itlt" + File.separator + "welcome.txt", " ", " Warning: This feature is experimental and may change in future v2.x releases. Check the", " changelog before updating if you use this. The changelog will make any breaking changes", " to this feature clear. If there's no mention of this feature in the changelog, rest assured", " you can update without needing to make any changes to your welcome.txt."}).define("enableWelcomeScreen", false);
        customWelcomeHeaderModpackDisplayName = clientConfigBuilder.comment(new String[]{" ", " The welcome screen header shows \"Welcome to x\". This setting lets you change x.", " ", " - If blank (default), itlt will use your modpack's name from [Display.General] modpackName.", " - Otherwise x will be whatever you put here."}).define("customWelcomeHeaderModpackDisplayName", (Object)"");
        clientConfigBuilder.pop();
        clientConfigBuilder.pop();
        clientConfigBuilder.push("ServerList");
        enableCustomServerListEntries = clientConfigBuilder.comment(new String[]{" ", " Enable this to have itlt add default servers to the Multiplayer list from a JSON file.", " ", " Note: The JSON needs to be placed in config" + File.separator + "itlt" + File.separator + "servers.json", " ", " Warning: This feature is experimental and may change in future v2.x releases. Check the", " changelog before updating if you use this. The changelog will make any breaking changes", " to this feature clear. If there's no mention of this feature in the changelog, rest assured", " you can update without needing to make any changes to your servers.json."}).define("enableCustomServerListEntries", false);
        clientConfigBuilder.pop();
        clientConfigBuilder.push("Internal");
        configVersion = clientConfigBuilder.comment(new String[]{" ", " The version of itlt that created this config file. Intended to be used for migrating", " config changes when you update the mod. Please don't touch this, this is for itlt itself to change."}).define("configVersion", (Object)"2.2.1");
        clientConfigBuilder.pop();
        clientConfig = clientConfigBuilder.build();
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)ConfigUtils.configDir.resolve("itlt-client.toml")).sync().autoreload().autosave().charset(StandardCharsets.UTF_8).writingMode(WritingMode.REPLACE).build();
        configData.load();
        clientConfig.setConfig((CommentedConfig)configData);
        if (shouldMigrate) {
            Migration.migrate(detectedConfigVersion, "2.2.1", oldConfig);
        }
        ClientConfig.validate();
    }

    private static void validate() {
        if (((Boolean)enableMaxJavaVerRequirement.get()).booleanValue() && ((Boolean)enableMinJavaVerRequirement.get()).booleanValue() && (Integer)requiredMaxJavaVersion.get() < (Integer)requiredMinJavaVersion.get()) {
            itlt.LOGGER.error("Impossible Java version requirements set: requiredMinJavaVersion cannot be higher than requiredMaxJavaVersion.");
        }
        if (((Boolean)enableCustom64bitJavaGuide.get()).booleanValue() && !((String)custom64bitJavaGuideURL.get()).toLowerCase().startsWith("https://")) {
            itlt.LOGGER.error("The custom64bitJavaGuideURL must start with \"https://\"");
        } else if (((Boolean)enableCustomJavaDowngradeGuide.get()).booleanValue() && !((String)customJavaDowngradeGuideURL.get()).toLowerCase().startsWith("https://")) {
            itlt.LOGGER.error("The customJavaDowngradeGuideURL must start with \"https://\"");
        } else if (((Boolean)enableCustomJavaUpgradeGuide.get()).booleanValue() && !((String)customJavaUpgradeGuideURL.get()).toLowerCase().startsWith("https://")) {
            itlt.LOGGER.error("The customJavaUpgradeGuideURL must start with \"https://\"");
        } else if (((Boolean)enableCustomMemoryAllocGuide.get()).booleanValue() && !((String)customMemoryAllocGuideURL.get()).toLowerCase().startsWith("https://")) {
            itlt.LOGGER.error("The customMemoryAllocGuideURL must start with \"https://\"");
        }
    }

    static {
        explicitGCTriggersStrList = Arrays.stream(explicitGCTriggers.values()).map(Enum::toString).collect(Collectors.toList());
    }

    public static enum explicitGCTriggers {
        Pause,
        Sleep,
        Menu;

    }
}

