/*
 * Decompiled with CFR 0.152.
 */
package dk.zlepper.itlt;

import dk.zlepper.itlt.client.helpers.ClientUtils;
import dk.zlepper.itlt.client.helpers.Platform;
import dk.zlepper.itlt.client.helpers.WarningPreferences;
import java.awt.Desktop;
import java.awt.Image;
import java.io.IOException;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class Main {
    @Nullable
    public static Icon getWindowsSystemIcon(String resourceDll, int iconID, int size) {
        try {
            Class<?> clazz = Class.forName("sun.awt.shell.Win32ShellFolder2");
            Method m = clazz.getDeclaredMethod("getIconResource", String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            m.setAccessible(true);
            long hIcon = (Long)m.invoke(null, resourceDll + ".dll", iconID, size, size, true);
            Method makeIconMethod = clazz.getDeclaredMethod("makeIcon", Long.TYPE, Boolean.TYPE);
            makeIconMethod.setAccessible(true);
            Image image = (Image)makeIconMethod.invoke(null, hIcon, true);
            Method disposeIconMethod = clazz.getDeclaredMethod("disposeIcon", Long.TYPE);
            disposeIconMethod.setAccessible(true);
            disposeIconMethod.invoke(null, hIcon);
            return new ImageIcon(image);
        }
        catch (IllegalAccessException | InaccessibleObjectException e) {
            if (ClientUtils.getJavaVersion() == 16) {
                System.err.println("Warn: Please run with the \"--illegal-access=permit\" flag for the best experience on Windows.");
            } else if (ClientUtils.getJavaVersion() > 16) {
                System.err.println("Warn: Please run with the \"-XX:+IgnoreUnrecognizedVMOptions --add-opens=java.desktop/sun.awt.shell=ALL-UNNAMED\" flags for the best experience on Windows.");
            } else {
                e.printStackTrace();
            }
            return null;
        }
        catch (ClassCastException | ClassNotFoundException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        int selectedOption;
        Icon infoIcon = null;
        Icon warningIcon = null;
        Icon errorIcon = null;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            if (Platform.isWindows() && (infoIcon = Main.getWindowsSystemIcon("imageres", 81, 32)) != null) {
                warningIcon = Main.getWindowsSystemIcon("imageres", 84, 32);
                errorIcon = Main.getWindowsSystemIcon("imageres", 98, 32);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        try {
            System.out.println("messageContent: " + args[8]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            String helpMsg = "To install this mod, place me in the mods folder of a Minecraft Forge 1.19.x setup.";
            JOptionPane.showMessageDialog(Main.getParentComponent(), "To install this mod, place me in the mods folder of a Minecraft Forge 1.19.x setup.", "It's the little things mod", 1, infoIcon);
            System.out.println("To install this mod, place me in the mods folder of a Minecraft Forge 1.19.x setup.");
            System.exit(0);
        }
        String messageType = args[0];
        String messageTitle = args[1];
        String messageBody = args[2];
        String errorMessage = args[6];
        String guideURL = args[7];
        String messageContent = args[8];
        Object[] messageOptions = new String[]{args[3], args[4], args[5]};
        Object[] reducedMessageOptions = new String[]{args[3], args[4]};
        WarningPreferences warningPreferences = new WarningPreferences();
        warningPreferences.load();
        if (messageType.equals("wants")) {
            if (warningPreferences.getBoolInt(messageContent, true)) {
                selectedOption = JOptionPane.showOptionDialog(Main.getParentComponent(), messageBody, messageTitle, -1, 2, warningIcon, messageOptions, messageOptions[0]);
            } else {
                System.out.println("Skipping warning as the user has requested that we don't ask them about it again.");
                selectedOption = 1;
            }
        } else {
            selectedOption = messageType.equals("needs") ? JOptionPane.showOptionDialog(Main.getParentComponent(), messageBody, messageTitle, 0, 0, errorIcon, reducedMessageOptions, reducedMessageOptions[0]) : 1;
        }
        if (selectedOption == 0) {
            Main.showGuide(guideURL, errorMessage);
        } else if (selectedOption == 2) {
            warningPreferences.setBoolInt(messageContent, false);
            warningPreferences.save();
        }
        System.exit(0);
    }

    private static JFrame getParentComponent() {
        JFrame parent = new JFrame();
        parent.setAutoRequestFocus(true);
        parent.setAlwaysOnTop(true);
        return parent;
    }

    private static void showGuide(String guideURL, String errorMessage) {
        try {
            URI guideURI = new URI(guideURL);
            Desktop.getDesktop().browse(guideURI);
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(Main.getParentComponent(), errorMessage, null, 0);
        }
    }
}

