/*
 * Decompiled with CFR 0.152.
 */
package observable.server;

import dev.architectury.networking.NetworkChannel;
import dev.architectury.utils.GameInstance;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import observable.Observable;
import observable.Props;
import observable.net.BetterChannel;
import observable.net.S2CPacket;
import observable.server.DataWithDiagnostics;
import observable.server.DiagnosticsKt;
import observable.server.ProfilingData;
import observable.server.ServerSettingsKt;
import observable.server.TaggedSampler;
import observable.server.TraceMap;
import observable.shadow.kotlinx.serialization.protobuf.ProtoBuf;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0012\u0018\u00002\u00020\u0001:\u0001_B\u0007\u00a2\u0006\u0004\b^\u0010#J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J%\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0011\u0010\u0012J%\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u001e\u001a\u00020\u001d2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\u001d2\b\b\u0002\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b \u0010!J\r\u0010\"\u001a\u00020\u001d\u00a2\u0006\u0004\b\"\u0010#J\u001f\u0010)\u001a\u0004\u0018\u00010(2\u0006\u0010%\u001a\u00020$2\u0006\u0010'\u001a\u00020&\u00a2\u0006\u0004\b)\u0010*R@\u0010-\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0,\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040+0+8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010.\u001a\u0004\b/\u00100\"\u0004\b1\u00102R$\u00107\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b4\u00105\"\u0004\b6\u0010!R$\u0010\u0018\u001a\u0004\u0018\u00010\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u00108\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\"\u0010>\u001a\u00020=8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b>\u0010?\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\"\u0010D\u001a\u00020=8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\bD\u0010?\u001a\u0004\bE\u0010A\"\u0004\bF\u0010CR\"\u0010H\u001a\u00020G8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\bH\u0010I\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR\"\u0010O\u001a\u00020N8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bO\u0010P\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR\"\u0010U\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bU\u0010V\u001a\u0004\bW\u0010X\"\u0004\bY\u0010ZR.\u0010[\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040+8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b[\u0010.\u001a\u0004\b\\\u00100\"\u0004\b]\u00102\u00a8\u0006`"}, d2={"Lobservable/server/Profiler;", "", "Lnet/minecraft/world/entity/Entity;", "entity", "Lobservable/server/Profiler$TimingData;", "process", "(Lnet/minecraft/world/entity/Entity;)Lobservable/server/Profiler$TimingData;", "Lnet/minecraft/world/level/block/state/BlockState;", "blockState", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/Level;", "level", "processBlock", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/Level;)Lobservable/server/Profiler$TimingData;", "Lnet/minecraft/world/level/block/entity/TickingBlockEntity;", "blockEntity", "processBlockEntity", "(Lnet/minecraft/world/level/block/entity/TickingBlockEntity;Lnet/minecraft/world/level/Level;)Lobservable/server/Profiler$TimingData;", "Lnet/minecraft/world/level/material/FluidState;", "fluidState", "processFluid", "(Lnet/minecraft/world/level/material/FluidState;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/Level;)Lobservable/server/Profiler$TimingData;", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "duration", "", "sample", "", "runWithDuration", "(Lnet/minecraft/server/level/ServerPlayer;IZ)V", "startRunning", "(Z)V", "stopRunning", "()V", "Lobservable/server/ProfilingData;", "data", "Lkotlinx/serialization/json/JsonObject;", "diagnostics", "", "uploadProfile", "(Lobservable/server/ProfilingData;Lkotlinx/serialization/json/JsonObject;)Ljava/lang/String;", "Ljava/util/HashMap;", "Lnet/minecraft/resources/ResourceKey;", "blockTimingsMap", "Ljava/util/HashMap;", "getBlockTimingsMap", "()Ljava/util/HashMap;", "setBlockTimingsMap", "(Ljava/util/HashMap;)V", "v", "getNotProcessing", "()Z", "setNotProcessing", "notProcessing", "Lnet/minecraft/server/level/ServerPlayer;", "getPlayer", "()Lnet/minecraft/server/level/ServerPlayer;", "setPlayer", "(Lnet/minecraft/server/level/ServerPlayer;)V", "Ljava/lang/Thread;", "samplerThread", "Ljava/lang/Thread;", "getSamplerThread", "()Ljava/lang/Thread;", "setSamplerThread", "(Ljava/lang/Thread;)V", "serverThread", "getServerThread", "setServerThread", "Lobservable/server/TraceMap;", "serverTraceMap", "Lobservable/server/TraceMap;", "getServerTraceMap", "()Lobservable/server/TraceMap;", "setServerTraceMap", "(Lobservable/server/TraceMap;)V", "", "startTime", "J", "getStartTime", "()J", "setStartTime", "(J)V", "startingTicks", "I", "getStartingTicks", "()I", "setStartingTicks", "(I)V", "timingsMap", "getTimingsMap", "setTimingsMap", "<init>", "TimingData", "observable"})
@SourceDebugExtension(value={"SMAP\nProfiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Profiler.kt\nobservable/server/Profiler\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 BetterChannel.kt\nobservable/net/BetterChannel\n+ 7 TraceMap.kt\nobservable/server/TraceMap\n*L\n1#1,187:1\n372#2,7:188\n372#2,7:195\n372#2,7:202\n372#2,7:209\n372#2,7:216\n372#2,7:223\n372#2,7:230\n372#2,7:273\n113#3:237\n186#3:244\n1#4:238\n1549#5:239\n1620#5,3:240\n766#5:259\n857#5,2:260\n172#6:243\n173#6,14:245\n30#7,11:262\n41#7,4:280\n*S KotlinDebug\n*F\n+ 1 Profiler.kt\nobservable/server/Profiler\n*L\n56#1:188,7\n60#1:195,7\n61#1:202,7\n72#1:209,7\n73#1:216,7\n84#1:223,7\n85#1:230,7\n111#1:273,7\n143#1:237\n178#1:244\n176#1:239\n176#1:240,3\n183#1:259\n183#1:260,2\n178#1:243\n178#1:245,14\n111#1:262,11\n111#1:280,4\n*E\n"})
public final class Profiler {
    @NotNull
    private HashMap<Entity, TimingData> timingsMap = new HashMap();
    public TraceMap serverTraceMap;
    public Thread serverThread;
    public Thread samplerThread;
    @NotNull
    private HashMap<ResourceKey<Level>, HashMap<BlockPos, TimingData>> blockTimingsMap = new HashMap();
    @Nullable
    private ServerPlayer player;
    private long startTime;
    private int startingTicks;

    @NotNull
    public final HashMap<Entity, TimingData> getTimingsMap() {
        return this.timingsMap;
    }

    public final void setTimingsMap(@NotNull HashMap<Entity, TimingData> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.timingsMap = hashMap;
    }

    @NotNull
    public final TraceMap getServerTraceMap() {
        TraceMap traceMap = this.serverTraceMap;
        if (traceMap != null) {
            return traceMap;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"serverTraceMap");
        return null;
    }

    public final void setServerTraceMap(@NotNull TraceMap traceMap) {
        Intrinsics.checkNotNullParameter((Object)traceMap, (String)"<set-?>");
        this.serverTraceMap = traceMap;
    }

    @NotNull
    public final Thread getServerThread() {
        Thread thread = this.serverThread;
        if (thread != null) {
            return thread;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"serverThread");
        return null;
    }

    public final void setServerThread(@NotNull Thread thread) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"<set-?>");
        this.serverThread = thread;
    }

    @NotNull
    public final Thread getSamplerThread() {
        Thread thread = this.samplerThread;
        if (thread != null) {
            return thread;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"samplerThread");
        return null;
    }

    public final void setSamplerThread(@NotNull Thread thread) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"<set-?>");
        this.samplerThread = thread;
    }

    @NotNull
    public final HashMap<ResourceKey<Level>, HashMap<BlockPos, TimingData>> getBlockTimingsMap() {
        return this.blockTimingsMap;
    }

    public final void setBlockTimingsMap(@NotNull HashMap<ResourceKey<Level>, HashMap<BlockPos, TimingData>> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.blockTimingsMap = hashMap;
    }

    public final boolean getNotProcessing() {
        return Props.notProcessing;
    }

    public final void setNotProcessing(boolean v) {
        Props.notProcessing = v;
    }

    @Nullable
    public final ServerPlayer getPlayer() {
        return this.player;
    }

    public final void setPlayer(@Nullable ServerPlayer serverPlayer) {
        this.player = serverPlayer;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final void setStartTime(long l) {
        this.startTime = l;
    }

    public final int getStartingTicks() {
        return this.startingTicks;
    }

    public final void setStartingTicks(int n) {
        this.startingTicks = n;
    }

    @NotNull
    public final TimingData process(@NotNull Entity entity) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Map $this$getOrPut$iv = this.timingsMap;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(entity);
        if (value$iv == null) {
            boolean bl = false;
            TimingData answer$iv = new TimingData(0L, 0, new TraceMap(Reflection.getOrCreateKotlinClass(entity.getClass())), null, 8, null);
            $this$getOrPut$iv.put(entity, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (TimingData)object;
    }

    @NotNull
    public final TimingData processBlockEntity(@NotNull TickingBlockEntity blockEntity, @NotNull Level level) {
        Object object;
        Object object2;
        Map $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Map map = this.blockTimingsMap;
        ResourceKey resourceKey = level.m_46472_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
        ResourceKey key$iv = resourceKey;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            HashMap answer$iv = new HashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        $this$getOrPut$iv = (Map)object2;
        BlockPos blockPos = blockEntity.m_142689_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
        key$iv = blockPos;
        $i$f$getOrPut = false;
        value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            TraceMap traceMap = new TraceMap(Reflection.getOrCreateKotlinClass(blockEntity.getClass()));
            String string = blockEntity.m_142280_();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getType(...)");
            TimingData answer$iv = new TimingData(0L, 0, traceMap, string);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (TimingData)object;
    }

    @NotNull
    public final TimingData processBlock(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull Level level) {
        Object object;
        Object object2;
        Map $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Map map = this.blockTimingsMap;
        ResourceKey resourceKey = level.m_46472_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
        ResourceKey key$iv = resourceKey;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            HashMap answer$iv = new HashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        $this$getOrPut$iv = (Map)object2;
        boolean $i$f$getOrPut2 = false;
        Object value$iv2 = $this$getOrPut$iv.get(pos);
        if (value$iv2 == null) {
            boolean bl = false;
            TraceMap traceMap = new TraceMap(Reflection.getOrCreateKotlinClass(blockState.getClass()));
            String string = blockState.m_60734_().m_7705_();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescriptionId(...)");
            TimingData answer$iv = new TimingData(0L, 0, traceMap, string);
            $this$getOrPut$iv.put(pos, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv2;
        }
        return (TimingData)object;
    }

    @NotNull
    public final TimingData processFluid(@NotNull FluidState fluidState, @NotNull BlockPos pos, @NotNull Level level) {
        Object object;
        Object object2;
        Map $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)fluidState, (String)"fluidState");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Map map = this.blockTimingsMap;
        ResourceKey resourceKey = level.m_46472_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
        ResourceKey key$iv = resourceKey;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            HashMap answer$iv = new HashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        $this$getOrPut$iv = (Map)object2;
        boolean $i$f$getOrPut2 = false;
        Object value$iv2 = $this$getOrPut$iv.get(pos);
        if (value$iv2 == null) {
            boolean bl = false;
            TraceMap traceMap = new TraceMap(Reflection.getOrCreateKotlinClass(fluidState.getClass()));
            String string = BuiltInRegistries.f_257020_.m_7981_((Object)fluidState.m_76152_()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            TimingData answer$iv = new TimingData(0L, 0, traceMap, string);
            $this$getOrPut$iv.put(pos, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv2;
        }
        return (TimingData)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startRunning(boolean sample) {
        this.timingsMap.clear();
        this.blockTimingsMap.clear();
        this.setServerTraceMap(new TraceMap(null, null, null, 0, 15, null));
        this.startTime = System.currentTimeMillis();
        Boolean bl = Props.notProcessing;
        synchronized (bl) {
            boolean bl2 = false;
            this.setNotProcessing(false);
            MinecraftServer minecraftServer = GameInstance.getServer();
            Intrinsics.checkNotNull((Object)minecraftServer);
            this.startingTicks = minecraftServer.m_129921_();
            Unit unit = Unit.INSTANCE;
        }
        if (sample) {
            this.setSamplerThread(new Thread(new TaggedSampler(this.getServerThread())));
            this.getSamplerThread().start();
            new Thread(() -> Profiler.startRunning$lambda$8(this)).start();
        }
    }

    public static /* synthetic */ void startRunning$default(Profiler profiler, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        profiler.startRunning(bl);
    }

    public final void runWithDuration(@Nullable ServerPlayer player, int duration, boolean sample) {
        this.player = player;
        this.startRunning(sample);
        long durMs = (long)duration * 1000L;
        BetterChannel betterChannel = Observable.INSTANCE.getCHANNEL();
        MinecraftServer minecraftServer = GameInstance.getServer();
        Intrinsics.checkNotNull((Object)minecraftServer);
        List list = minecraftServer.m_6846_().m_11314_();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        betterChannel.sendToPlayers(list, new S2CPacket.ProfilingStarted(this.startTime + durMs));
        Timer timer = new Timer("Profiler", false);
        TimerTask timerTask = new TimerTask(this){
            final /* synthetic */ Profiler this$0;
            {
                this.this$0 = profiler;
            }

            public void run() {
                TimerTask $this$runWithDuration_u24lambda_u249 = this;
                boolean bl = false;
                this.this$0.stopRunning();
            }
        };
        timer.schedule(timerTask, durMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final String uploadProfile(@NotNull ProfilingData data, @NotNull JsonObject diagnostics) {
        void $this$encodeToString$iv;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)diagnostics, (String)"diagnostics");
        if (((CharSequence)ServerSettingsKt.getServerSettings().getUploadURL()).length() == 0) {
            Observable.INSTANCE.getLOGGER().info("uploadURL not set, skipping upload");
            return null;
        }
        Observable.INSTANCE.getLOGGER().info("Attempting to upload profile");
        Object object = (StringFormat)Json.Default;
        Object value$iv = new DataWithDiagnostics(data, diagnostics);
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        String serialized = $this$encodeToString$iv.encodeToString((SerializationStrategy)DataWithDiagnostics.Companion.serializer(), value$iv);
        try {
            String string;
            URLConnection uRLConnection = new URL(ServerSettingsKt.getServerSettings().getUploadURL()).openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection conn = (HttpURLConnection)uRLConnection;
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            Logger logger = Observable.INSTANCE.getLOGGER();
            Object object2 = "%.2f";
            Object object3 = new Object[]{(double)serialized.length() / 1000.0};
            String string2 = String.format((String)object2, Arrays.copyOf(object3, ((Object[])object3).length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            logger.info("Writing " + string2 + "kb");
            object3 = new OutputStreamWriter((OutputStream)new GZIPOutputStream(conn.getOutputStream()), Charsets.UTF_8);
            int n = 8192;
            value$iv = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
            object2 = null;
            try {
                BufferedWriter it = (BufferedWriter)value$iv;
                boolean bl = false;
                it.write(serialized);
                object3 = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)value$iv, (Throwable)object2);
            }
            InputStream inputStream = conn.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            object2 = inputStream;
            object3 = Charsets.UTF_8;
            Reader bl = new InputStreamReader((InputStream)object2, (Charset)object3);
            int n2 = 8192;
            object2 = bl instanceof BufferedReader ? (BufferedReader)bl : new BufferedReader(bl, n2);
            object3 = null;
            try {
                BufferedReader it = (BufferedReader)object2;
                boolean bl2 = false;
                string = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
            }
            String profileURL = string;
            Observable.INSTANCE.getLOGGER().info("Profile uploaded to " + profileURL);
            object = profileURL;
        }
        catch (Exception e) {
            e.printStackTrace();
            object = null;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void stopRunning() {
        block10: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            List list;
            PlayerList playerList;
            void this_$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ServerPlayer it;
            Object object;
            Object $i$a$-synchronized-Profiler$stopRunning$22;
            int ticks;
            JsonObject diagnostics;
            block9: {
                block8: {
                    diagnostics = DiagnosticsKt.getDiagnostics(this);
                    ticks = 0;
                    Boolean bl = Props.notProcessing;
                    synchronized (bl) {
                        boolean $i$a$-synchronized-Profiler$stopRunning$22 = false;
                        this.setNotProcessing(true);
                        MinecraftServer minecraftServer = GameInstance.getServer();
                        Intrinsics.checkNotNull((Object)minecraftServer);
                        ticks = minecraftServer.m_129921_() - this.startingTicks;
                        $i$a$-synchronized-Profiler$stopRunning$22 = Unit.INSTANCE;
                    }
                    object = this.player;
                    if (object == null) break block8;
                    it = object;
                    boolean bl2 = false;
                    List list2 = CollectionsKt.listOf((Object)it);
                    object = list2;
                    if (list2 != null) break block9;
                }
                object = CollectionsKt.emptyList();
            }
            Object players = object;
            Observable.INSTANCE.getCHANNEL().sendToPlayers((List<? extends ServerPlayer>)players, S2CPacket.ProfilingCompleted.INSTANCE);
            ProfilingData data = ProfilingData.Companion.create((Map<Entity, TimingData>)this.timingsMap, (Map<ResourceKey<Level>, ? extends Map<BlockPos, TimingData>>)this.blockTimingsMap, ticks, this.getServerTraceMap());
            Observable.INSTANCE.getLOGGER().info("Profiler ran for " + ticks + " ticks, sending data");
            $i$a$-synchronized-Profiler$stopRunning$22 = (Iterable)players;
            Logger logger = Observable.INSTANCE.getLOGGER();
            boolean $i$f$map22 = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                ServerPlayer serverPlayer = (ServerPlayer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it2.m_36316_().getName());
            }
            logger.info("Sending to " + (List)destination$iv$iv);
            String link = this.uploadProfile(data, diagnostics);
            BetterChannel $i$f$map22 = Observable.INSTANCE.getCHANNEL();
            S2CPacket.ProfilingResult msg$iv = new S2CPacket.ProfilingResult(data, link);
            boolean $i$f$sendToPlayersSplit = false;
            BinaryFormat $this$encodeToByteArray$iv$iv = ProtoBuf.Default;
            boolean $i$f$encodeToByteArray22 = false;
            $this$encodeToByteArray$iv$iv.getSerializersModule();
            byte[] data$iv = $this$encodeToByteArray$iv$iv.encodeToByteArray((SerializationStrategy)S2CPacket.ProfilingResult.Companion.serializer(), (Object)msg$iv);
            ByteArrayInputStream bs$iv = new ByteArrayInputStream(data$iv);
            long id$iv22 = UUID.randomUUID().getLeastSignificantBits();
            NetworkChannel networkChannel = this_$iv.getRawChannel();
            Iterable iterable = (Iterable)players;
            String string = S2CPacket.ProfilingResult.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            networkChannel.sendToPlayers(iterable, (Object)new BetterChannel.PartialPacketBegin(id$iv22, string));
            int size$iv = bs$iv.available() / BetterChannel.PartialPacketAssembler.Companion.getPACKET_SIZE() + RangesKt.coerceAtMost((int)(bs$iv.available() % BetterChannel.PartialPacketAssembler.Companion.getPACKET_SIZE()), (int)1);
            int idx$iv = 0;
            while (bs$iv.available() > 0) {
                byte[] arr$iv = new byte[RangesKt.coerceAtMost((int)bs$iv.available(), (int)BetterChannel.PartialPacketAssembler.Companion.getPACKET_SIZE())];
                bs$iv.read(arr$iv);
                this_$iv.getRawChannel().sendToPlayers((Iterable)players, (Object)new BetterChannel.PartialPacketData(id$iv22, arr$iv, idx$iv, size$iv));
                ++idx$iv;
            }
            Observable.INSTANCE.getLOGGER().info("Data transfer complete!");
            MinecraftServer minecraftServer = GameInstance.getServer();
            if (minecraftServer == null || (playerList = minecraftServer.m_6846_()) == null || (list = playerList.m_11314_()) == null) break block10;
            Iterable $i$f$encodeToByteArray22 = list;
            boolean $i$f$filter = false;
            void id$iv22 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ServerPlayer it3 = (ServerPlayer)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it3);
                if (!Observable.INSTANCE.hasPermission((Player)it3)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List it4 = (List)destination$iv$iv2;
            boolean bl = false;
            Observable.INSTANCE.getCHANNEL().sendToPlayers(it4, S2CPacket.ProfilerInactive.INSTANCE);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void startRunning$lambda$8(Profiler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        while (!Props.notProcessing) {
            long interval = ServerSettingsKt.getServerSettings().getTraceInterval();
            long deviation = ServerSettingsKt.getServerSettings().getDeviation();
            TraceMap traceMap = this$0.getServerTraceMap();
            StackTraceElement[] stackTraceElementArray = this$0.getServerThread().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            Iterator traces$iv = ArraysKt.reversed((Object[])stackTraceElementArray).iterator();
            boolean $i$f$add = false;
            if (traces$iv.hasNext()) {
                void this_$iv;
                this_$iv.setCount(this_$iv.getCount() + 1);
                StackTraceElement tr$iv = (StackTraceElement)traces$iv.next();
                String string = tr$iv.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
                this_$iv.setClassName(string);
                String string2 = tr$iv.getMethodName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMethodName(...)");
                this_$iv.setMethodName(string2);
                TraceMap target$iv = this_$iv;
                while (traces$iv.hasNext()) {
                    TraceMap traceMap2;
                    StackTraceElement el$iv = (StackTraceElement)traces$iv.next();
                    String string3 = el$iv.getMethodName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getMethodName(...)");
                    this_$iv.setMethodName(string3);
                    String string4 = el$iv.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getClassName(...)");
                    String string5 = el$iv.getMethodName();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getMethodName(...)");
                    TraceMap.MapKey key$iv = new TraceMap.MapKey(string4, string5);
                    Map<TraceMap.MapKey, TraceMap> $this$getOrPut$iv$iv = target$iv.getChildren();
                    boolean $i$f$getOrPut = false;
                    TraceMap value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
                    if (value$iv$iv == null) {
                        boolean bl = false;
                        String string6 = el$iv.getClassName();
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getClassName(...)");
                        String string7 = el$iv.getMethodName();
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getMethodName(...)");
                        TraceMap answer$iv$iv = new TraceMap(string6, string7, null, 0, 12, null);
                        $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                        traceMap2 = answer$iv$iv;
                    } else {
                        traceMap2 = value$iv$iv;
                    }
                    TraceMap traceMap$iv = traceMap2;
                    traceMap$iv.setCount(traceMap$iv.getCount() + 1);
                    target$iv = traceMap$iv;
                }
            }
            Thread.sleep(interval + Random.Default.nextLong(-deviation, deviation));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0017\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u000e\u001a\u00020\u0002\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u0012\u0006\u0010\u0010\u001a\u00020\b\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u000b\u00a2\u0006\u0004\b*\u0010+J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\t\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\f\u001a\u00020\u000bH\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ8\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u000e\u001a\u00020\u00022\b\b\u0002\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\u000bH\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0007J\u0010\u0010\u0019\u001a\u00020\u000bH\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\rR\"\u0010\u0011\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u001a\u001a\u0004\b\u001b\u0010\r\"\u0004\b\u001c\u0010\u001dR\"\u0010\u000f\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u001e\u001a\u0004\b\u001f\u0010\u0007\"\u0004\b \u0010!R\"\u0010\u000e\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\"\u001a\u0004\b#\u0010\u0004\"\u0004\b$\u0010%R\"\u0010\u0010\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u0010&\u001a\u0004\b'\u0010\n\"\u0004\b(\u0010)\u00a8\u0006,"}, d2={"Lobservable/server/Profiler$TimingData;", "", "", "component1", "()J", "", "component2", "()I", "Lobservable/server/TraceMap;", "component3", "()Lobservable/server/TraceMap;", "", "component4", "()Ljava/lang/String;", "time", "ticks", "traces", "name", "copy", "(JILobservable/server/TraceMap;Ljava/lang/String;)Lobservable/server/Profiler$TimingData;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Ljava/lang/String;", "getName", "setName", "(Ljava/lang/String;)V", "I", "getTicks", "setTicks", "(I)V", "J", "getTime", "setTime", "(J)V", "Lobservable/server/TraceMap;", "getTraces", "setTraces", "(Lobservable/server/TraceMap;)V", "<init>", "(JILobservable/server/TraceMap;Ljava/lang/String;)V", "observable"})
    public static final class TimingData {
        private long time;
        private int ticks;
        @NotNull
        private TraceMap traces;
        @NotNull
        private String name;

        public TimingData(long time, int ticks, @NotNull TraceMap traces, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)traces, (String)"traces");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.time = time;
            this.ticks = ticks;
            this.traces = traces;
            this.name = name;
        }

        public /* synthetic */ TimingData(long l, int n, TraceMap traceMap, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                string = "";
            }
            this(l, n, traceMap, string);
        }

        public final long getTime() {
            return this.time;
        }

        public final void setTime(long l) {
            this.time = l;
        }

        public final int getTicks() {
            return this.ticks;
        }

        public final void setTicks(int n) {
            this.ticks = n;
        }

        @NotNull
        public final TraceMap getTraces() {
            return this.traces;
        }

        public final void setTraces(@NotNull TraceMap traceMap) {
            Intrinsics.checkNotNullParameter((Object)traceMap, (String)"<set-?>");
            this.traces = traceMap;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.name = string;
        }

        public final long component1() {
            return this.time;
        }

        public final int component2() {
            return this.ticks;
        }

        @NotNull
        public final TraceMap component3() {
            return this.traces;
        }

        @NotNull
        public final String component4() {
            return this.name;
        }

        @NotNull
        public final TimingData copy(long time, int ticks, @NotNull TraceMap traces, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)traces, (String)"traces");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new TimingData(time, ticks, traces, name);
        }

        public static /* synthetic */ TimingData copy$default(TimingData timingData, long l, int n, TraceMap traceMap, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                l = timingData.time;
            }
            if ((n2 & 2) != 0) {
                n = timingData.ticks;
            }
            if ((n2 & 4) != 0) {
                traceMap = timingData.traces;
            }
            if ((n2 & 8) != 0) {
                string = timingData.name;
            }
            return timingData.copy(l, n, traceMap, string);
        }

        @NotNull
        public String toString() {
            return "TimingData(time=" + this.time + ", ticks=" + this.ticks + ", traces=" + this.traces + ", name=" + this.name + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.time);
            result = result * 31 + Integer.hashCode(this.ticks);
            result = result * 31 + this.traces.hashCode();
            result = result * 31 + this.name.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TimingData)) {
                return false;
            }
            TimingData timingData = (TimingData)other;
            if (this.time != timingData.time) {
                return false;
            }
            if (this.ticks != timingData.ticks) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.traces, (Object)timingData.traces)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)timingData.name);
        }
    }
}

