/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixLootRegistry;
import dev.shadowsoffire.apotheosis.adventure.loot.GemLootPoolEntry;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityClamp;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class AffixLootPoolEntry
extends LootPoolSingletonContainer {
    public static final LootPoolEntryType TYPE = new LootPoolEntryType((net.minecraft.world.level.storage.loot.Serializer)new Serializer());
    @Nullable
    private final RarityClamp.Simple rarityLimit;
    private final List<DynamicHolder<AffixLootEntry>> entries;

    public AffixLootPoolEntry(@Nullable RarityClamp.Simple rarityLimit, List<ResourceLocation> entries, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
        super(weight, quality, conditions, functions);
        this.rarityLimit = rarityLimit;
        this.entries = entries.stream().map(arg_0 -> ((AffixLootRegistry)AffixLootRegistry.INSTANCE).holder(arg_0)).toList();
    }

    protected void m_6948_(Consumer<ItemStack> list, LootContext ctx) {
        ItemStack stack;
        if (this.entries.isEmpty()) {
            Player player = GemLootPoolEntry.findPlayer(ctx);
            if (player == null) {
                return;
            }
            LootRarity selectedRarity = LootRarity.random(ctx.m_230907_(), ctx.m_78945_(), this.rarityLimit);
            stack = LootController.createRandomLootItem(ctx.m_230907_(), selectedRarity, player, (ServerLevelAccessor)ctx.m_78952_());
        } else {
            List<WeightedEntry.Wrapper> resolved = this.entries.stream().map(this::unwrap).filter(Objects::nonNull).map(e -> e.wrap(ctx.m_78945_())).toList();
            AffixLootEntry entry = (AffixLootEntry)((WeightedEntry.Wrapper)WeightedRandom.m_216822_((RandomSource)ctx.m_230907_(), resolved).get()).m_146310_();
            LootRarity selectedRarity = LootRarity.random(ctx.m_230907_(), ctx.m_78945_(), this.rarityLimit == null ? entry : this.rarityLimit);
            stack = LootController.createLootItem(entry.getStack().m_41777_(), selectedRarity, ctx.m_230907_());
        }
        if (!stack.m_41619_()) {
            list.accept(stack);
        }
    }

    public LootPoolEntryType m_6751_() {
        return TYPE;
    }

    private AffixLootEntry unwrap(DynamicHolder<AffixLootEntry> holder) {
        if (!holder.isBound()) {
            AdventureModule.LOGGER.error("An AffixLootPoolEntry failed to resolve the Affix Loot Entry {}!", (Object)holder.getId());
            return null;
        }
        return (AffixLootEntry)holder.get();
    }

    public static class Serializer
    extends LootPoolSingletonContainer.Serializer<AffixLootPoolEntry> {
        protected AffixLootPoolEntry deserialize(JsonObject obj, JsonDeserializationContext context, int weight, int quality, LootItemCondition[] lootConditions, LootItemFunction[] lootFunctions) {
            RarityClamp.Simple rarity;
            if (obj.has("min_rarity") || obj.has("max_rarity")) {
                DynamicHolder<LootRarity> minRarity = RarityRegistry.byLegacyId(GsonHelper.m_13906_((JsonObject)obj, (String)"min_rarity"));
                DynamicHolder<LootRarity> maxRarity = RarityRegistry.byLegacyId(GsonHelper.m_13906_((JsonObject)obj, (String)"max_rarity"));
                rarity = new RarityClamp.Simple(minRarity, maxRarity);
            } else {
                rarity = null;
            }
            List entries = (List)context.deserialize((JsonElement)GsonHelper.m_13832_((JsonObject)obj, (String)"entries", (JsonArray)new JsonArray()), new TypeToken<List<String>>(){}.getType());
            return new AffixLootPoolEntry(rarity, entries.stream().map(ResourceLocation::new).toList(), weight, quality, lootConditions, lootFunctions);
        }

        public void serializeCustom(JsonObject object, AffixLootPoolEntry e, JsonSerializationContext ctx) {
            if (e.rarityLimit != null) {
                object.addProperty("min_rarity", e.rarityLimit.min().getId().toString());
                object.addProperty("max_rarity", e.rarityLimit.max().getId().toString());
            }
            object.add("entries", ctx.serialize(e.entries));
            super.m_7219_(object, (LootPoolSingletonContainer)e, ctx);
        }
    }
}

