/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.client;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Either;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.adventure.affix.augmenting.AugmentingScreen;
import dev.shadowsoffire.apotheosis.adventure.affix.augmenting.AugmentingTableTileRenderer;
import dev.shadowsoffire.apotheosis.adventure.affix.reforging.ReforgingScreen;
import dev.shadowsoffire.apotheosis.adventure.affix.reforging.ReforgingTableTileRenderer;
import dev.shadowsoffire.apotheosis.adventure.affix.salvaging.SalvagingScreen;
import dev.shadowsoffire.apotheosis.adventure.client.AdventureKeys;
import dev.shadowsoffire.apotheosis.adventure.client.BossSpawnMessage;
import dev.shadowsoffire.apotheosis.adventure.client.GemModel;
import dev.shadowsoffire.apotheosis.adventure.client.SocketTooltipRenderer;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.cutting.GemCuttingScreen;
import dev.shadowsoffire.attributeslib.api.client.AddAttributeTooltipsEvent;
import dev.shadowsoffire.attributeslib.api.client.GatherSkippedAttributeTooltipsEvent;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.commons.lang3.mutable.MutableInt;

public class AdventureModuleClient {
    public static List<BossSpawnMessage.BossSpawnData> BOSS_SPAWNS = new ArrayList<BossSpawnMessage.BossSpawnData>();

    public static void init() {
        MinecraftForge.EVENT_BUS.register(AdventureModuleClient.class);
        MenuScreens.m_96206_((MenuType)((MenuType)Adventure.Menus.REFORGING.get()), ReforgingScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)Adventure.Menus.SALVAGE.get()), SalvagingScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)Adventure.Menus.GEM_CUTTING.get()), GemCuttingScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)Adventure.Menus.AUGMENTING.get()), AugmentingScreen::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)Apoth.Tiles.REFORGING_TABLE.get()), k -> new ReforgingTableTileRenderer());
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)Apoth.Tiles.AUGMENTING_TABLE.get()), k -> new AugmentingTableTileRenderer());
        MinecraftForge.EVENT_BUS.register(AdventureKeys.class);
    }

    public static void onBossSpawn(BlockPos pos, float[] color) {
        BOSS_SPAWNS.add(new BossSpawnMessage.BossSpawnData(pos, color, new MutableInt()));
        SoundManager sm = Minecraft.m_91087_().m_91106_();
        for (SoundEvent soundEvent : AdventureConfig.bossAnnounceSounds) {
            sm.m_120367_((SoundInstance)new SimpleSoundInstance(soundEvent, SoundSource.HOSTILE, AdventureConfig.bossAnnounceVolume, 1.25f, Minecraft.m_91087_().f_91074_.m_217043_(), Minecraft.m_91087_().f_91074_.m_20183_()));
        }
    }

    @SubscribeEvent
    public static void render(RenderLevelStageEvent e) {
        if (e.getStage() != RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            return;
        }
        PoseStack stack = e.getPoseStack();
        MultiBufferSource.BufferSource buf = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        for (int i = 0; i < BOSS_SPAWNS.size(); ++i) {
            BossSpawnMessage.BossSpawnData data = BOSS_SPAWNS.get(i);
            stack.m_85836_();
            float partials = e.getPartialTick();
            Vec3 vec = Minecraft.m_91087_().m_91288_().m_20299_(partials);
            stack.m_85837_(-vec.f_82479_, -vec.f_82480_, -vec.f_82481_);
            stack.m_252880_((float)data.pos().m_123341_(), (float)data.pos().m_123342_(), (float)data.pos().m_123343_());
            BeaconRenderer.m_112184_((PoseStack)stack, (MultiBufferSource)buf, (ResourceLocation)BeaconRenderer.f_112102_, (float)partials, (float)1.0f, (long)p.m_9236_().m_46467_(), (int)0, (int)64, (float[])data.color(), (float)0.166f, (float)0.33f);
            stack.m_85849_();
        }
        buf.m_109911_();
    }

    @SubscribeEvent
    public static void time(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        for (int i = 0; i < BOSS_SPAWNS.size(); ++i) {
            BossSpawnMessage.BossSpawnData data = BOSS_SPAWNS.get(i);
            if (data.ticks().getAndIncrement() <= 400) continue;
            BOSS_SPAWNS.remove(i--);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void tooltips(AddAttributeTooltipsEvent e) {
        ItemStack stack = e.getStack();
        ListIterator it = e.getAttributeTooltipIterator();
        int sockets = SocketHelper.getSockets(stack);
        if (sockets > 0) {
            it.add(Component.m_237113_((String)"APOTH_REMOVE_MARKER"));
        }
    }

    @SubscribeEvent
    public static void ignoreSocketUUIDS(GatherSkippedAttributeTooltipsEvent e) {
        ItemStack stack = e.getStack();
        for (GemInstance gem : SocketHelper.getGems(stack)) {
            gem.getUUIDs().forEach(arg_0 -> ((GatherSkippedAttributeTooltipsEvent)e).skipUUID(arg_0));
        }
    }

    @SubscribeEvent
    public static void comps(RenderTooltipEvent.GatherComponents e) {
        int sockets = SocketHelper.getSockets(e.getItemStack());
        if (sockets == 0) {
            return;
        }
        List list = e.getTooltipElements();
        int rmvIdx = -1;
        for (int i = 0; i < list.size(); ++i) {
            LiteralContents tc;
            Component comp;
            Object object;
            Optional o = ((Either)list.get(i)).left();
            if (!o.isPresent() || !((object = o.get()) instanceof Component) || !((object = (comp = (Component)object).m_214077_()) instanceof LiteralContents) || !"APOTH_REMOVE_MARKER".equals((tc = (LiteralContents)object).f_237368_())) continue;
            rmvIdx = i;
            list.remove(i);
            break;
        }
        if (rmvIdx == -1) {
            return;
        }
        e.getTooltipElements().add(rmvIdx, Either.right((Object)new SocketTooltipRenderer.SocketComponent(e.getItemStack(), SocketHelper.getGems(e.getItemStack()))));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void affixTooltips(ItemTooltipEvent e) {
        ItemStack stack = e.getItemStack();
        if (stack.m_41782_()) {
            Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(stack);
            ArrayList components = new ArrayList();
            Consumer<Component> dotPrefixer = afxComp -> components.add(Component.m_237110_((String)"text.apotheosis.dot_prefix", (Object[])new Object[]{afxComp}).m_130940_(ChatFormatting.YELLOW));
            affixes.values().stream().sorted(Comparator.comparingInt(a -> ((Affix)a.affix().get()).getType().ordinal())).map(AffixInstance::getDescription).filter(c -> c.m_214077_() != ComponentContents.f_237124_).forEach(dotPrefixer);
            e.getToolTip().addAll(1, components);
        }
    }

    public static RenderType gray(ResourceLocation texture) {
        return CustomRenderTypes.GRAY.apply(texture);
    }

    public static void checkAffixLangKeys() {
        StringBuilder sb = new StringBuilder("Missing Affix Lang Keys:\n");
        boolean any = false;
        String json = "\"%s\": \"\",";
        for (Affix a : AffixRegistry.INSTANCE.getValues()) {
            ResourceLocation id = AffixRegistry.INSTANCE.getKey(a);
            if (!I18n.m_118936_((String)("affix." + id))) {
                sb.append(json.formatted("affix." + id) + "\n");
                any = true;
            }
            if (I18n.m_118936_((String)("affix." + id + ".suffix"))) continue;
            sb.append(json.formatted("affix." + id + ".suffix") + "\n");
            any = true;
        }
        if (any) {
            AdventureModule.LOGGER.error(sb.toString());
        }
    }

    private static class CustomRenderTypes
    extends RenderType {
        private static ShaderInstance grayShader;
        private static final RenderStateShard.ShaderStateShard RENDER_TYPE_GRAY;
        public static Function<ResourceLocation, RenderType> GRAY;

        private static RenderType gray(ResourceLocation loc) {
            RenderType.CompositeState rendertype$state = RenderType.CompositeState.m_110628_().m_173292_(RENDER_TYPE_GRAY).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(loc, false, false)).m_110685_(f_110139_).m_110675_(f_110129_).m_110671_(f_110152_).m_110677_(f_110154_).m_110687_(RenderStateShard.f_110114_).m_110691_(true);
            return CustomRenderTypes.m_173215_((String)"gray", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)rendertype$state);
        }

        private CustomRenderTypes(String s, VertexFormat v, VertexFormat.Mode m, int i, boolean b, boolean b2, Runnable r, Runnable r2) {
            super(s, v, m, i, b, b2, r, r2);
            throw new IllegalStateException("This class is not meant to be constructed!");
        }

        static {
            RENDER_TYPE_GRAY = new RenderStateShard.ShaderStateShard(() -> grayShader);
            GRAY = Util.m_143827_(CustomRenderTypes::gray);
        }
    }

    @Mod.EventBusSubscriber(modid="apotheosis", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusSub {
        @SubscribeEvent
        public static void models(ModelEvent.RegisterAdditional e) {
            e.register(ReforgingTableTileRenderer.HAMMER);
            e.register(AugmentingTableTileRenderer.STAR_CUBE);
        }

        @SubscribeEvent
        public static void tooltipComps(RegisterClientTooltipComponentFactoriesEvent e) {
            e.register(SocketTooltipRenderer.SocketComponent.class, SocketTooltipRenderer::new);
        }

        @SubscribeEvent
        public static void addGemModels(ModelEvent.RegisterAdditional e) {
            Set locs = Minecraft.m_91087_().m_91098_().m_214159_("models", loc -> "apotheosis".equals(loc.m_135827_()) && loc.m_135815_().contains("/gems/") && loc.m_135815_().endsWith(".json")).keySet();
            for (ResourceLocation s : locs) {
                String path = s.m_135815_().substring("models/".length(), s.m_135815_().length() - ".json".length());
                e.register(new ResourceLocation("apotheosis", path));
            }
        }

        @SubscribeEvent
        public static void replaceGemModel(ModelEvent.ModifyBakingResult e) {
            ModelResourceLocation key = new ModelResourceLocation(Apotheosis.loc("gem"), "inventory");
            BakedModel oldModel = (BakedModel)e.getModels().get(key);
            if (oldModel != null) {
                e.getModels().put(key, new GemModel(oldModel, e.getModelBakery()));
            }
        }

        @SubscribeEvent
        public static void shaderRegistry(RegisterShadersEvent event) throws IOException {
            event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("apotheosis:gray"), DefaultVertexFormat.f_85812_), shaderInstance -> {
                CustomRenderTypes.grayShader = shaderInstance;
            });
        }

        @SubscribeEvent
        public static void keys(RegisterKeyMappingsEvent e) {
            e.register(AdventureKeys.TOGGLE_RADIAL);
        }

        @SubscribeEvent
        public static void client(FMLClientSetupEvent e) {
            if (Apotheosis.enableAdventure) {
                e.enqueueWork(() -> ItemProperties.register((Item)((Item)Adventure.Items.GEM.get()), (ResourceLocation)Apotheosis.loc("rarity"), (stack, level, entity, tint) -> {
                    DynamicHolder<Gem> gem = GemItem.getGem(stack);
                    DynamicHolder<LootRarity> rarity = AffixHelper.getRarity(stack);
                    return gem.isBound() && rarity.isBound() ? (float)((LootRarity)rarity.get()).ordinal() : Float.NEGATIVE_INFINITY;
                }));
            }
        }
    }
}

