/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.scanning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import li.cil.scannable.api.scanning.BlockScannerModule;
import li.cil.scannable.api.scanning.ScanResultProvider;
import li.cil.scannable.client.scanning.ScanResultProviders;
import li.cil.scannable.client.scanning.filter.BlockCacheScanFilter;
import li.cil.scannable.client.scanning.filter.FluidTagScanFilter;
import li.cil.scannable.common.config.CommonConfig;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum FluidBlockScannerModule implements BlockScannerModule
{
    INSTANCE;

    private Predicate<BlockState> filter;

    public static void clearCache() {
        FluidBlockScannerModule.INSTANCE.filter = null;
    }

    @Override
    public int getEnergyCost(ItemStack module) {
        return CommonConfig.energyCostModuleFluid;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScanResultProvider getResultProvider() {
        return (ScanResultProvider)ScanResultProviders.BLOCKS.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float adjustLocalRange(float range) {
        return range * CommonConfig.rangeModifierModuleFluid;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Predicate<BlockState> getFilter(ItemStack module) {
        this.validateFilter();
        return this.filter;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void validateFilter() {
        if (this.filter != null) {
            return;
        }
        ArrayList<Predicate<BlockState>> filters = new ArrayList<Predicate<BlockState>>();
        BuiltInRegistries.f_257020_.m_203613_().forEach(tag -> {
            if (!CommonConfig.ignoredFluidTags.contains(tag.f_203868_())) {
                filters.add(new FluidTagScanFilter((TagKey<Fluid>)tag));
            }
        });
        this.filter = new BlockCacheScanFilter((Collection<Predicate<BlockState>>)filters);
    }
}

