/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import li.cil.scannable.common.config.Strings;
import li.cil.scannable.common.item.ScannerItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class OverlayRenderer {
    private static final ResourceLocation PROGRESS = new ResourceLocation("scannable", "textures/gui/overlay/scanner_progress.png");

    public static void render(GuiGraphics graphics, float partialTick) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21211_();
        if (stack.m_41619_()) {
            return;
        }
        if (!ScannerItem.isScanner(stack)) {
            return;
        }
        int total = stack.m_41779_();
        int remaining = player.m_21212_();
        float progress = Mth.m_14036_((float)(1.0f - ((float)remaining - partialTick) / (float)total), (float)0.0f, (float)1.0f);
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)0.66f, (float)0.8f, (float)0.93f, (float)0.66f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)PROGRESS);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85817_);
        int width = 64;
        int height = 64;
        int midX = screenWidth / 2;
        int midY = screenHeight / 2;
        int left = midX - 32;
        int right = midX + 32;
        int top = midY - 32;
        int bottom = midY + 32;
        float angle = (float)((double)progress * Math.PI * 2.0);
        float tx = Mth.m_14031_((float)angle);
        float ty = Mth.m_14089_((float)angle);
        buffer.m_5483_((double)midX, (double)top, 0.0).m_7421_(0.5f, 1.0f).m_5752_();
        if ((double)progress < 0.125) {
            buffer.m_5483_((double)midX, (double)midY, 0.0).m_7421_(0.5f, 0.5f).m_5752_();
            x = tx / ty * 0.5f;
            buffer.m_5483_((double)((float)midX + x * 64.0f), (double)top, 0.0).m_7421_(0.5f + x, 1.0f).m_5752_();
        } else {
            buffer.m_5483_((double)midX, (double)midY, 0.0).m_7421_(0.5f, 0.5f).m_5752_();
            buffer.m_5483_((double)right, (double)top, 0.0).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_5483_((double)right, (double)top, 0.0).m_7421_(1.0f, 1.0f).m_5752_();
            if ((double)progress < 0.375) {
                buffer.m_5483_((double)midX, (double)midY, 0.0).m_7421_(0.5f, 0.5f).m_5752_();
                y = Math.abs(ty / tx - 1.0f) * 0.5f;
                buffer.m_5483_((double)right, (double)((float)top + y * 64.0f), 0.0).m_7421_(1.0f, 1.0f - y).m_5752_();
            } else {
                buffer.m_5483_((double)midX, (double)midY, 0.0).m_7421_(0.5f, 0.5f).m_5752_();
                buffer.m_5483_((double)right, (double)bottom, 0.0).m_7421_(1.0f, 0.0f).m_5752_();
                buffer.m_5483_((double)right, (double)bottom, 0.0).m_7421_(1.0f, 0.0f).m_5752_();
                if ((double)progress < 0.625) {
                    buffer.m_5483_((double)midX, (double)midY, 0.0).m_7421_(0.5f, 0.5f).m_5752_();
                    x = Math.abs(tx / ty - 1.0f) * 0.5f;
                    buffer.m_5483_((double)((float)left + x * 64.0f), (double)bottom, 0.0).m_7421_(x, 0.0f).m_5752_();
                } else {
                    buffer.m_5483_((double)midX, (double)midY, 0.0).m_7421_(0.5f, 0.5f).m_5752_();
                    buffer.m_5483_((double)left, (double)bottom, 0.0).m_7421_(0.0f, 0.0f).m_5752_();
                    buffer.m_5483_((double)left, (double)bottom, 0.0).m_7421_(0.0f, 0.0f).m_5752_();
                    if ((double)progress < 0.875) {
                        buffer.m_5483_((double)midX, (double)midY, 0.0).m_7421_(0.5f, 0.5f).m_5752_();
                        y = (ty / tx + 1.0f) * 0.5f;
                        buffer.m_5483_((double)left, (double)((float)top + y * 64.0f), 0.0).m_7421_(0.0f, 1.0f - y).m_5752_();
                    } else {
                        buffer.m_5483_((double)midX, (double)midY, 0.0).m_7421_(0.5f, 0.5f).m_5752_();
                        buffer.m_5483_((double)left, (double)top, 0.0).m_7421_(0.0f, 1.0f).m_5752_();
                        buffer.m_5483_((double)left, (double)top, 0.0).m_7421_(0.0f, 1.0f).m_5752_();
                        if (progress < 1.0f) {
                            buffer.m_5483_((double)midX, (double)midY, 0.0).m_7421_(0.5f, 0.5f).m_5752_();
                            x = Math.abs(tx / ty) * 0.5f;
                            buffer.m_5483_((double)((float)midX - x * 64.0f), (double)top, 0.0).m_7421_(0.5f - x, 1.0f).m_5752_();
                        } else {
                            buffer.m_5483_((double)midX, (double)midY, 0.0).m_7421_(0.5f, 0.5f).m_5752_();
                            buffer.m_5483_((double)midX, (double)top, 0.0).m_7421_(0.5f, 1.0f).m_5752_();
                        }
                    }
                }
            }
        }
        tesselator.m_85914_();
        Component label = Strings.progress(Mth.m_14143_((float)(progress * 100.0f)));
        Font font = mc.f_91062_;
        Objects.requireNonNull(mc.f_91062_);
        graphics.m_280614_(font, label, right + 12, midY - 9 / 2, -861221650, true);
    }
}

