/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.fuel;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.railwayteam.railways.content.fuel.LiquidFuelType;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiquidFuelManager {
    private static final Map<ResourceLocation, LiquidFuelType> CUSTOM_TYPE_MAP = new HashMap<ResourceLocation, LiquidFuelType>();
    private static final Map<Fluid, LiquidFuelType> FLUID_TO_TYPE_MAP = new IdentityHashMap<Fluid, LiquidFuelType>();
    private static final Map<TagKey<Fluid>, LiquidFuelType> TAG_TO_TYPE_MAP = new IdentityHashMap<TagKey<Fluid>, LiquidFuelType>();

    public static void clear() {
        CUSTOM_TYPE_MAP.clear();
        FLUID_TO_TYPE_MAP.clear();
        TAG_TO_TYPE_MAP.clear();
    }

    public static LiquidFuelType getTypeForFluid(Fluid fluid) {
        return FLUID_TO_TYPE_MAP.get(fluid);
    }

    @Nullable
    public static LiquidFuelType isInTag(Fluid fluid) {
        for (Map.Entry<TagKey<Fluid>, LiquidFuelType> entry : TAG_TO_TYPE_MAP.entrySet()) {
            if (!fluid.m_76145_().m_205070_(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void fillFluidMap() {
        for (Map.Entry<ResourceLocation, LiquidFuelType> entry : CUSTOM_TYPE_MAP.entrySet()) {
            LiquidFuelType type = entry.getValue();
            for (Supplier<Fluid> supplier : type.getFluids()) {
                FLUID_TO_TYPE_MAP.put(supplier.get(), type);
            }
            for (Supplier<Fluid> supplier : type.getFluidTags()) {
                TAG_TO_TYPE_MAP.put((TagKey<Fluid>)((TagKey)supplier.get()), type);
            }
        }
    }

    public static class ReloadListener
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new Gson();
        public static final ReloadListener INSTANCE = new ReloadListener();
        public static final String ID = "railways_liquid_fuel";

        protected ReloadListener() {
            super(GSON, ID);
        }

        protected void apply(@NotNull Map<ResourceLocation, JsonElement> map, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
            LiquidFuelManager.clear();
            for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
                JsonElement element = entry.getValue();
                if (!element.isJsonObject()) continue;
                ResourceLocation id = entry.getKey();
                JsonObject object = element.getAsJsonObject();
                LiquidFuelType type = LiquidFuelType.fromJson(object);
                if (type == null) continue;
                CUSTOM_TYPE_MAP.put(id, type);
            }
            LiquidFuelManager.fillFluidMap();
        }
    }
}

