/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.cap.player;

import com.lothrazar.library.cap.player.PlayerCapabilityStorage;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerCapProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static Capability<PlayerCapabilityStorage> PLAYERCAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerCapabilityStorage>(){});
    private PlayerCapabilityStorage playerMana = null;
    private final LazyOptional<PlayerCapabilityStorage> opt = LazyOptional.of(this::createMe);

    private PlayerCapabilityStorage createMe() {
        if (this.playerMana == null) {
            this.playerMana = new PlayerCapabilityStorage();
        }
        return this.playerMana;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap) {
        if (cap == PLAYERCAP) {
            return this.opt.cast();
        }
        return LazyOptional.empty();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return this.getCapability(cap);
    }

    public CompoundTag serializeNBT() {
        return this.createMe().write();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.createMe().read(nbt);
    }
}

