/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.block;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.mana.ManaSpreaderBlockEntity;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.mixin.MushroomCowAccessor;
import vazkii.botania.test.TestingUtil;

public class DrumBlockTest {
    private static final String TEMPLATE = "botania:block/drum_gathering";
    private static final BlockPos POSITION_BUTTON = new BlockPos(10, 10, 9);
    private static final BlockPos POSITION_SPREADER = new BlockPos(10, 10, 10);
    private static final BlockPos POSITION_DRUM = new BlockPos(10, 11, 10);
    private static final BlockPos POSITION_BERGAMUTE = new BlockPos(11, 2, 11);
    private static final BlockPos POSITION_MOB = new BlockPos(10, 2, 10);
    private static final Vec3 VECTOR_MOB = POSITION_MOB.m_252807_();

    private static <T extends Mob> T setup(GameTestHelper helper, EntityType<T> entityType, @Nullable Item item) {
        Player player = helper.m_177368_();
        ManaSpreaderBlockEntity spreader = TestingUtil.assertBlockEntity(helper, POSITION_SPREADER, BotaniaBlockEntities.SPREADER);
        TestingUtil.assertThat(spreader.bindTo(player, new ItemStack((ItemLike)BotaniaItems.twigWand), helper.m_177449_(POSITION_DRUM), Direction.UP), () -> "Failed to bind spreader");
        if (item != null) {
            helper.m_177189_(item, (float)VECTOR_MOB.m_7096_(), (float)VECTOR_MOB.m_7098_(), (float)VECTOR_MOB.m_7094_());
        }
        return (T)((Mob)helper.m_177173_(entityType, VECTOR_MOB));
    }

    private static <T extends Mob> void testMilkingAdultAnimal(GameTestHelper helper, EntityType<T> entityType, Item inputItem, Item outputItem) {
        DrumBlockTest.setup(helper, entityType, inputItem);
        helper.m_177425_().m_177562_(() -> helper.m_177385_(POSITION_BUTTON)).m_177552_(() -> helper.m_177194_(outputItem, POSITION_MOB, 1.0)).m_177543_();
    }

    @GameTest(m_177046_="botania:block/drum_gathering", m_177042_=20)
    public void testMilkingGoat(GameTestHelper helper) {
        DrumBlockTest.testMilkingAdultAnimal(helper, EntityType.f_147035_, Items.f_42446_, Items.f_42455_);
    }

    @GameTest(m_177046_="botania:block/drum_gathering", m_177042_=20)
    public void testMilkingCow(GameTestHelper helper) {
        DrumBlockTest.testMilkingAdultAnimal(helper, EntityType.f_20557_, Items.f_42446_, Items.f_42455_);
    }

    @GameTest(m_177046_="botania:block/drum_gathering", m_177042_=20)
    public void testMilkingMooshroom(GameTestHelper helper) {
        DrumBlockTest.testMilkingAdultAnimal(helper, EntityType.f_20504_, Items.f_42446_, Items.f_42455_);
    }

    @GameTest(m_177046_="botania:block/drum_gathering", m_177042_=20)
    public void testMilkingMooshroomSoup(GameTestHelper helper) {
        DrumBlockTest.testMilkingAdultAnimal(helper, EntityType.f_20504_, Items.f_42399_, Items.f_42400_);
    }

    @GameTest(m_177046_="botania:block/drum_gathering", m_177042_=20)
    public void testMilkingBrownMooshroomSuspiciousStew(GameTestHelper helper) {
        MushroomCow cow = (MushroomCow)DrumBlockTest.setup(helper, EntityType.f_20504_, Items.f_42399_);
        cow.m_28464_(MushroomCow.MushroomType.BROWN);
        MushroomCowAccessor cowAccessor = (MushroomCowAccessor)cow;
        cowAccessor.setEffect(MobEffects.f_19610_);
        cowAccessor.setEffectDuration(15);
        helper.m_177425_().m_177562_(() -> helper.m_177385_(POSITION_BUTTON)).m_177552_(() -> helper.m_177194_(Items.f_42718_, POSITION_MOB, 1.0)).m_177562_(() -> {
            Optional item = helper.m_238399_(EntityType.f_20461_, POSITION_MOB, 1.0).stream().findFirst();
            helper.m_246336_(item.isPresent() && ((ItemEntity)item.get()).m_32055_().m_150930_(Items.f_42718_), "Item not found or not suspicious stew");
            CompoundTag nbt = ((ItemEntity)item.get()).m_32055_().m_41783_();
            helper.m_246336_(nbt.m_128425_("Effects", 9), "Missing effects list tag");
            ListTag effects = nbt.m_128437_("Effects", 10);
            helper.m_246336_(effects.size() == 1, "Exactly one effect expected");
            CompoundTag effectTag = effects.m_128728_(0);
            helper.m_246336_(effectTag.m_128425_("EffectId", 3) && effectTag.m_128425_("EffectDuration", 3), "Missing ID and/or duration tag for effect");
            MobEffect effect = MobEffect.m_19453_((int)effectTag.m_128451_("EffectId"));
            int effectDuration = effectTag.m_128451_("EffectDuration");
            helper.m_246336_(effect == MobEffects.f_19610_ && effectDuration == 15, "Unexpected effect type or duration");
        }).m_177543_();
    }

    private static <T extends Mob> void testMilkingBabyAnimal(GameTestHelper helper, EntityType<T> entityType, Item item) {
        T baby = DrumBlockTest.setup(helper, entityType, item);
        baby.m_6863_(true);
        helper.m_177425_().m_177562_(() -> helper.m_177385_(POSITION_BUTTON)).m_177546_(20, () -> helper.m_177194_(item, POSITION_MOB, 1.0)).m_177543_();
    }

    @GameTest(m_177046_="botania:block/drum_gathering", m_177042_=25)
    public void testMilkingBabyGoat(GameTestHelper helper) {
        DrumBlockTest.testMilkingBabyAnimal(helper, EntityType.f_147035_, Items.f_42446_);
    }

    @GameTest(m_177046_="botania:block/drum_gathering", m_177042_=25)
    public void testMilkingBabyMooshroom(GameTestHelper helper) {
        DrumBlockTest.testMilkingBabyAnimal(helper, EntityType.f_20504_, Items.f_42399_);
    }

    @GameTest(m_177046_="botania:block/drum_gathering", m_177042_=25)
    public void testMilkingDeadAnimal(GameTestHelper helper) {
        Cow cow = (Cow)DrumBlockTest.setup(helper, EntityType.f_20557_, Items.f_42446_);
        helper.m_177425_().m_177562_(() -> ((Cow)cow).m_6074_()).m_177562_(() -> helper.m_177385_(POSITION_BUTTON)).m_177546_(20, () -> helper.m_177194_(Items.f_42446_, POSITION_MOB, 1.0)).m_177543_();
    }

    @GameTest(m_177046_="botania:block/drum_gathering", m_177042_=25)
    public void testMilkingNearBergamute(GameTestHelper helper) {
        DrumBlockTest.setup(helper, EntityType.f_20557_, Items.f_42446_);
        helper.m_177245_(POSITION_BERGAMUTE, BotaniaFlowerBlocks.bergamuteFloating);
        helper.m_177425_().m_177562_(() -> helper.m_177385_(POSITION_BUTTON)).m_177546_(20, () -> helper.m_177194_(Items.f_42446_, POSITION_MOB, 1.0)).m_177543_();
    }

    @GameTest(m_177046_="botania:block/drum_gathering", m_177042_=20)
    public void testShearingSheep(GameTestHelper helper) {
        Sheep sheep = (Sheep)DrumBlockTest.setup(helper, EntityType.f_20520_, null);
        sheep.m_29855_(DyeColor.LIME);
        helper.m_177425_().m_177562_(() -> helper.m_177385_(POSITION_BUTTON)).m_177552_(() -> helper.m_177194_(Items.f_41875_, POSITION_MOB, 1.0)).m_177562_(() -> helper.m_246336_(sheep.m_6084_() && sheep.m_29875_(), "Sheep should be sheared")).m_177543_();
    }

    @GameTest(m_177046_="botania:block/drum_gathering", m_177042_=25)
    public void testShearingBabySheep(GameTestHelper helper) {
        Sheep sheep = (Sheep)DrumBlockTest.setup(helper, EntityType.f_20520_, null);
        sheep.m_6863_(true);
        helper.m_177425_().m_177562_(() -> helper.m_177385_(POSITION_BUTTON)).m_177546_(20, () -> helper.m_246336_(sheep.m_6084_() && !sheep.m_29875_(), "Baby sheep should not be sheared")).m_177543_();
    }

    @GameTest(m_177046_="botania:block/drum_gathering", m_177042_=20)
    public void testShearingSnowGolem(GameTestHelper helper) {
        SnowGolem golem = (SnowGolem)DrumBlockTest.setup(helper, EntityType.f_20528_, null);
        helper.m_177425_().m_177562_(() -> helper.m_177385_(POSITION_BUTTON)).m_177552_(() -> helper.m_177194_(Items.f_42047_, POSITION_MOB, 1.0)).m_177562_(() -> helper.m_246336_(golem.m_6084_() && !golem.m_29930_(), "Snow golem should not wear a pumpkin")).m_177543_();
    }

    @GameTest(m_177046_="botania:block/drum_gathering", m_177042_=20)
    public void testShearingPumpkinlessSnowGolem(GameTestHelper helper) {
        SnowGolem golem = (SnowGolem)DrumBlockTest.setup(helper, EntityType.f_20528_, null);
        golem.m_29936_(false);
        helper.m_177425_().m_177562_(() -> helper.m_177385_(POSITION_BUTTON)).m_177546_(20, () -> helper.m_246336_(golem.m_6084_() && !golem.m_29930_(), "Snow golem should not wear a pumpkin")).m_177562_(() -> helper.m_236778_(Items.f_42047_, POSITION_MOB, 1.0)).m_177543_();
    }

    @GameTest(m_177046_="botania:block/drum_gathering", m_177042_=25)
    public void testShearingMooshroom(GameTestHelper helper) {
        DrumBlockTest.setup(helper, EntityType.f_20504_, null);
        helper.m_177425_().m_177562_(() -> helper.m_177385_(POSITION_BUTTON)).m_177546_(20, () -> helper.m_177309_(EntityType.f_20557_)).m_177543_();
    }
}

