/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wireless;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.peripheral.modem.ModemPeripheral;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemBlock;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemPeripheral;
import dan200.computercraft.shared.util.TickScheduler;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class WirelessModemBlockEntity
extends BlockEntity {
    private final boolean advanced;
    private final ModemPeripheral modem;
    @Nullable
    private Runnable modemChanged;
    private final TickScheduler.Token tickToken = new TickScheduler.Token(this);

    public WirelessModemBlockEntity(BlockEntityType<? extends WirelessModemBlockEntity> type, BlockPos pos, BlockState state, boolean advanced) {
        super(type, pos, state);
        this.advanced = advanced;
        this.modem = new Peripheral(this);
    }

    public void m_7651_() {
        super.m_7651_();
        this.modem.removed();
    }

    public void m_6339_() {
        super.m_6339_();
        TickScheduler.schedule(this.tickToken);
    }

    @Deprecated
    public void m_155250_(BlockState state) {
        Direction direction = this.getDirection();
        super.m_155250_(state);
        if (this.getDirection() != direction && this.modemChanged != null) {
            this.modemChanged.run();
        }
    }

    void blockTick() {
        if (this.modem.getModemState().pollChanged()) {
            this.updateBlockState();
        }
    }

    private Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)WirelessModemBlock.f_52588_);
    }

    private void updateBlockState() {
        boolean on = this.modem.getModemState().isOpen();
        BlockState state = this.m_58900_();
        if ((Boolean)state.m_61143_((Property)WirelessModemBlock.ON) != on) {
            this.m_58904_().m_46597_(this.m_58899_(), (BlockState)state.m_61124_((Property)WirelessModemBlock.ON, (Comparable)Boolean.valueOf(on)));
        }
    }

    @Nullable
    public IPeripheral getPeripheral(@Nullable Direction direction) {
        return direction == null || this.getDirection() == direction ? this.modem : null;
    }

    public void onModemChanged(Runnable callback) {
        this.modemChanged = callback;
    }

    private static class Peripheral
    extends WirelessModemPeripheral {
        private final WirelessModemBlockEntity entity;

        Peripheral(WirelessModemBlockEntity entity) {
            super(new ModemState(() -> TickScheduler.schedule(entity.tickToken)), entity.advanced);
            this.entity = entity;
        }

        @Override
        public Level getLevel() {
            return this.entity.m_58904_();
        }

        @Override
        public Vec3 getPosition() {
            return Vec3.m_82528_((Vec3i)this.entity.m_58899_().m_121945_(this.entity.getDirection()));
        }

        @Override
        public boolean equals(@Nullable IPeripheral other) {
            return this == other || other instanceof Peripheral && this.entity == ((Peripheral)other).entity;
        }

        @Override
        public Object getTarget() {
            return this.entity;
        }
    }
}

