/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.entity;

import dev.architectury.networking.NetworkManager;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.particle.ParticleTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;

public class TimeAcceleratorEntity
extends Entity {
    public static final String TIMES_ACCELERATED = "timesAccelerated";
    public static final String TICKS_REMAINING = "ticksRemaining";
    private static final EntityDataAccessor<Integer> timesAccelerated = SynchedEntityData.m_135353_(TimeAcceleratorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ticksRemaining = SynchedEntityData.m_135353_(TimeAcceleratorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public TimeAcceleratorEntity(EntityType<? extends TimeAcceleratorEntity> type, Level level) {
        super(type, level);
        this.f_19804_.m_135381_(timesAccelerated, (Object)0);
        this.f_19804_.m_135381_(ticksRemaining, (Object)0);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(timesAccelerated, (Object)0);
        this.f_19804_.m_135372_(ticksRemaining, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        BlockPos pos = this.m_20183_();
        Level level = this.m_9236_();
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        BlockState state = level.m_8055_(pos);
        BlockEntity be = level.m_7702_(pos);
        for (int i = 0; i < this.getSpeedMultiplier() - 1; ++i) {
            if (be != null) {
                BlockEntityTicker ticker = be.m_58900_().m_155944_(level, be.m_58903_());
                if (ticker == null) continue;
                ticker.m_155252_(level, pos, state, be);
                continue;
            }
            if (state.m_60823_()) {
                int randomChance;
                if (level.m_5776_() || (randomChance = (Integer)GAGConfig.SandsOfTime.RANDOM_TICK_CHANCE.get() / level.m_46469_().m_46215_(GameRules.f_46143_)) != 0 && level.f_46441_.m_188503_(randomChance) != 0) continue;
                state.m_222972_((ServerLevel)level, pos, level.f_46441_);
                continue;
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
            break;
        }
        double particleChance = (double)this.getTimesAccelerated() / (double)((Integer)GAGConfig.SandsOfTime.MAX_RATE.get()).intValue() * (double)this.getTicksRemaining() / (double)((Integer)GAGConfig.SandsOfTime.DURATION_PER_USE.get() * 20);
        if (this.f_19796_.m_188500_() < particleChance) {
            SimpleParticleType magic = (SimpleParticleType)ParticleTypeRegistry.MAGIC.get();
            level.m_7106_((ParticleOptions)magic, (double)x, (double)y + 0.05 + (double)this.f_19796_.m_188501_(), (double)((float)z + this.f_19796_.m_188501_()), 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)magic, (double)x + 1.0, (double)y + 0.05 + (double)this.f_19796_.m_188501_(), (double)((float)z + this.f_19796_.m_188501_()), 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)magic, (double)((float)x + this.f_19796_.m_188501_()), (double)y + 0.05 + (double)this.f_19796_.m_188501_(), (double)z, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)magic, (double)((float)x + this.f_19796_.m_188501_()), (double)y + 0.05 + (double)this.f_19796_.m_188501_(), (double)z + 1.0, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)magic, (double)((float)x + this.f_19796_.m_188501_()), (double)y + 1.1, (double)((float)z + this.f_19796_.m_188501_()), 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)magic, (double)((float)x + this.f_19796_.m_188501_()), (double)y - 0.05, (double)((float)z + this.f_19796_.m_188501_()), 0.0, 0.0, 0.0);
        }
        if (this.getTicksRemaining() <= 0 && !level.f_46443_) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        this.setTicksRemaining(this.getTicksRemaining() - 1);
    }

    protected void m_7378_(CompoundTag compound) {
        this.f_19804_.m_135381_(timesAccelerated, (Object)compound.m_128451_(TIMES_ACCELERATED));
        this.f_19804_.m_135381_(ticksRemaining, (Object)compound.m_128451_(TICKS_REMAINING));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_(TIMES_ACCELERATED, this.getTimesAccelerated());
        compound.m_128405_(TICKS_REMAINING, this.getTicksRemaining());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public int getSpeedMultiplier() {
        return 1 << this.getTimesAccelerated();
    }

    public int getTimesAccelerated() {
        return (Integer)this.f_19804_.m_135370_(timesAccelerated);
    }

    public void setTimesAccelerated(int rate) {
        this.f_19804_.m_135381_(timesAccelerated, (Object)rate);
    }

    public int getTicksRemaining() {
        return (Integer)this.f_19804_.m_135370_(ticksRemaining);
    }

    public void setTicksRemaining(int ticks) {
        this.f_19804_.m_135381_(ticksRemaining, (Object)ticks);
    }
}

