/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.dimpaintings.datagen;

import com.mrbysco.dimpaintings.registry.PaintingRegistry;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PaintingDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new PaintingRecipeProvider(packOutput));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new PaintingLanguageProvider(packOutput));
            generator.addProvider(true, (DataProvider)new PaintingItemModelProvider(packOutput, helper));
        }
    }

    private static class PaintingRecipeProvider
    extends RecipeProvider {
        public PaintingRecipeProvider(PackOutput packOutput) {
            super(packOutput);
        }

        protected void m_245200_(Consumer<FinishedRecipe> consumer) {
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)PaintingRegistry.OVERWORLD_PAINTING.get())).m_126130_("DDD").m_126130_("DPD").m_126130_("DDD").m_206416_(Character.valueOf('D'), ItemTags.f_13182_).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42487_).m_126132_("has_painting", (CriterionTriggerInstance)PaintingRecipeProvider.m_125977_((ItemLike)Items.f_42487_)).m_126132_("has_logs", (CriterionTriggerInstance)PaintingRecipeProvider.m_206406_((TagKey)ItemTags.f_13182_)).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)PaintingRegistry.NETHER_PAINTING.get())).m_126130_("OOO").m_126130_("OPO").m_126130_("OOO").m_206416_(Character.valueOf('O'), Tags.Items.OBSIDIAN).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42487_).m_126132_("has_painting", (CriterionTriggerInstance)PaintingRecipeProvider.m_125977_((ItemLike)Items.f_42487_)).m_126132_("has_obsidian", (CriterionTriggerInstance)PaintingRecipeProvider.m_206406_((TagKey)Tags.Items.OBSIDIAN)).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)PaintingRegistry.END_PAINTING.get())).m_126130_("EEE").m_126130_("EPE").m_126130_("EEE").m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42545_).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42487_).m_126132_("has_painting", (CriterionTriggerInstance)PaintingRecipeProvider.m_125977_((ItemLike)Items.f_42487_)).m_126132_("has_ender_eye", (CriterionTriggerInstance)PaintingRecipeProvider.m_125977_((ItemLike)Items.f_42545_)).m_176498_(consumer);
        }
    }

    private static class PaintingLanguageProvider
    extends LanguageProvider {
        public PaintingLanguageProvider(PackOutput packOutput) {
            super(packOutput, "dimpaintings", "en_us");
        }

        protected void addTranslations() {
            this.add("itemGroup.dimpaintings", "Dimensional Paintings");
            this.addItem((Supplier)PaintingRegistry.OVERWORLD_PAINTING, "Overworld Painting");
            this.addItem((Supplier)PaintingRegistry.NETHER_PAINTING, "Nether Painting");
            this.addItem((Supplier)PaintingRegistry.END_PAINTING, "End Painting");
            this.add("dimpaintings.same_dimension", "Can't teleport to the same dimension");
            this.add("dimpaintings.cooldown", "Teleportation on cooldown");
            this.addEntityType((Supplier)PaintingRegistry.DIMENSIONAL_PAINTING, "Dimensional Painting");
        }
    }

    private static class PaintingItemModelProvider
    extends ItemModelProvider {
        public PaintingItemModelProvider(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "dimpaintings", helper);
        }

        protected void registerModels() {
            PaintingRegistry.ITEMS.getEntries().stream().forEach(item -> {
                String path = Objects.requireNonNull(item.getId()).m_135815_();
                this.singleTexture(path, this.modLoc("item/base_painting"), "layer0", this.modLoc("item/" + path));
            });
        }
    }
}

