/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.entity.GraveGuardian;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModItems;

@OnlyIn(value=Dist.CLIENT)
public final class GraveGuardianArmorLayer<T extends GraveGuardian, M extends SkeletonModel<T>>
extends HumanoidArmorLayer<T, M, SkeletonModel<T>> {
    private final SkeletonModel<T> innerModel;
    private final SkeletonModel<T> outerModel;
    private final ItemInHandRenderer itemInHandRenderer;
    private final TextureAtlas armorTrimAtlas;
    private static final Supplier<ItemStack> HALLOWEEN_HELMET = Suppliers.memoize(() -> ((Item)Items.f_42055_).m_7968_());
    private static final Supplier<ItemStack> CHRISTMAS_HELMET = Suppliers.memoize(ModItems.christmas_hat::m_7968_);
    private static final Supplier<ItemStack> EASTER_MASK = Suppliers.memoize(ModItems.rabbit_mask::m_7968_);

    public GraveGuardianArmorLayer(RenderLayerParent<T, M> parent, EntityRendererProvider.Context context) {
        this(parent, new SkeletonModel(context.m_174023_(ModelLayers.f_171248_)), new SkeletonModel(context.m_174023_(ModelLayers.f_171249_)), context);
    }

    public GraveGuardianArmorLayer(RenderLayerParent<T, M> parent, SkeletonModel<T> innerModel, SkeletonModel<T> outerModel, EntityRendererProvider.Context context) {
        super(parent, innerModel, outerModel, context.m_266367_());
        this.innerModel = innerModel;
        this.outerModel = outerModel;
        this.itemInHandRenderer = context.m_234598_();
        this.armorTrimAtlas = context.m_266367_().m_119428_(Sheets.f_265912_);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, T graveGuardian, float p_117100_, float p_117101_, float p_117102_, float p_117103_, float p_117104_, float p_117105_) {
        this.renderArmorPiece(poseStack, bufferSource, graveGuardian, EquipmentSlot.CHEST, light, this.getArmorModel(EquipmentSlot.CHEST));
        this.renderArmorPiece(poseStack, bufferSource, graveGuardian, EquipmentSlot.LEGS, light, this.getArmorModel(EquipmentSlot.LEGS));
        this.renderArmorPiece(poseStack, bufferSource, graveGuardian, EquipmentSlot.FEET, light, this.getArmorModel(EquipmentSlot.FEET));
        this.renderArmorPiece(poseStack, bufferSource, graveGuardian, EquipmentSlot.HEAD, light, this.getArmorModel(EquipmentSlot.HEAD));
    }

    private void renderArmorPiece(PoseStack poseStack, MultiBufferSource bufferSource, T graveGuardian, EquipmentSlot slot, int light, SkeletonModel<T> model) {
        ItemStack specialHelmet;
        if (slot == EquipmentSlot.HEAD && !(specialHelmet = this.getSpecialHelmet()).m_41619_()) {
            this.renderSpecialHelmet(poseStack, bufferSource, graveGuardian, specialHelmet);
            return;
        }
        ItemStack stack = graveGuardian.m_6844_(slot);
        Item item = stack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            if (armor.m_40402_() == slot) {
                float b;
                float g;
                float r;
                ((SkeletonModel)this.m_117386_()).m_102872_(model);
                this.m_117125_((HumanoidModel)model, slot);
                Model armorModel = this.getArmorModelHook((LivingEntity)graveGuardian, stack, slot, (HumanoidModel)model);
                boolean hasFoil = false;
                VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)bufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)this.getArmorResource((Entity)graveGuardian, stack, slot, null)), (boolean)false, (boolean)hasFoil);
                if (TimeHelper.isDateAroundHalloween()) {
                    r = 1.0f;
                    g = 0.4f;
                    b = 0.0f;
                    light = 0xF000F0;
                } else if (TimeHelper.isDateAroundChristmas()) {
                    r = 1.0f;
                    g = 0.0f;
                    b = 0.0f;
                } else if (TimeHelper.isDateAroundEaster()) {
                    r = 1.0f;
                    g = 0.0f;
                    b = 1.0f;
                } else {
                    r = 0.0f;
                    g = 1.0f;
                    b = 1.0f;
                }
                armorModel.m_7695_(poseStack, vertexconsumer, light, OverlayTexture.f_118083_, r, g, b, 1.0f);
                ArmorTrim armorTrim = this.getArmorTrim();
                if (armorTrim != null) {
                    this.renderTrim(armor.m_40401_(), poseStack, bufferSource, light, armorTrim, (Model)model, slot == EquipmentSlot.LEGS);
                }
            }
        } else if (slot == EquipmentSlot.HEAD && stack.m_150930_(Items.f_42055_)) {
            this.renderSpecialHelmet(poseStack, bufferSource, graveGuardian, stack);
        }
    }

    @Nullable
    private ArmorTrim getArmorTrim() {
        RegistryAccess registryAccess = Optional.ofNullable(Minecraft.m_91087_().f_91073_).map(Level::m_9598_).orElse(null);
        if (registryAccess != null) {
            ResourceKey trimMaterialRK;
            return new ArmorTrim((Holder)registryAccess.m_255025_(Registries.f_266076_).m_255043_(trimMaterialRK), (Holder)registryAccess.m_255025_(Registries.f_266063_).m_255043_(switch (TimeHelper.getSpecialEvent()) {
                case TimeHelper.SpecialEvent.CHRISTMAS -> {
                    trimMaterialRK = TrimMaterials.f_265905_;
                    yield TrimPatterns.f_265941_;
                }
                case TimeHelper.SpecialEvent.HALLOWEEN -> {
                    trimMaterialRK = TrimMaterials.f_265969_;
                    yield TrimPatterns.f_276510_;
                }
                case TimeHelper.SpecialEvent.EASTER, TimeHelper.SpecialEvent.APRIL_FOOLS -> {
                    trimMaterialRK = TrimMaterials.f_265872_;
                    yield TrimPatterns.f_265901_;
                }
                default -> {
                    trimMaterialRK = TrimMaterials.f_265937_;
                    yield TrimPatterns.f_266074_;
                }
            }));
        }
        return null;
    }

    private void renderTrim(ArmorMaterial armorMaterial, PoseStack poseStack, MultiBufferSource bufferSource, int light, ArmorTrim armorTrim, Model model, boolean useInnerModel) {
        TextureAtlasSprite sprite = this.armorTrimAtlas.m_118316_(useInnerModel ? armorTrim.m_267774_(armorMaterial) : armorTrim.m_267606_(armorMaterial));
        VertexConsumer vertexconsumer = sprite.m_118381_(bufferSource.m_6299_(Sheets.m_266442_()));
        model.m_7695_(poseStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderSpecialHelmet(PoseStack poseStack, MultiBufferSource bufferSource, T graveGuardian, ItemStack specialHelmet) {
        poseStack.m_85836_();
        ((SkeletonModel)this.m_117386_()).m_5585_().m_104299_(poseStack);
        CustomHeadLayer.m_174483_((PoseStack)poseStack, (boolean)false);
        this.itemInHandRenderer.m_269530_(graveGuardian, specialHelmet, ItemDisplayContext.HEAD, false, poseStack, bufferSource, 0xF000F0);
        poseStack.m_85849_();
    }

    private SkeletonModel<T> getArmorModel(EquipmentSlot slot) {
        return slot == EquipmentSlot.LEGS ? this.innerModel : this.outerModel;
    }

    private ItemStack getSpecialHelmet() {
        return TimeHelper.isDateAroundHalloween() ? HALLOWEEN_HELMET.get() : (TimeHelper.isDateAroundChristmas() ? CHRISTMAS_HELMET.get() : (TimeHelper.isDateAroundEaster() ? EASTER_MASK.get() : ItemStack.f_41583_));
    }
}

