/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.event.ClientEventHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.helper.WorldHelper;
import ovh.corail.tombstone.item.ItemGeneric;

public abstract class ItemSearchable
extends ItemGeneric {
    protected static final String TARGET_FOUND_NBT_BOOL = "target_found";
    protected static final String SEARCH_COOLDOWN_NBT_LONG = "search_cooldown";
    protected static final String TARGET_NBT_LOCATION = "target_location";

    protected ItemSearchable(String name, BooleanSupplier supplierEnabled) {
        super(name, ItemSearchable.getBuilder().m_41487_(1).m_41486_(), supplierEnabled);
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        this.addItemDesc(tooltip);
        if (Optional.ofNullable(ModTombstone.PROXY.getClientPlayer()).map(p -> !this.isInVillageRange((Player)p, stack)).orElse(true).booleanValue()) {
            this.addItemDistance(tooltip, this.getCurrentTarget(stack));
        }
        this.addItemUse(tooltip, this.isTargetFound(stack) ? "2" : "1", new Object[0]);
        super.addTooltipInfo(stack, level, tooltip);
    }

    public Component m_7626_(ItemStack stack) {
        return super.m_7626_(stack).m_6879_().m_6270_(StyleType.MESSAGE_SPECIAL);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (EntityHelper.isValidPlayer(context.m_43723_()) && this.isTargetFound(stack) && this.isInVillageRange(context.m_43723_(), stack) && context.m_8083_().equals((Object)this.getCurrentTarget(stack).getPos())) {
            if (!context.m_43723_().m_9236_().m_5776_()) {
                this.giveReward((ServerPlayer)context.m_43723_(), context.m_8083_());
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (stack.m_150930_((Item)this) && level != null && EntityHelper.isValidPlayer(entity)) {
            if (level.m_5776_()) {
                if (isSelected && entity.equals((Object)ModTombstone.PROXY.getClientPlayer())) {
                    ClientEventHandler.toDisplay = this.getMessageToDisplay((Player)entity, stack);
                }
            } else {
                ServerPlayer player = (ServerPlayer)entity;
                if (this.getCurrentTarget(stack).isOrigin()) {
                    if (NBTStackHelper.hasTimer(TimeHelper.worldTicks(player.m_9236_()), stack, SEARCH_COOLDOWN_NBT_LONG, 1200)) {
                        return;
                    }
                    assert (player.m_20194_() != null);
                    int d1 = (Helper.RANDOM.nextBoolean() ? -400 : 400) + Helper.RANDOM.nextInt(401) - 200;
                    int d2 = Helper.RANDOM.nextInt(1001) - 500;
                    boolean inverse = Helper.RANDOM.nextBoolean();
                    Location loc = WorldHelper.findNearestVillage(player.m_20194_().m_129783_(), player.m_20183_().m_7918_(inverse ? d2 : d1, 0, inverse ? d1 : d2));
                    if (loc.isOrigin()) {
                        NBTStackHelper.setLong(stack, SEARCH_COOLDOWN_NBT_LONG, TimeHelper.worldTicks(player.m_9236_()) + 1200L);
                    } else {
                        NBTStackHelper.setLocation(stack, TARGET_NBT_LOCATION, loc);
                    }
                } else if (!this.isTargetFound(stack) && this.isInVillageRange((Player)player, stack) && Helper.RANDOM.nextInt(10) == 0) {
                    BlockPos playerPos = player.m_20183_();
                    Helper.getRandomInList(player.m_9236_().m_6325_(SectionPos.m_123171_((int)playerPos.m_123341_()) + Helper.RANDOM.nextInt(3) - 1, SectionPos.m_123171_((int)playerPos.m_123343_()) + Helper.RANDOM.nextInt(3) - 1).m_62954_().entrySet().stream().filter(entry -> this.getTargetType().equals((Object)((BlockEntity)entry.getValue()).m_58903_())).map(Map.Entry::getKey).collect(Collectors.toList())).ifPresent(pos -> {
                        NBTStackHelper.setBoolean(stack, TARGET_FOUND_NBT_BOOL, true);
                        NBTStackHelper.setLocation(stack, TARGET_NBT_LOCATION, new Location((BlockPos)pos, player.m_9236_()));
                    });
                }
            }
        }
    }

    public boolean isTargetFound(ItemStack stack) {
        return NBTStackHelper.getBoolean(stack, TARGET_FOUND_NBT_BOOL);
    }

    public Location getCurrentTarget(ItemStack stack) {
        return NBTStackHelper.getLocation(stack, TARGET_NBT_LOCATION);
    }

    public boolean isInVillageRange(Player player, ItemStack stack) {
        double dz;
        if (!player.m_9236_().m_46472_().equals((Object)Level.f_46428_)) {
            return false;
        }
        Location targetLocation = this.getCurrentTarget(stack);
        if (targetLocation.isOrigin()) {
            return false;
        }
        double dx = (double)targetLocation.x + 0.5 - player.m_20185_();
        return dx * dx + (dz = (double)targetLocation.z + 0.5 - player.m_20189_()) * dz < 900.0;
    }

    protected abstract void giveReward(ServerPlayer var1, BlockPos var2);

    protected abstract BlockEntityType<? extends BlockEntity> getTargetType();

    protected abstract String getMessageToDisplay(Player var1, ItemStack var2);
}

