/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.item.ItemBook;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfOblivion
extends ItemBook {
    public ItemBookOfOblivion() {
        super("book_of_oblivion", () -> SharedConfigTombstone.allowed_magic_items.allowBookOfOblivion.get());
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (stack.m_41720_() != this) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_PERK_RESET_FAILED.getText(new Object[0]));
        }
        int cd = CooldownHandler.INSTANCE.getCooldown((Player)player, CooldownType.RESET_PERKS);
        if (cd > 0) {
            int min = cd / 1200;
            if (min > 0) {
                cd -= min * 1200;
            }
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_PERK_RESET_IN_COOLDOWN.getText(min, cd / 20));
        }
        Map perks = player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getPerks).orElse(new HashMap());
        if (perks.entrySet().stream().anyMatch(entry -> entry.getKey() != null && (Integer)entry.getValue() > 0 && !((Perk)entry.getKey()).isDisabled((Player)player))) {
            CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.RESET_PERKS);
            player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.resetPerks(player));
            stack.m_41774_(1);
            ModTriggers.USE_OBLIVION.trigger(player);
            return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_PERK_RESET_SUCCESS.getText(new Object[0]), 1);
        }
        return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_PERK_RESET_FAILED.getText(new Object[0]));
    }

    @Override
    public int getKnowledge() {
        return 0;
    }
}

