/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.FriendlyAnimalProvider;
import ovh.corail.tombstone.capability.ServantEntityProvider;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.PrayerHelper;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.registry.ModTags;

public enum TamableType {
    TAMABLE(e -> e instanceof TamableAnimal, (player, entity) -> ((TamableAnimal)entity).m_21828_(player), entity -> ((TamableAnimal)entity).m_21805_(), (entity, tag) -> {}),
    HORSE(e -> e instanceof AbstractHorse && e.m_6095_() != EntityType.f_20488_, (player, entity) -> ((AbstractHorse)entity).m_30637_(player), entity -> ((AbstractHorse)entity).m_21805_(), (entity, tag) -> {
        if (entity instanceof AbstractChestedHorse) {
            ((AbstractChestedHorse)entity).m_30504_(false);
        }
    }),
    FRIENDLY_ANIMAL(e -> e instanceof Fox, (player, entity) -> entity.getCapability(FriendlyAnimalProvider.FRIENDLY_ANIMAL_CAPABILITY).ifPresent(cap -> {
        UUID playerUUID = player.m_36316_().getId();
        ((Fox)entity).m_28515_(playerUUID);
        cap.setOwnerId(playerUUID);
        cap.setAI((PathfinderMob)entity);
    }), entity -> EntityHelper.getFriendlyOwnerId(entity).orElse(null), (entity, tag) -> {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            entity.m_8061_(slot, ItemStack.f_41583_);
        }
    }),
    UNDEAD(PrayerHelper::isValidUndead, (player, entity) -> entity.getCapability(ServantEntityProvider.SERVANT_ENTITY_CAPABILITY).ifPresent(cap -> {
        cap.setOwnerId(player.m_36316_().getId());
        cap.setAI((PathfinderMob)entity);
    }), entity -> EntityHelper.getServantOwnerId(entity).orElse(null), (entity, tag) -> {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            entity.m_8061_(slot, ItemStack.f_41583_);
        }
    });

    final Predicate<Entity> predic;
    final BiConsumer<Player, Entity> tame;
    final Function<Entity, UUID> ownerId;
    final BiConsumer<Entity, CompoundTag> onCapture;
    static final Map<ResourceLocation, TamableType> TAMABLE_TYPE;
    static final Set<ResourceLocation> SUMMONABLE_TYPE;
    static final ResourceLocation DEFAULT_TAMABLE;

    private TamableType(Predicate<Entity> predic, BiConsumer<Player, Entity> tame, Function<Entity, UUID> ownerId, BiConsumer<Entity, CompoundTag> onCapture) {
        this.predic = predic;
        this.tame = tame;
        this.ownerId = ownerId;
        this.onCapture = onCapture;
    }

    public static void init(Level level) {
        if (!TAMABLE_TYPE.isEmpty() || !SUMMONABLE_TYPE.isEmpty()) {
            return;
        }
        for (Map.Entry entry : ForgeRegistries.ENTITY_TYPES.getEntries()) {
            try {
                Entity entity = ((EntityType)entry.getValue()).m_20615_(level);
                if (entity == null || entity.m_6095_().m_204039_(ModTags.EntityTypes.UNHANDLED_TAMABLE)) continue;
                ResourceLocation registryRL = ((ResourceKey)entry.getKey()).m_135782_();
                Arrays.stream(TamableType.values()).filter(t -> t.predic.test(entity)).findFirst().ifPresent(tamable -> TAMABLE_TYPE.put(registryRL, (TamableType)((Object)tamable)));
                if (!((EntityType)entry.getValue()).m_20654_() || !(entity instanceof Mob)) continue;
                SUMMONABLE_TYPE.add(registryRL);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void clear() {
        TAMABLE_TYPE.clear();
        SUMMONABLE_TYPE.clear();
    }

    public boolean is(@Nullable Entity entity) {
        return Optional.ofNullable(entity).map(Entity::m_6095_).map(RegistryHelper::getRegistryName).map(rl -> TamableType.getType(rl) == this).orElse(false);
    }

    public static void setTamedBy(Player player, Entity entity) {
        Optional.ofNullable(TamableType.getType(entity)).ifPresent(t -> t.tame.accept(player, entity));
    }

    public static boolean isTamedBy(LivingEntity owner, Entity entity) {
        return Optional.ofNullable(TamableType.getType(entity)).map(t -> t.getOwnerId(entity)).map(id -> id.equals(owner.m_20148_())).orElse(false);
    }

    @Nullable
    public UUID getOwnerId(Entity entity) {
        return this.ownerId.apply(entity);
    }

    public void onCapture(Entity entity, CompoundTag tag) {
        this.onCapture.accept(entity, tag);
    }

    public static boolean isTamable(ResourceLocation entityTypeRL) {
        return TamableType.getType(entityTypeRL) != null;
    }

    @Nullable
    public static TamableType getType(@Nullable Entity entity) {
        return Optional.ofNullable(entity).map(Entity::m_6095_).map(RegistryHelper::getRegistryName).map(TamableType::getType).orElse(null);
    }

    @Nullable
    public static TamableType getType(ResourceLocation entityTypeRL) {
        return TAMABLE_TYPE.get(entityTypeRL);
    }

    public static ResourceLocation getRandomTamableEntityType() {
        return Helper.getRandomInList(new ArrayList<ResourceLocation>(TAMABLE_TYPE.keySet())).orElse(DEFAULT_TAMABLE);
    }

    public static ResourceLocation getRandomSummonableEntityType() {
        return Helper.getRandomInList(SUMMONABLE_TYPE).orElse(DEFAULT_TAMABLE);
    }

    static {
        TAMABLE_TYPE = new ConcurrentHashMap<ResourceLocation, TamableType>();
        SUMMONABLE_TYPE = ConcurrentHashMap.newKeySet();
        DEFAULT_TAMABLE = new ResourceLocation("minecraft", "cat");
    }
}

