/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.FishingHookPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.item.IDisableable;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.RandomWeightedItem;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.helper.UpdaterHandler;
import ovh.corail.tombstone.loot.CheckEnableFunction;
import ovh.corail.tombstone.loot.DelayedNBTFunction;
import ovh.corail.tombstone.loot.EnchantedEquipmentFunction;
import ovh.corail.tombstone.loot.RandomInTagFunction;
import ovh.corail.tombstone.loot.RandomMagicTabletFunction;
import ovh.corail.tombstone.loot.RandomPotionFunction;
import ovh.corail.tombstone.loot.RandomScrollBuffFunction;
import ovh.corail.tombstone.loot.TriggerCatMorningFunction;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModPotions;
import ovh.corail.tombstone.registry.ModTriggers;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class LootHelper {
    private static final Map<TagKey<Item>, RandomWeightedItem> GENERATOR_BY_TAG = new ConcurrentHashMap<TagKey<Item>, RandomWeightedItem>();
    private static final Map<UpdaterHandler.PoolType, LootTable> CUSTOM_LOOTTABLES = new ConcurrentHashMap<UpdaterHandler.PoolType, LootTable>();
    private static final List<LootTable> ALL_LOOTTABLES = new ArrayList<LootTable>();
    private static final Field FIELD_IS_FROZEN = ObfuscationReflectionHelper.findField(LootTable.class, (String)"isFrozen");

    public static RandomWeightedItem getItemGenerator(TagKey<Item> tagKey) {
        return GENERATOR_BY_TAG.computeIfAbsent(tagKey, RandomWeightedItem::new);
    }

    public static void clear() {
        GENERATOR_BY_TAG.clear();
    }

    private static void addEntry(LootPool.Builder builder, Item item, int weight, LootItemFunction.Builder ... lootItemFunctionBuilders) {
        LootPoolSingletonContainer.Builder lootBuilder = LootItem.m_79579_((ItemLike)item).m_79711_(0).m_79707_(weight);
        if (item instanceof IDisableable) {
            lootBuilder.m_79078_((LootItemFunction.Builder)new CheckEnableFunction.Builder());
        }
        for (LootItemFunction.Builder b : lootItemFunctionBuilders) {
            lootBuilder.m_79078_(b);
        }
        builder.m_79076_((LootPoolEntryContainer.Builder)lootBuilder);
    }

    private static void addPotion(LootPool.Builder builder, Potion potion, int weight) {
        LootPoolSingletonContainer.Builder lootBuilder = LootItem.m_79579_((ItemLike)Items.f_42589_).m_79711_(0).m_79707_(weight);
        lootBuilder.m_79078_((LootItemFunction.Builder)SetPotionFunction.m_193075_((Potion)potion));
        builder.m_79076_((LootPoolEntryContainer.Builder)lootBuilder);
    }

    private static void addRandomPotion(LootPool.Builder builder, int weight) {
        LootPoolSingletonContainer.Builder lootBuilder = LootItem.m_79579_((ItemLike)Items.f_42589_).m_79711_(0).m_79707_(weight);
        lootBuilder.m_79078_((LootItemFunction.Builder)new RandomPotionFunction.Builder());
        builder.m_79076_((LootPoolEntryContainer.Builder)lootBuilder);
    }

    private static void addEnchantedEquipment(LootPool.Builder builder, EnchantedEquipmentFunction.Type equipmentType, int randomEnchantability, int weight) {
        LootPoolSingletonContainer.Builder lootBuilder = LootItem.m_79579_((ItemLike)Items.f_42517_).m_79711_(0).m_79707_(weight);
        lootBuilder.m_79078_((LootItemFunction.Builder)new EnchantedEquipmentFunction.Builder(equipmentType, false, 50, randomEnchantability));
        builder.m_79076_((LootPoolEntryContainer.Builder)lootBuilder);
    }

    private static void addRandomScrollBuff(LootPool.Builder builder, boolean isAncient, int weight) {
        LootPoolSingletonContainer.Builder lootBuilder = LootItem.m_79579_((ItemLike)ModItems.strange_scroll).m_79711_(0).m_79707_(weight);
        lootBuilder.m_79078_((LootItemFunction.Builder)new RandomScrollBuffFunction.Builder(isAncient));
        builder.m_79076_((LootPoolEntryContainer.Builder)lootBuilder);
    }

    private static void addRandomMagicScroll(LootPool.Builder builder, boolean isAncient, int weight) {
        LootPoolSingletonContainer.Builder lootBuilder = LootItem.m_79579_((ItemLike)ModItems.magic_scroll).m_79711_(0).m_79707_(weight);
        lootBuilder.m_79078_((LootItemFunction.Builder)new DelayedNBTFunction.Builder());
        if (isAncient) {
            lootBuilder.m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)((CompoundTag)Util.m_137469_((Object)new CompoundTag(), nbt -> nbt.m_128379_("ancient", true)))));
        }
        builder.m_79076_((LootPoolEntryContainer.Builder)lootBuilder);
    }

    private static void addRandomMagicTablet(LootPool.Builder builder, boolean isAncient, int weight) {
        LootPoolSingletonContainer.Builder lootBuilder = LootItem.m_79579_((ItemLike)ModItems.strange_tablet).m_79711_(0).m_79707_(weight);
        lootBuilder.m_79078_((LootItemFunction.Builder)new RandomMagicTabletFunction.Builder(isAncient));
        builder.m_79076_((LootPoolEntryContainer.Builder)lootBuilder);
    }

    private static void addRandomEnchantedBook(LootPool.Builder builder, int weight) {
        LootPoolSingletonContainer.Builder lootBuilder = LootItem.m_79579_((ItemLike)Items.f_42517_).m_79711_(0).m_79707_(weight);
        lootBuilder.m_79078_((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder());
        builder.m_79076_((LootPoolEntryContainer.Builder)lootBuilder);
    }

    private static void addDelayedNBTEntry(LootPool.Builder builder, Item item, int weight, LootItemFunction.Builder ... lootItemFunctionBuilders) {
        LootPoolSingletonContainer.Builder lootBuilder = LootItem.m_79579_((ItemLike)item).m_79711_(0).m_79707_(weight);
        lootBuilder.m_79078_((LootItemFunction.Builder)new DelayedNBTFunction.Builder());
        for (LootItemFunction.Builder b : lootItemFunctionBuilders) {
            lootBuilder.m_79078_(b);
        }
        builder.m_79076_((LootPoolEntryContainer.Builder)lootBuilder);
    }

    private static LootPool getSnifferDigging() {
        LootPool.Builder builder = LootPool.m_79043_().name("tombstone:sniffer_digging");
        LootHelper.addEntry(builder, ModItems.grave_dust, 10, new LootItemFunction.Builder[0]);
        builder.m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79711_(0).m_79707_(90));
        return builder.m_79082_();
    }

    private static LootPool getSeekerRodLootPool() {
        LootPool.Builder builder = LootPool.m_79043_().name("tombstone:seeker_rod");
        LootHelper.addEntry(builder, ModItems.essence_of_undeath, 5, new LootItemFunction.Builder[0]);
        LootHelper.addEntry(builder, ModItems.receptacle_of_soul, 15, new LootItemFunction.Builder[0]);
        LootHelper.addEntry(builder, ModItems.gemstone_of_familiar, 25, new LootItemFunction.Builder[0]);
        LootHelper.addDelayedNBTEntry(builder, ModItems.receptacle_of_familiar, 25, new LootItemFunction.Builder[0]);
        LootHelper.addPotion(builder, ModPotions.restoration, 10);
        LootHelper.addRandomScrollBuff(builder, true, 20);
        return builder.m_79082_();
    }

    public static ItemStack getSeekerRodReward(ServerLevel level, BlockPos pos, Player player) {
        LootParams lootParams = new LootParams.Builder(level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287239_(player.m_36336_()).m_287286_(LootContextParams.f_81455_, (Object)player).m_287235_(LootContextParamSets.f_81416_);
        return LootHelper.getLootTable(UpdaterHandler.PoolType.SEEKER_ROD).m_287195_(lootParams).stream().findFirst().orElse(new ItemStack((ItemLike)Items.f_42436_));
    }

    private static LootPool getLostTreasureLootPool() {
        LootPool.Builder builder = LootPool.m_79043_().name("tombstone:lost_treasure").m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_218800_((EntitySubPredicate)FishingHookPredicate.m_39766_((boolean)true))));
        int weight = 0;
        LootHelper.addEntry(builder, ModItems.essence_of_undeath, 10, new LootItemFunction.Builder[0]);
        weight += 10;
        LootHelper.addEntry(builder, Items.f_42517_, 40, new LootItemFunction.Builder[]{new RandomInTagFunction.Builder((TagKey<Item>)ItemTags.f_271220_)});
        weight += 40;
        LootHelper.addEntry(builder, Items.f_151058_, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, ModItems.bag_of_seeds, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addRandomMagicTablet(builder, true, 15);
        weight += 15;
        LootHelper.addDelayedNBTEntry(builder, ModItems.scroll_of_knowledge, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addRandomMagicScroll(builder, false, 50);
        weight += 50;
        LootHelper.addEntry(builder, ModItems.gemstone_of_familiar, 10, new LootItemFunction.Builder[0]);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, ModItems.voodoo_poppet, 10, new LootItemFunction.Builder[0]);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, ModItems.receptacle_of_familiar, 10, new LootItemFunction.Builder[0]);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, (Item)ModItems.fishing_rod_of_misadventure, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, ModItems.lost_tablet, 100, new LootItemFunction.Builder[0]);
        if ((weight += 100) < 1000) {
            builder.m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79711_(0).m_79707_(1000 - weight));
        }
        return builder.m_79082_();
    }

    private static LootPool getArcheologyLootPool() {
        LootPool.Builder builder = LootPool.m_79043_().name("tombstone:archeology_treasure");
        int weight = 0;
        LootHelper.addEntry(builder, ModItems.essence_of_undeath, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, ModItems.receptacle_of_soul, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addRandomMagicTablet(builder, false, 300);
        weight += 300;
        LootHelper.addRandomMagicTablet(builder, true, 150);
        weight += 150;
        LootHelper.addEntry(builder, ModItems.gemstone_of_familiar, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addDelayedNBTEntry(builder, ModItems.receptacle_of_familiar, 50, new LootItemFunction.Builder[0]);
        if ((weight += 50) < 1000) {
            builder.m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79711_(0).m_79707_(1000 - weight));
        }
        return builder.m_79082_();
    }

    private static LootPool getChestTreasureLootPool() {
        LootPool.Builder builder = LootPool.m_79043_().name("tombstone:chest_treasure");
        int weight = 0;
        LootHelper.addEntry(builder, Items.f_151058_, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, ModItems.bag_of_seeds, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addRandomScrollBuff(builder, false, 100);
        weight += 100;
        LootHelper.addDelayedNBTEntry(builder, ModItems.scroll_of_knowledge, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addRandomMagicTablet(builder, false, 50);
        weight += 50;
        LootHelper.addRandomMagicScroll(builder, false, 50);
        weight += 50;
        LootHelper.addEntry(builder, ModItems.gemstone_of_familiar, 10, new LootItemFunction.Builder[0]);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, ModItems.voodoo_poppet, 10, new LootItemFunction.Builder[0]);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, ModItems.receptacle_of_familiar, 10, new LootItemFunction.Builder[0]);
        if ((weight += 10) < 1000) {
            builder.m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79711_(0).m_79707_(1000 - weight));
        }
        return builder.m_79082_();
    }

    private static LootPool getCatMorningLootPool() {
        LootPool.Builder builder = LootPool.m_79043_().name("tombstone:cat_morning");
        LootHelper.addEntry(builder, ModItems.grave_dust, 100, new LootItemFunction.Builder[]{new TriggerCatMorningFunction.Builder(), SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))});
        LootHelper.addEntry(builder, ModItems.essence_of_undeath, 1, new LootItemFunction.Builder[0]);
        LootHelper.addEntry(builder, Items.f_151058_, 20, new LootItemFunction.Builder[0]);
        int weight = 121;
        LootHelper.addEntry(builder, ModItems.bag_of_seeds, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, ModItems.gemstone_of_familiar, 20, new LootItemFunction.Builder[0]);
        if ((weight += 20) < 1000) {
            builder.m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79711_(0).m_79707_(1000 - weight));
        }
        return builder.m_79082_();
    }

    private static LootPool getUndeadMobLootPool() {
        LootPool.Builder builder = LootPool.m_79043_().name("tombstone:undead_mob");
        int weight = 0;
        LootHelper.addEntry(builder, ModItems.grave_dust, 100, new LootItemFunction.Builder[]{SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))});
        weight += 100;
        LootHelper.addEntry(builder, Items.f_151058_, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, ModItems.bag_of_seeds, 10, new LootItemFunction.Builder[0]);
        weight += 10;
        LootHelper.addRandomMagicScroll(builder, false, 20);
        weight += 20;
        LootHelper.addEntry(builder, ModItems.essence_of_undeath, 5, new LootItemFunction.Builder[0]);
        if ((weight += 5) < 1000) {
            builder.m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79711_(0).m_79707_(1000 - weight));
        }
        return builder.m_79082_();
    }

    private static LootPool getUndeadBossLootPool() {
        LootPool.Builder builder = LootPool.m_79043_().name("tombstone:undead_boss");
        int weight = 0;
        LootHelper.addRandomMagicScroll(builder, false, 100);
        weight += 100;
        LootHelper.addEntry(builder, ModItems.essence_of_undeath, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, ModItems.gemstone_of_familiar, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, ModItems.receptacle_of_soul, 50, new LootItemFunction.Builder[0]);
        weight += 50;
        LootHelper.addRandomScrollBuff(builder, true, 100);
        weight += 100;
        LootHelper.addRandomMagicScroll(builder, true, 50);
        weight += 50;
        LootHelper.addDelayedNBTEntry(builder, ModItems.voodoo_poppet, 100, new LootItemFunction.Builder[0]);
        weight += 100;
        LootHelper.addDelayedNBTEntry(builder, ModItems.receptacle_of_familiar, 100, new LootItemFunction.Builder[0]);
        if ((weight += 100) < 1000) {
            builder.m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79711_(0).m_79707_(1000 - weight));
        }
        return builder.m_79082_();
    }

    private static LootPool getAbandonedGraveLootPool() {
        LootPool.Builder builder = LootPool.m_79043_().name("tombstone:abandoned_grave");
        builder.m_165133_((NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)10.0f));
        LootHelper.addEntry(builder, ModItems.essence_of_undeath, 10, new LootItemFunction.Builder[0]);
        LootHelper.addDelayedNBTEntry(builder, ModItems.receptacle_of_familiar, 50, new LootItemFunction.Builder[0]);
        LootHelper.addRandomMagicScroll(builder, false, 200);
        LootHelper.addRandomMagicScroll(builder, true, 50);
        LootHelper.addRandomEnchantedBook(builder, 200);
        LootHelper.addEnchantedEquipment(builder, EnchantedEquipmentFunction.Type.WEAPON, 60, 100);
        LootHelper.addEnchantedEquipment(builder, EnchantedEquipmentFunction.Type.TOOL, 60, 100);
        LootHelper.addEnchantedEquipment(builder, EnchantedEquipmentFunction.Type.ARMOR, 60, 400);
        LootHelper.addRandomPotion(builder, 300);
        return builder.m_79082_();
    }

    public static void handleMobDrops(Collection<ItemEntity> drops, LivingEntity entity, ServerPlayer player, DamageSource damageSource) {
        if (EntityHelper.checkUnconventionalFakePlayer(player) || entity.m_20280_((Entity)player) > 50.0) {
            return;
        }
        if (EntityHelper.isUndead(entity)) {
            LootParams.Builder builder = new LootParams.Builder(player.m_284548_()).m_287286_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_287239_(player.m_36336_()).m_287286_(LootContextParams.f_81455_, (Object)entity).m_287286_(LootContextParams.f_81457_, (Object)damageSource).m_287289_(LootContextParams.f_81458_, (Object)damageSource.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)damageSource.m_7640_());
            if (entity.f_20888_ != null) {
                builder = builder.m_287286_(LootContextParams.f_81456_, (Object)entity.f_20888_);
            }
            LootParams context = builder.m_287235_(LootContextParamSets.f_81415_);
            boolean isBoss = EntityHelper.isBoss(entity);
            UpdaterHandler.PoolType poolType = isBoss ? UpdaterHandler.PoolType.UNDEAD_BOSS : UpdaterHandler.PoolType.UNDEAD_MOB;
            int rolls = (isBoss ? 5 : 1) + (Helper.RANDOM.nextInt(100) <= EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.treasure_seeker) * 20 ? 1 : 0);
            IntStream.range(0, rolls).forEach(i -> {
                ItemStack stack = LootHelper.getLootTable(poolType).m_287195_(context).stream().findFirst().orElse(ItemStack.f_41583_);
                if (!stack.m_41619_()) {
                    if (stack.m_150930_((Item)ModItems.grave_dust)) {
                        ModTriggers.GRAVE_DUST_FROM_UNDEAD.trigger(player);
                    }
                    drops.add(new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack));
                }
            });
        }
        if (TimeHelper.isDateAroundHalloween()) {
            if (EntityHelper.isEnemy((Entity)entity) && Helper.RANDOM.nextInt(1000) < 50) {
                drops.add(new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), ModItems.lollipop.getRandomItemStack()));
            }
        } else if (TimeHelper.isDateAroundEaster() && EntityHelper.isEnemy((Entity)entity) && Helper.RANDOM.nextInt(1000) < 50) {
            drops.add(new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), ModItems.easter_egg.getRandomItemStack()));
        }
    }

    public static LootTable getLootTable(UpdaterHandler.PoolType poolType) {
        return CUSTOM_LOOTTABLES.getOrDefault((Object)poolType, LootTable.f_79105_);
    }

    private static void attachLootPool(UpdaterHandler.PoolType poolType, LootTable lootTable) {
        LootPool lootPool = UpdaterHandler.instance.loadLootPool(poolType);
        if (lootPool == null) {
            lootPool = LootHelper.getDefaultLootPool(poolType);
            UpdaterHandler.instance.saveLootPool(poolType, lootPool);
        }
        try {
            FIELD_IS_FROZEN.set(lootTable, false);
            lootTable.addPool(lootPool);
            FIELD_IS_FROZEN.set(lootTable, true);
        }
        catch (Throwable t) {
            ModTombstone.LOGGER.warn("A broken mod prevents attaching lootpool to loottable");
        }
    }

    private static LootPool getDefaultLootPool(UpdaterHandler.PoolType poolType) {
        return switch (poolType) {
            default -> throw new IncompatibleClassChangeError();
            case UpdaterHandler.PoolType.ARCHAEOLOGY -> LootHelper.getArcheologyLootPool();
            case UpdaterHandler.PoolType.LOST_TREASURE -> LootHelper.getLostTreasureLootPool();
            case UpdaterHandler.PoolType.CAT_MORNING -> LootHelper.getCatMorningLootPool();
            case UpdaterHandler.PoolType.CHEST_TREASURE -> LootHelper.getChestTreasureLootPool();
            case UpdaterHandler.PoolType.UNDEAD_MOB -> LootHelper.getUndeadMobLootPool();
            case UpdaterHandler.PoolType.UNDEAD_BOSS -> LootHelper.getUndeadBossLootPool();
            case UpdaterHandler.PoolType.SEEKER_ROD -> LootHelper.getSeekerRodLootPool();
            case UpdaterHandler.PoolType.SNIFFER_DIGGING -> LootHelper.getSnifferDigging();
            case UpdaterHandler.PoolType.ABANDONED_GRAVE -> LootHelper.getAbandonedGraveLootPool();
        };
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getTable() == null || event.getTable().getLootTableId() == null) {
            return;
        }
        ALL_LOOTTABLES.add(event.getTable());
        if (event.getName().equals((Object)BuiltInLootTables.f_78721_)) {
            CallbackHandler.addFastCallback(() -> {
                UpdaterHandler.PoolType[] poolTypes;
                for (UpdaterHandler.PoolType poolType : poolTypes = new UpdaterHandler.PoolType[]{UpdaterHandler.PoolType.ARCHAEOLOGY, UpdaterHandler.PoolType.UNDEAD_MOB, UpdaterHandler.PoolType.UNDEAD_BOSS, UpdaterHandler.PoolType.SEEKER_ROD, UpdaterHandler.PoolType.ABANDONED_GRAVE}) {
                    LootTable lootTable = LootTable.m_79147_().m_79167_();
                    lootTable.setLootTableId(new ResourceLocation("tombstone", poolType.getFilename()));
                    LootHelper.attachLootPool(poolType, lootTable);
                    CUSTOM_LOOTTABLES.put(poolType, lootTable);
                }
                LootHelper.attachLootPool(UpdaterHandler.PoolType.LOST_TREASURE, event.getTable());
                UpdaterHandler.LoottableList loottableList = UpdaterHandler.instance.loadChestLootTables();
                for (LootTable lootTable : ALL_LOOTTABLES) {
                    if (!loottableList.contains(lootTable.getLootTableId())) continue;
                    LootHelper.attachLootPool(UpdaterHandler.PoolType.CHEST_TREASURE, lootTable);
                }
                ALL_LOOTTABLES.clear();
                ModTombstone.LOGGER.debug("Updating LootTables");
            });
        } else if (event.getName().equals((Object)BuiltInLootTables.f_78724_)) {
            CallbackHandler.addFastCallback(() -> LootHelper.attachLootPool(UpdaterHandler.PoolType.CAT_MORNING, event.getTable()));
        } else if (event.getName().equals((Object)BuiltInLootTables.f_283841_)) {
            CallbackHandler.addFastCallback(() -> LootHelper.attachLootPool(UpdaterHandler.PoolType.SNIFFER_DIGGING, event.getTable()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDrops(LivingDropsEvent event) {
        if (event.getEntity() != null && !event.getEntity().m_9236_().m_5776_() && event.getEntity().m_6095_() != EntityType.f_20532_) {
            Optional.ofNullable(event.getSource()).filter(d -> EntityHelper.isValidServerPlayer(d.m_7639_())).map(d -> (ServerPlayer)d.m_7639_()).ifPresent(player -> LootHelper.handleMobDrops(event.getDrops(), event.getEntity(), player, event.getSource()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onReloadListener(AddReloadListenerEvent event) {
        LootHelper.clear();
    }
}

