/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEffects;

public class EnchantmentDecrepitude
extends TombstoneEnchantment {
    public EnchantmentDecrepitude() {
        super("decrepitude", Enchantment.Rarity.UNCOMMON, ModTombstone.TYPE_TOMBSTONE_ALL_WEAPONS, EquipmentSlot.MAINHAND);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)SharedConfigTombstone.enchantments.enableEnchantmentDecrepitude.get();
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return (Boolean)SharedConfigTombstone.enchantments.decrepitudeEnchantingTable.get() != false && super.canApplyAtEnchantingTable(stack);
    }

    public void m_7677_(LivingEntity attacker, Entity entity, int amplifier) {
        LivingEntity target;
        if (entity instanceof LivingEntity && !(target = (LivingEntity)entity).m_9236_().m_5776_() && target.m_6084_()) {
            MobEffect effect = ModEffects.decrepitude;
            int effectDuration = TimeHelper.tickFromSecond(2 * amplifier);
            int effectAmplifier = amplifier - 1;
            target.m_7292_(new MobEffectInstance(effect, effectDuration += EffectHelper.getDuration(target, effect, amplifier), effectAmplifier));
        }
    }
}

