/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.network.client;

import fuzs.puzzlesapi.api.statues.v1.world.inventory.ArmorStandMenu;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import fuzs.strawstatues.StrawStatues;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import java.util.function.BiConsumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class C2SStrawStatueScaleMessage
implements MessageV2<C2SStrawStatueScaleMessage> {
    private ScaleDataType type;
    private float value;

    public C2SStrawStatueScaleMessage() {
    }

    private C2SStrawStatueScaleMessage(ScaleDataType type, float value) {
        this.type = type;
        this.value = value;
    }

    public static void sendScale(float value) {
        StrawStatues.NETWORK.sendToServer((MessageV2)new C2SStrawStatueScaleMessage(ScaleDataType.SCALE, value));
    }

    public static void sendRotationX(float value) {
        StrawStatues.NETWORK.sendToServer((MessageV2)new C2SStrawStatueScaleMessage(ScaleDataType.ROTATION_X, value));
    }

    public static void sendRotationZ(float value) {
        StrawStatues.NETWORK.sendToServer((MessageV2)new C2SStrawStatueScaleMessage(ScaleDataType.ROTATION_Z, value));
    }

    public static void sendReset() {
        StrawStatues.NETWORK.sendToServer((MessageV2)new C2SStrawStatueScaleMessage(ScaleDataType.RESET, -1.0f));
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.type);
        buf.writeFloat(this.value);
    }

    public void read(FriendlyByteBuf buf) {
        this.type = (ScaleDataType)buf.m_130066_(ScaleDataType.class);
        this.value = buf.readFloat();
    }

    public MessageV2.MessageHandler<C2SStrawStatueScaleMessage> makeHandler() {
        return new MessageV2.MessageHandler<C2SStrawStatueScaleMessage>(){

            public void handle(C2SStrawStatueScaleMessage message, Player player, Object gameInstance) {
                ArmorStandMenu menu;
                AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                if (abstractContainerMenu instanceof ArmorStandMenu && (menu = (ArmorStandMenu)abstractContainerMenu).m_6875_(player)) {
                    message.type.consumer.accept((StrawStatue)menu.getArmorStand(), Float.valueOf(message.value));
                }
            }
        };
    }

    public static enum ScaleDataType {
        SCALE(StrawStatue::setEntityScale),
        ROTATION_X(StrawStatue::setEntityXRotation),
        ROTATION_Z(StrawStatue::setEntityZRotation),
        RESET((strawStatue, value) -> {
            strawStatue.setEntityScale(3.0f);
            strawStatue.setEntityRotations(StrawStatue.DEFAULT_ENTITY_ROTATIONS.m_123156_(), StrawStatue.DEFAULT_ENTITY_ROTATIONS.m_123158_());
        });

        public final BiConsumer<StrawStatue, Float> consumer;

        private ScaleDataType(BiConsumer<StrawStatue, Float> consumer) {
            this.consumer = consumer;
        }
    }
}

