/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues;

import fuzs.puzzlesapi.api.statues.v1.world.inventory.data.ArmorStandPose;
import fuzs.puzzlesapi.api.statues.v1.world.inventory.data.ArmorStandStyleOption;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.BuildCreativeModeTabContentsContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesCreateContext;
import fuzs.puzzleslib.api.event.v1.core.EventPhase;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.network.v2.MessageDirection;
import fuzs.puzzleslib.api.network.v2.NetworkHandlerV2;
import fuzs.strawstatues.init.ModRegistry;
import fuzs.strawstatues.network.client.C2SStrawStatueModelPartMessage;
import fuzs.strawstatues.network.client.C2SStrawStatueOwnerMessage;
import fuzs.strawstatues.network.client.C2SStrawStatueScaleMessage;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrawStatues
implements ModConstructor {
    public static final String MOD_ID = "strawstatues";
    public static final String MOD_NAME = "Straw Statues";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Straw Statues");
    public static final NetworkHandlerV2 NETWORK = NetworkHandlerV2.build((String)"strawstatues");

    public void onConstructMod() {
        ModRegistry.touch();
        StrawStatues.registerMessages();
        StrawStatues.registerHandlers();
    }

    private static void registerMessages() {
        NETWORK.register(C2SStrawStatueModelPartMessage.class, C2SStrawStatueModelPartMessage::new, MessageDirection.TO_SERVER);
        NETWORK.register(C2SStrawStatueOwnerMessage.class, C2SStrawStatueOwnerMessage::new, MessageDirection.TO_SERVER);
        NETWORK.register(C2SStrawStatueScaleMessage.class, C2SStrawStatueScaleMessage::new, MessageDirection.TO_SERVER);
    }

    private static void registerHandlers() {
        PlayerInteractEvents.USE_ENTITY_AT.register(EventPhase.BEFORE, StrawStatue::onUseEntityAt);
    }

    public void onCommonSetup() {
        ArmorStandStyleOption.register((ResourceLocation)StrawStatues.id("slimarms"), (ArmorStandStyleOption)ModRegistry.SLIM_ARMS_STYLE_OPTION);
        ArmorStandStyleOption.register((ResourceLocation)StrawStatues.id("crouching"), (ArmorStandStyleOption)ModRegistry.CROUCHING_STYLE_OPTION);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.STRAW_STATUE_ITEM.get()), (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            public ItemStack m_7498_(BlockSource blockSource, ItemStack stack) {
                Direction direction = (Direction)blockSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                BlockPos blockpos = blockSource.m_7961_().m_121945_(direction);
                ServerLevel level = blockSource.m_7727_();
                StrawStatue armorstand = new StrawStatue((Level)level, (double)blockpos.m_123341_() + 0.5, blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5);
                EntityType.m_20620_((Level)level, null, (Entity)armorstand, (CompoundTag)stack.m_41783_());
                armorstand.m_146922_(direction.m_122435_());
                ArmorStandPose.randomValue().applyToEntity((ArmorStand)armorstand);
                level.m_7967_((Entity)armorstand);
                stack.m_41774_(1);
                return stack;
            }
        });
    }

    public void onEntityAttributeCreation(EntityAttributesCreateContext context) {
        context.registerEntityAttributes((EntityType)ModRegistry.STRAW_STATUE_ENTITY_TYPE.get(), LivingEntity.m_21183_());
    }

    public void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsContext context) {
        context.registerBuildListener(CreativeModeTabs.f_256791_, (itemDisplayParameters, output) -> output.m_246326_((ItemLike)ModRegistry.STRAW_STATUE_ITEM.get()));
        context.registerBuildListener(CreativeModeTabs.f_257028_, (itemDisplayParameters, output) -> output.m_246326_((ItemLike)ModRegistry.STRAW_STATUE_ITEM.get()));
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

