/*
 * Decompiled with CFR 0.152.
 */
package fuzs.combatnouveau.helper;

import fuzs.combatnouveau.CombatNouveau;
import fuzs.combatnouveau.config.ServerConfig;
import fuzs.combatnouveau.core.CommonAbstractions;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.item.v2.ToolTypeHelper;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class SweepAttackHelper {
    public static void tryAttackAir(Player player) {
        if (player.m_36403_(0.5f) >= 1.0f) {
            double walkDist = player.f_19787_ - player.f_19867_;
            if (!player.m_20096_() || !(walkDist < (double)player.m_6113_())) {
                return;
            }
            float attackDamage = (float)player.m_21051_(Attributes.f_22281_).m_22135_();
            if (attackDamage > 0.0f && player.m_36403_(0.5f) > 0.9f && SweepAttackHelper.canPerformSweepAttack(player)) {
                double attackReach = SweepAttackHelper.getCurrentAttackReach(player, player.m_7500_());
                double moveX = (double)(-Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180)))) * 2.0;
                double moveZ = (double)Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180))) * 2.0;
                AABB aABB = CommonAbstractions.INSTANCE.getSweepHitBox(player, (Entity)player).m_82386_(moveX, 0.0, moveZ);
                SweepAttackHelper.performSweepAttack(player, aABB, attackReach, attackDamage, null);
            }
            player.m_6674_(InteractionHand.MAIN_HAND);
        }
    }

    private static boolean canPerformSweepAttack(Player player) {
        if (((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).noSweepingWhenSneaking && player.m_6144_()) {
            return false;
        }
        if (((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).requireSweepingEdge) {
            return EnchantmentHelper.m_44821_((LivingEntity)player) > 0.0f;
        }
        ItemStack itemInHand = player.m_21120_(InteractionHand.MAIN_HAND);
        return ToolTypeHelper.INSTANCE.isSword(itemInHand);
    }

    private static double getCurrentAttackReach(Player player, boolean hasFarPickRange) {
        double attackReach = player.m_21051_(CommonAbstractions.INSTANCE.getAttackRangeAttribute()).m_22135_();
        if (!ModLoaderEnvironment.INSTANCE.isForge()) {
            attackReach += 3.0;
        }
        if (hasFarPickRange) {
            attackReach += 0.5;
        }
        return attackReach;
    }

    private static void performSweepAttack(Player player, AABB aABB, double currentAttackReach, float baseAttackDamage, @Nullable Entity target) {
        float h = 1.0f + EnchantmentHelper.m_44821_((LivingEntity)player) * baseAttackDamage;
        List list = player.m_9236_().m_45976_(LivingEntity.class, aABB);
        for (LivingEntity livingEntity : list) {
            if (livingEntity == player || livingEntity == target || player.m_7307_((Entity)livingEntity) || livingEntity instanceof ArmorStand && ((ArmorStand)livingEntity).m_31677_()) continue;
            double d = currentAttackReach + (double)livingEntity.m_20205_() * 0.5;
            if (!(player.m_20280_((Entity)livingEntity) < d * d)) continue;
            livingEntity.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
            livingEntity.m_6469_(player.m_269291_().m_269075_(player), h);
        }
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.0f, 1.0f);
        if (player.m_9236_() instanceof ServerLevel) {
            double d = -Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180)));
            double i = Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)));
            ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, player.m_20185_() + d, player.m_20186_() + (double)player.m_20206_() * 0.5, player.m_20189_() + i, 0, d, 0.0, i, 0.0);
        }
    }
}

