/*
 * Decompiled with CFR 0.152.
 */
package fuzs.combatnouveau.handler;

import fuzs.combatnouveau.CombatNouveau;
import fuzs.combatnouveau.client.helper.UseItemFabricClientHelper;
import fuzs.combatnouveau.config.ServerConfig;
import fuzs.combatnouveau.helper.UseItemFabricHelper;
import fuzs.combatnouveau.mixin.accessor.ItemAccessor;
import fuzs.combatnouveau.mixin.accessor.PlayerAccessor;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class CombatTestHandler {
    public static void onStartPlayerTick(Player player) {
        if (!((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).fastSwitching) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (!ItemStack.m_41728_((ItemStack)((PlayerAccessor)player).goldenagecombat$getLastItemInMainHand(), (ItemStack)stack)) {
            ((PlayerAccessor)player).goldenagecombat$setLastItemInMainHand(stack.m_41777_());
        }
    }

    public static EventResult onUseItemStart(LivingEntity entity, ItemStack stack, MutableInt remainingUseDuration) {
        if (((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).removeShieldDelay && stack.m_41780_() == UseAnim.BLOCK) {
            remainingUseDuration.accept(stack.m_41779_() - 5);
        }
        if (((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).fastDrinking && stack.m_41780_() == UseAnim.DRINK) {
            remainingUseDuration.accept(20);
        }
        return EventResult.PASS;
    }

    public static EventResultHolder<InteractionResult> onUseItem(Player player, Level level, InteractionHand hand) {
        if (!((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).throwablesDelay) {
            return EventResultHolder.pass();
        }
        ItemStack itemInHand = player.m_21120_(hand);
        if (itemInHand.m_41720_() instanceof SnowballItem || itemInHand.m_41720_() instanceof EggItem) {
            player.m_36335_().m_41524_(itemInHand.m_41720_(), 4);
            if (!ModLoaderEnvironment.INSTANCE.getModLoader().isForge()) {
                InteractionResult result = level.f_46443_ ? UseItemFabricClientHelper.useItem(player, hand) : UseItemFabricHelper.useItem((ServerPlayer)player, level, itemInHand, hand);
                return EventResultHolder.interrupt((Object)result);
            }
        }
        return EventResultHolder.pass();
    }

    public static EventResult onLivingHurt(LivingEntity entity, DamageSource source, MutableFloat amount) {
        UseAnim useAction;
        if (((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).eatingInterruption && ((useAction = entity.m_21211_().m_41780_()) == UseAnim.EAT || useAction == UseAnim.DRINK)) {
            entity.m_5810_();
        }
        if (((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).noProjectileImmunity && source.m_269533_(DamageTypeTags.f_268524_)) {
            entity.f_19802_ = 0;
        }
        return EventResult.PASS;
    }

    public static void setMaxStackSize(ServerConfig serverConfig) {
        if (!serverConfig.increaseStackSize) {
            return;
        }
        ((ItemAccessor)Items.f_42452_).goldenagecombat$setMaxStackSize(64);
        ((ItemAccessor)Items.f_42521_).goldenagecombat$setMaxStackSize(64);
        ((ItemAccessor)Items.f_42589_).goldenagecombat$setMaxStackSize(16);
    }
}

