/*
 * Decompiled with CFR 0.152.
 */
package fuzs.combatnouveau.client.handler;

import com.google.common.collect.Multimap;
import fuzs.combatnouveau.CombatNouveau;
import fuzs.combatnouveau.client.helper.AttributeTooltipHelper;
import fuzs.combatnouveau.config.ClientConfig;
import fuzs.combatnouveau.config.ServerConfig;
import fuzs.combatnouveau.core.CommonAbstractions;
import fuzs.combatnouveau.handler.AttackAttributeHandler;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public class AttributesTooltipHandler {
    private static final UUID[] ARMOR_MODIFIER_UUID_PER_SLOT = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};

    public static void onItemTooltip(ItemStack stack, @Nullable Player player, List<Component> lines, TooltipFlag context) {
        Item item;
        if (!CombatNouveau.CONFIG.getHolder(ServerConfig.class).isAvailable()) {
            return;
        }
        if (((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).additionalAttackReach && AttackAttributeHandler.ATTACK_RANGE_BONUS_OVERRIDES.keySet().stream().anyMatch(t -> t.isInstance(stack.m_41720_())) || ((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).attackReachOverrides.contains((Object)stack.m_41720_())) {
            AttributesTooltipHandler.convertToDefaultAttribute(lines, AttackAttributeHandler.BASE_ATTACK_REACH_UUID, stack, player);
        }
        if (((ClientConfig)CombatNouveau.CONFIG.get(ClientConfig.class)).specialArmorAttributes && (item = stack.m_41720_()) instanceof ArmorItem) {
            ArmorItem item2 = (ArmorItem)item;
            AttributesTooltipHandler.convertToDefaultAttribute(lines, ARMOR_MODIFIER_UUID_PER_SLOT[item2.m_266204_().m_266308_().m_20749_()], stack, player);
        }
    }

    private static void convertToDefaultAttribute(List<Component> lines, UUID attributeId, ItemStack stack, @Nullable Player player) {
        Map<EquipmentSlot, Multimap<Attribute, AttributeModifier>> attributesBySlot = AttributeTooltipHelper.getAttributesBySlot(stack);
        for (Map.Entry<EquipmentSlot, Multimap<Attribute, AttributeModifier>> slotToAttributeMap : attributesBySlot.entrySet()) {
            ArrayList attributeModifiers = Lists.newArrayList();
            for (Map.Entry attributeToModifier : slotToAttributeMap.getValue().entries()) {
                if (!((AttributeModifier)attributeToModifier.getValue()).m_22209_().equals(attributeId)) continue;
                attributeModifiers.add(attributeToModifier);
            }
            block2: for (Map.Entry entry : attributeModifiers) {
                AttributeModifier attributeModifier;
                Attribute attribute = (Attribute)entry.getKey();
                double attributeAmount = AttributesTooltipHandler.getAdjustedAttributeAmount(stack, player, attribute, attributeModifier = (AttributeModifier)entry.getValue());
                if (attributeAmount == 0.0) continue;
                int slotModifiersStart = -1;
                for (int i = 0; i < lines.size(); ++i) {
                    TranslatableContents translatableComponent;
                    Component component = lines.get(i);
                    if (AttributeTooltipHelper.matchesAttributeComponent(component, attribute, attributeModifier)) {
                        lines.set(i, (Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)("attribute.modifier.equals." + attributeModifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(attributeAmount), Component.m_237115_((String)attribute.m_22087_())})).m_130940_(ChatFormatting.DARK_GREEN));
                        continue block2;
                    }
                    ComponentContents componentContents = component.m_214077_();
                    if (!(componentContents instanceof TranslatableContents) || !(translatableComponent = (TranslatableContents)componentContents).m_237508_().equals("item.modifiers." + slotToAttributeMap.getKey().m_20751_())) continue;
                    slotModifiersStart = i + 1;
                }
                if (slotModifiersStart == -1) continue;
                lines.add(slotModifiersStart, (Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)("attribute.modifier.equals." + attributeModifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(attributeAmount), Component.m_237115_((String)attribute.m_22087_())})).m_130940_(ChatFormatting.DARK_GREEN));
            }
        }
    }

    public static double getAdjustedAttributeAmount(ItemStack stack, @Nullable Player player, Attribute attribute, AttributeModifier attributeModifier) {
        double attributeAmount = attributeModifier.m_22218_();
        if (player != null) {
            attributeAmount += player.m_21204_().m_22171_(attribute) ? player.m_21172_(attribute) : 0.0;
        }
        if (attribute == Attributes.f_22281_) {
            attributeAmount += (double)EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_);
        }
        if (attribute == CommonAbstractions.INSTANCE.getAttackRangeAttribute() && !ModLoaderEnvironment.INSTANCE.isForge()) {
            attributeAmount += 3.0;
        }
        if (attributeModifier.m_22217_() == AttributeModifier.Operation.ADDITION) {
            RangedAttribute rangedAttribute;
            if (attribute instanceof RangedAttribute && (rangedAttribute = (RangedAttribute)attribute).m_147362_() < 10.0) {
                attributeAmount *= 10.0 / rangedAttribute.m_147362_();
            }
        } else {
            attributeAmount *= 100.0;
        }
        return attributeAmount;
    }
}

