/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.util;

import dev.murad.shipping.util.LinkableEntity;
import dev.murad.shipping.util.LinkableEntityHead;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Train<V extends LinkableEntity<V>> {
    private final Optional<V> tug;
    private V tail;
    private V head;

    public Train(V entity) {
        this.head = entity;
        this.tail = entity;
        this.tug = entity instanceof LinkableEntityHead ? Optional.of(entity) : Optional.empty();
    }

    public Optional<V> getTug() {
        return this.tug;
    }

    public V getTail() {
        return this.tail;
    }

    public void setTail(V tail) {
        this.tail = tail;
    }

    public V getHead() {
        return this.head;
    }

    public List<V> asListOfTugged() {
        if (this.head.checkNoLoopsDominated()) {
            this.head.removeDominated();
            this.head.getFollower().ifPresent(LinkableEntity::removeDominant);
            return new ArrayList();
        }
        return this.tug.map(tugEntity -> {
            ArrayList<LinkableEntity> barges = new ArrayList<LinkableEntity>();
            Optional<LinkableEntity> barge = this.getNext(tugEntity);
            while (barge.isPresent()) {
                barges.add(barge.get());
                barge = this.getNext(barge.get());
            }
            return barges;
        }).orElse(new ArrayList());
    }

    public List<V> asList() {
        if (this.head.checkNoLoopsDominated()) {
            this.head.removeDominated();
            this.head.getFollower().ifPresent(LinkableEntity::removeDominant);
            return new ArrayList();
        }
        ArrayList<LinkableEntity> barges = new ArrayList<LinkableEntity>();
        Optional<Object> barge = Optional.of(this.head);
        while (barge.isPresent()) {
            barges.add((LinkableEntity)barge.get());
            barge = this.getNext((LinkableEntity)barge.get());
        }
        return barges;
    }

    public Optional<V> getNext(V entity) {
        return entity.getFollower().map(t -> t);
    }

    public void setHead(V head) {
        this.head = head;
    }
}

