/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.vessel.tug;

import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.block.dock.TugDockTileEntity;
import dev.murad.shipping.block.guiderail.TugGuideRailBlock;
import dev.murad.shipping.capability.StallingCapability;
import dev.murad.shipping.entity.accessor.DataAccessor;
import dev.murad.shipping.entity.custom.HeadVehicle;
import dev.murad.shipping.entity.custom.vessel.VesselEntity;
import dev.murad.shipping.entity.custom.vessel.tug.VehicleFrontPart;
import dev.murad.shipping.entity.navigation.TugPathNavigator;
import dev.murad.shipping.item.TugRouteItem;
import dev.murad.shipping.setup.ModBlocks;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.setup.ModSounds;
import dev.murad.shipping.util.ChunkManagerEnrollmentHandler;
import dev.murad.shipping.util.LinkableEntityHead;
import dev.murad.shipping.util.Train;
import dev.murad.shipping.util.TugRoute;
import dev.murad.shipping.util.TugRouteNode;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTugEntity
extends VesselEntity
implements LinkableEntityHead<VesselEntity>,
Container,
WorldlyContainer,
HeadVehicle {
    protected final ChunkManagerEnrollmentHandler enrollmentHandler;
    protected final ItemStackHandler routeItemHandler = this.createRouteItemHandler();
    protected boolean contentsChanged = false;
    protected boolean docked = false;
    protected int remainingStallTime = 0;
    private double swimSpeedMult = 1.0;
    protected boolean engineOn = true;
    private int dockCheckCooldown = 0;
    private boolean independentMotion = false;
    private int pathfindCooldown = 0;
    private VehicleFrontPart frontHitbox;
    private static final EntityDataAccessor<Boolean> INDEPENDENT_MOTION = SynchedEntityData.m_135353_(AbstractTugEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> OWNER = SynchedEntityData.m_135353_(AbstractTugEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected TugRoute path;
    protected int nextStop;
    private final StallingCapability stalling = new StallingCapability(){

        @Override
        public boolean isDocked() {
            return AbstractTugEntity.this.docked;
        }

        @Override
        public void dock(double x, double y, double z) {
            AbstractTugEntity.this.docked = true;
            AbstractTugEntity.this.m_20256_(Vec3.f_82478_);
            AbstractTugEntity.this.m_6027_(x, y, z);
        }

        @Override
        public void undock() {
            AbstractTugEntity.this.docked = false;
        }

        @Override
        public boolean isStalled() {
            return AbstractTugEntity.this.remainingStallTime > 0;
        }

        @Override
        public void stall() {
            AbstractTugEntity.this.remainingStallTime = 20;
        }

        @Override
        public void unstall() {
            AbstractTugEntity.this.remainingStallTime = 0;
        }

        @Override
        public boolean isFrozen() {
            return AbstractTugEntity.super.isFrozen();
        }

        @Override
        public void freeze() {
            AbstractTugEntity.this.setFrozen(true);
        }

        @Override
        public void unfreeze() {
            AbstractTugEntity.this.setFrozen(false);
        }
    };
    private final LazyOptional<StallingCapability> stallingOpt = LazyOptional.of(() -> this.stalling);

    @Override
    public boolean allowDockInterface() {
        return this.isDocked();
    }

    public AbstractTugEntity(EntityType<? extends WaterAnimal> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
        this.linkingHandler.train = new Train<AbstractTugEntity>(this);
        this.path = new TugRoute();
        this.frontHitbox = new VehicleFrontPart((Entity)this);
        this.enrollmentHandler = new ChunkManagerEnrollmentHandler((Entity)this);
    }

    public AbstractTugEntity(EntityType type, Level worldIn, double x, double y, double z) {
        this((EntityType<? extends WaterAnimal>)type, worldIn);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    @Override
    public ResourceLocation getRouteIcon() {
        return ModItems.TUG_ROUTE_ICON;
    }

    public void m_21455_(boolean p_110160_1_, boolean p_110160_2_) {
        this.f_21344_.m_26569_();
        super.m_21455_(p_110160_1_, p_110160_2_);
    }

    public abstract DataAccessor getDataAccessor();

    private ItemStackHandler createRouteItemHandler() {
        return new ItemStackHandler(){

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                AbstractTugEntity.this.contentsChanged = true;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.m_41720_() instanceof TugRouteItem;
            }
        };
    }

    @Override
    public String owner() {
        return (String)this.f_19804_.m_135370_(OWNER);
    }

    public boolean m_6063_() {
        return true;
    }

    protected abstract MenuProvider createContainerProvider();

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        if (compound.m_128441_("inv")) {
            ItemStackHandler old = new ItemStackHandler();
            old.deserializeNBT(compound.m_128469_("inv"));
            this.routeItemHandler.setStackInSlot(0, old.getStackInSlot(0));
        } else {
            this.routeItemHandler.deserializeNBT(compound.m_128469_("routeHandler"));
        }
        this.nextStop = compound.m_128441_("next_stop") ? compound.m_128451_("next_stop") : 0;
        this.engineOn = !compound.m_128441_("engineOn") || compound.m_128471_("engineOn");
        this.contentsChanged = true;
        this.enrollmentHandler.load(compound);
        super.m_7378_(compound);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        compound.m_128405_("next_stop", this.nextStop);
        compound.m_128379_("engineOn", this.engineOn);
        compound.m_128365_("routeHandler", (Tag)this.routeItemHandler.serializeNBT());
        this.enrollmentHandler.save(compound);
        super.m_7380_(compound);
    }

    private void tickRouteCheck() {
        if (this.contentsChanged) {
            ItemStack stack = this.routeItemHandler.getStackInSlot(0);
            this.setPath(TugRouteItem.getRoute(stack));
            this.contentsChanged = false;
        }
        if (this.nextStop >= this.path.size()) {
            this.nextStop = 0;
        }
    }

    protected abstract boolean tickFuel();

    public static AttributeSupplier.Builder setCustomAttributes() {
        return VesselEntity.setCustomAttributes().m_22268_(Attributes.f_22277_, 200.0);
    }

    protected void onDock() {
        this.m_5496_((SoundEvent)ModSounds.TUG_DOCKING.get(), 0.6f, 1.0f);
    }

    protected void onUndock() {
        this.m_5496_((SoundEvent)ModSounds.TUG_UNDOCKING.get(), 0.6f, 1.5f);
    }

    private List<Direction> getSideDirections() {
        return this.m_6350_() == Direction.NORTH || this.m_6350_() == Direction.SOUTH ? Arrays.asList(Direction.EAST, Direction.WEST) : Arrays.asList(Direction.NORTH, Direction.SOUTH);
    }

    private void tickCheckDock() {
        this.getCapability(StallingCapability.STALLING_CAPABILITY).ifPresent(cap -> {
            boolean changedUndock;
            int x = (int)Math.floor(this.m_20185_());
            int y = (int)Math.floor(this.m_20186_());
            int z = (int)Math.floor(this.m_20189_());
            boolean docked = cap.isDocked();
            if (docked && this.dockCheckCooldown > 0) {
                --this.dockCheckCooldown;
                this.m_20256_(Vec3.f_82478_);
                this.m_6027_((double)x + 0.5, this.m_20186_(), (double)z + 0.5);
                return;
            }
            boolean shouldDock = this.getSideDirections().stream().map(curr -> Optional.ofNullable(this.m_9236_().m_7702_(new BlockPos(x + curr.m_122429_(), y, z + curr.m_122431_()))).filter(entity -> entity instanceof TugDockTileEntity).map(entity -> (TugDockTileEntity)((Object)((Object)((Object)entity)))).map(dock -> dock.hold(this, (Direction)curr)).orElse(false)).reduce(false, (acc, curr) -> acc != false || curr != false);
            boolean changedDock = !docked && shouldDock;
            boolean bl = changedUndock = docked && !shouldDock;
            if (shouldDock) {
                this.dockCheckCooldown = 20;
                cap.dock((double)x + 0.5, this.m_20186_(), (double)z + 0.5);
            } else {
                this.dockCheckCooldown = 0;
                cap.undock();
            }
            if (changedDock) {
                this.onDock();
            }
            if (changedUndock) {
                this.onUndock();
            }
        });
    }

    public boolean m_6040_() {
        return true;
    }

    protected void makeSmoke() {
        Level world = this.m_9236_();
        if (world != null) {
            BlockPos blockpos = this.m_20097_().m_7494_().m_7494_();
            RandomSource random = world.f_46441_;
            if ((double)random.m_188501_() < (Double)ShippingConfig.Client.TUG_SMOKE_MODIFIER.get()) {
                for (int i = 0; i < random.m_188503_(2) + 2; ++i) {
                    AbstractTugEntity.makeParticles(world, blockpos, (Entity)this);
                }
            }
        }
    }

    public static void makeParticles(Level level, BlockPos pos, Entity entity) {
        RandomSource random = level.m_213780_();
        Supplier<Boolean> h = () -> random.m_188500_() < 0.5;
        double dx = (entity.m_20185_() - entity.f_19790_) / 12.0;
        double dy = (entity.m_20186_() - entity.f_19791_) / 12.0;
        double dz = (entity.m_20189_() - entity.f_19792_) / 12.0;
        double xDrift = (double)(h.get() != false ? 1 : -1) * random.m_188500_() * 2.0;
        double zDrift = (double)(h.get() != false ? 1 : -1) * random.m_188500_() * 2.0;
        SimpleParticleType particleType = random.m_188499_() ? ParticleTypes.f_123778_ : ParticleTypes.f_123777_;
        level.m_6485_((ParticleOptions)particleType, true, (double)pos.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + random.m_188500_() + random.m_188500_(), (double)pos.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 0.007 * xDrift + dx, 0.05 + dy, 0.007 * zDrift + dz);
    }

    protected PathNavigation m_6037_(Level p_175447_1_) {
        return new TugPathNavigator((Mob)this, p_175447_1_);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.m_9236_().f_46443_) {
            DyeColor color = DyeColor.getColor((ItemStack)player.m_21120_(hand));
            if (color != null) {
                this.m_20088_().m_135381_(COLOR_DATA, (Object)color.m_41060_());
            } else {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this.createContainerProvider(), this.getDataAccessor()::write);
            }
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    @Override
    public void enroll(UUID uuid) {
        this.enrollmentHandler.enroll(uuid);
    }

    @Override
    public void m_7350_(@NotNull EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (this.m_9236_().f_46443_ && INDEPENDENT_MOTION.equals(key)) {
            this.independentMotion = (Boolean)this.f_19804_.m_135370_(INDEPENDENT_MOTION);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new MovementGoal());
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return new PartEntity[]{this.frontHitbox};
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_21224_() && !this.m_21525_()) {
            this.frontHitbox.updatePosition((Entity)this);
        }
    }

    public void m_141965_(ClientboundAddEntityPacket p_149572_) {
        super.m_141965_(p_149572_);
        this.frontHitbox.m_20234_(p_149572_.m_131496_());
    }

    @Override
    public void m_8119_() {
        if (this.m_9236_().f_46443_ && this.independentMotion) {
            this.makeSmoke();
        }
        if (!this.m_9236_().f_46443_) {
            this.enrollmentHandler.tick();
            this.enrollmentHandler.getPlayerName().ifPresent(name -> this.f_19804_.m_135381_(OWNER, name));
        }
        super.m_8119_();
    }

    private void followGuideRail() {
        StallingCapability cap;
        LazyOptional<StallingCapability> dockcap = this.getCapability(StallingCapability.STALLING_CAPABILITY);
        if (dockcap.isPresent() && dockcap.resolve().isPresent() && ((cap = (StallingCapability)dockcap.resolve().get()).isDocked() || cap.isFrozen() || cap.isStalled())) {
            return;
        }
        List<BlockState> belowList = Arrays.asList(this.m_9236_().m_8055_(this.m_20097_().m_7495_()), this.m_9236_().m_8055_(this.m_20097_().m_7495_().m_7495_()));
        BlockState water = this.m_9236_().m_8055_(this.m_20097_());
        for (BlockState below : belowList) {
            if (!below.m_60713_((Block)ModBlocks.GUIDE_RAIL_TUG.get()) || !water.m_60713_(Blocks.f_49990_)) continue;
            Direction arrows = TugGuideRailBlock.getArrowsDirection(below);
            this.m_146922_(arrows.m_122435_());
            double modifier = 0.03;
            this.m_20256_(this.m_20184_().m_82549_(new Vec3((double)arrows.m_122429_() * modifier, 0.0, (double)arrows.m_122431_() * modifier)));
        }
    }

    protected void m_8024_() {
        super.m_8024_();
    }

    private void followPath() {
        --this.pathfindCooldown;
        if (!this.path.isEmpty() && !this.docked && this.engineOn && !this.shouldFreezeTrain() && this.tickFuel()) {
            TugRouteNode stop = (TugRouteNode)this.path.get(this.nextStop);
            if (this.f_21344_.m_26570_() == null || this.f_21344_.m_26570_().m_77392_()) {
                if (this.pathfindCooldown < 0 || this.f_21344_.m_26570_() != null) {
                    this.f_21344_.m_26519_(stop.getX(), this.m_20186_(), stop.getZ(), 0.3);
                    this.pathfindCooldown = 20;
                } else {
                    return;
                }
            }
            double distance = Math.abs(Math.hypot(this.m_20185_() - (stop.getX() + 0.5), this.m_20189_() - (stop.getZ() + 0.5)));
            this.independentMotion = true;
            this.f_19804_.m_135381_(INDEPENDENT_MOTION, (Object)true);
            if (distance < 0.9) {
                this.incrementStop();
            }
        } else {
            this.f_19804_.m_135381_(INDEPENDENT_MOTION, (Object)false);
            this.f_21344_.m_26573_();
            if (this.remainingStallTime > 0) {
                --this.remainingStallTime;
            }
            if (this.path.isEmpty()) {
                this.nextStop = 0;
            }
        }
    }

    public boolean shouldFreezeTrain() {
        return !this.enrollmentHandler.mayMove() || this.stalling.isStalled() && !this.docked || this.linkingHandler.train.asList().stream().anyMatch(VesselEntity::isFrozen);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(INDEPENDENT_MOTION, (Object)false);
        this.f_19804_.m_135372_(OWNER, (Object)"");
    }

    public void setPath(TugRoute path) {
        if (!this.path.isEmpty() && !this.path.equals(path)) {
            this.nextStop = 0;
        }
        this.path = path;
    }

    private void incrementStop() {
        if (this.path.size() == 1) {
            this.nextStop = 0;
        } else if (!this.path.isEmpty()) {
            this.nextStop = (this.nextStop + 1) % this.path.size();
        }
    }

    @Override
    public void setDominated(VesselEntity entity) {
        this.linkingHandler.follower = Optional.of(entity);
    }

    @Override
    public void setDominant(VesselEntity entity) {
    }

    @Override
    public void removeDominated() {
        this.linkingHandler.follower = Optional.empty();
        this.linkingHandler.train.setTail(this);
    }

    @Override
    public boolean hasOwner() {
        return this.enrollmentHandler.hasOwner();
    }

    @Override
    public void removeDominant() {
    }

    @Override
    public void setTrain(Train<VesselEntity> train) {
        this.linkingHandler.train = train;
    }

    @Override
    public void m_142687_(Entity.RemovalReason r) {
        if (!this.m_9236_().f_46443_) {
            ItemStack stack = new ItemStack((ItemLike)this.getDropItem());
            if (this.m_8077_()) {
                stack.m_41714_(this.m_7770_());
            }
            this.m_19983_(stack);
            Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this);
            this.m_19983_(this.routeItemHandler.getStackInSlot(0));
        }
        super.m_142687_(r);
    }

    public ItemStack m_7407_(int p_70298_1_, int p_70298_2_) {
        return null;
    }

    public ItemStack m_8016_(int p_70304_1_) {
        return null;
    }

    public boolean m_7013_(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }

    public void m_6596_() {
        this.contentsChanged = true;
    }

    @Override
    public boolean isValid(Player p_70300_1_) {
        if (this.m_213877_()) {
            return false;
        }
        return !(p_70300_1_.m_20280_((Entity)this) > 64.0);
    }

    public boolean m_6542_(Player p_70300_1_) {
        if (this.m_213877_()) {
            return false;
        }
        return !(p_70300_1_.m_20280_((Entity)this) > 64.0);
    }

    public void m_6211_() {
    }

    public boolean m_7157_(int p_180461_1_, ItemStack p_180461_2_, Direction p_180461_3_) {
        return false;
    }

    public int[] m_7071_(Direction p_180463_1_) {
        return IntStream.range(0, this.m_6643_()).toArray();
    }

    public boolean m_7155_(int p_180462_1_, ItemStack p_180462_2_, @Nullable Direction p_180462_3_) {
        return this.isDocked();
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_6573_(Player p_184652_1_) {
        return true;
    }

    @Override
    protected double swimSpeed() {
        if (this.m_9236_().f_46443_) {
            return super.swimSpeed();
        }
        if (this.f_19797_ % 10 == 0) {
            this.swimSpeedMult = this.computeSpeedMult();
        }
        return this.swimSpeedMult * super.swimSpeed();
    }

    private double computeSpeedMult() {
        double mult = 1.0;
        boolean doBreak = false;
        for (int i = 0; i < 10 && !doBreak; ++i) {
            for (Direction direction : List.of(Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH)) {
                BlockPos pos = this.m_20097_().m_5484_(direction, i);
                if (this.m_9236_().m_6425_(pos).m_76170_()) continue;
                doBreak = true;
                break;
            }
            if (i <= 3) continue;
            mult = 1.0 + (double)((float)i / 10.0f) * 1.8;
        }
        if (mult < this.swimSpeedMult) {
            return mult;
        }
        return (mult + this.swimSpeedMult * 20.0) / 21.0;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == StallingCapability.STALLING_CAPABILITY) {
            return this.stallingOpt.cast();
        }
        return super.getCapability(cap);
    }

    @Override
    public ItemStackHandler getRouteItemHandler() {
        return this.routeItemHandler;
    }

    public boolean isDocked() {
        return this.docked;
    }

    public int getRemainingStallTime() {
        return this.remainingStallTime;
    }

    @Override
    public void setEngineOn(boolean engineOn) {
        this.engineOn = engineOn;
    }

    class MovementGoal
    extends Goal {
        MovementGoal() {
        }

        public boolean m_8036_() {
            return AbstractTugEntity.this.path != null;
        }

        public void m_8037_() {
            if (!AbstractTugEntity.this.m_9236_().f_46443_) {
                AbstractTugEntity.this.tickRouteCheck();
                AbstractTugEntity.this.tickCheckDock();
                AbstractTugEntity.this.followPath();
                AbstractTugEntity.this.followGuideRail();
            }
        }
    }
}

