/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import edivad.dimstorage.blockentities.BlockEntityDimChest;
import edivad.dimstorage.setup.Registration;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.joml.Quaternionf;

public class DimChestRenderer
implements BlockEntityRenderer<BlockEntityDimChest> {
    private static final String STATIC = "static";
    public static final ModelLayerLocation STATIC_LAYER = new ModelLayerLocation(Registration.DIMCHEST.getId(), "static");
    private static final String MOVABLE = "movable";
    public static final ModelLayerLocation MOVABLE_LAYER = new ModelLayerLocation(Registration.DIMCHEST.getId(), "movable");
    private static final String GREEN_INDICATOR = "greenIndicator";
    public static final ModelLayerLocation GREEN_INDICATOR_LAYER = new ModelLayerLocation(Registration.DIMCHEST.getId(), "greenIndicator");
    private static final String BLUE_INDICATOR = "blueIndicator";
    public static final ModelLayerLocation BLUE_INDICATOR_LAYER = new ModelLayerLocation(Registration.DIMCHEST.getId(), "blueIndicator");
    private static final String RED_INDICATOR = "redIndicator";
    public static final ModelLayerLocation RED_INDICATOR_LAYER = new ModelLayerLocation(Registration.DIMCHEST.getId(), "redIndicator");
    private static final ResourceLocation TEXTURE = new ResourceLocation("dimstorage", "textures/model/dimchest.png");
    private final ModelPart staticLayer;
    private final ModelPart movableLayer;
    private final ModelPart greenIndicatorLayer;
    private final ModelPart blueIndicatorLayer;
    private final ModelPart redIndicatorLayer;

    public DimChestRenderer(BlockEntityRendererProvider.Context context) {
        this.staticLayer = context.m_173582_(STATIC_LAYER);
        this.movableLayer = context.m_173582_(MOVABLE_LAYER);
        this.greenIndicatorLayer = context.m_173582_(GREEN_INDICATOR_LAYER);
        this.blueIndicatorLayer = context.m_173582_(BLUE_INDICATOR_LAYER);
        this.redIndicatorLayer = context.m_173582_(RED_INDICATOR_LAYER);
    }

    public static LayerDefinition createStaticLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("base", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 16.0f, 13.0f, 16.0f).m_171555_(true), PartPose.m_171419_((float)-8.0f, (float)11.0f, (float)-8.0f));
        partDefinition.m_171599_("top1", CubeListBuilder.m_171558_().m_171514_(66, 2).m_171481_(0.0f, 0.0f, 0.0f, 16.0f, 3.0f, 2.0f).m_171555_(true), PartPose.m_171419_((float)-8.0f, (float)8.0f, (float)-8.0f));
        partDefinition.m_171599_("top2", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 3.0f, 14.0f).m_171555_(true), PartPose.m_171419_((float)6.0f, (float)8.0f, (float)-6.0f));
        partDefinition.m_171599_("top3", CubeListBuilder.m_171558_().m_171514_(36, 32).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 3.0f, 14.0f).m_171555_(true), PartPose.m_171419_((float)-8.0f, (float)8.0f, (float)-6.0f));
        partDefinition.m_171599_("top4", CubeListBuilder.m_171558_().m_171514_(66, 10).m_171481_(0.0f, 0.0f, 0.0f, 12.0f, 3.0f, 2.0f).m_171555_(true), PartPose.m_171419_((float)-6.0f, (float)8.0f, (float)6.0f));
        partDefinition.m_171599_("top5", CubeListBuilder.m_171558_().m_171514_(72, 32).m_171481_(0.0f, 0.0f, 0.0f, 12.0f, 2.0f, 6.0f).m_171555_(true), PartPose.m_171419_((float)-6.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public static LayerDefinition createMovableLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_(MOVABLE, CubeListBuilder.m_171558_().m_171514_(70, 24).m_171481_(0.0f, 0.0f, 0.0f, 12.0f, 1.0f, 6.0f).m_171555_(true), PartPose.m_171419_((float)-6.0f, (float)8.533334f, (float)-6.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public static LayerDefinition createIndicatorLayer(int offsetY) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_(MOVABLE, CubeListBuilder.m_171558_().m_171514_(0, offsetY).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 1.0f).m_171555_(true), PartPose.m_171419_((float)-5.0f, (float)7.5f, (float)4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public void render(BlockEntityDimChest blockentity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (blockentity.m_58901_()) {
            return;
        }
        poseStack.m_85836_();
        this.renderBlock(blockentity, partialTicks, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
        poseStack.m_85849_();
    }

    private void renderBlock(BlockEntityDimChest blockentity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, -0.5, 0.5);
        poseStack.m_252781_(new Quaternionf().rotationXYZ(0.0f, (float)(360 - blockentity.rotation * 90) * ((float)Math.PI / 180), 0.0f));
        poseStack.m_252781_(new Quaternionf().rotationXYZ((float)Math.PI, 0.0f, 0.0f));
        poseStack.m_85837_(0.0, -2.0, 0.0);
        VertexConsumer buffer = bufferIn.m_6299_(RenderType.m_110446_((ResourceLocation)TEXTURE));
        this.staticLayer.m_104306_(poseStack, buffer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, blockentity.movablePartState);
        this.movableLayer.m_104306_(poseStack, buffer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        if (blockentity.locked) {
            this.redIndicatorLayer.m_104306_(poseStack, buffer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (blockentity.getFrequency().hasOwner()) {
            this.blueIndicatorLayer.m_104306_(poseStack, buffer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.greenIndicatorLayer.m_104306_(poseStack, buffer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85849_();
    }
}

