/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.network;

import immersive_melodies.cobalt.network.Message;
import immersive_melodies.resources.Melody;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public abstract class FragmentedMessage
extends Message {
    private final String name;
    private final byte[] fragment;
    private final int length;
    private static final Map<String, Queue<byte[]>> buffer = new ConcurrentHashMap<String, Queue<byte[]>>();

    public FragmentedMessage(String name, byte[] fragment, int length) {
        this.name = name;
        this.fragment = fragment;
        this.length = length;
    }

    public FragmentedMessage(FriendlyByteBuf b) {
        this.name = b.m_130277_();
        this.fragment = b.m_130052_();
        this.length = b.readInt();
    }

    @Override
    public void encode(FriendlyByteBuf b) {
        b.m_130070_(this.name);
        b.m_130087_(this.fragment);
        b.writeInt(this.length);
    }

    @Override
    public void receive(Player e) {
        String identifier = (e == null ? "local" : e.m_20149_()) + ":" + this.name;
        Queue byteBuffer = buffer.computeIfAbsent(identifier, k -> new ConcurrentLinkedQueue());
        byteBuffer.add(this.fragment);
        if (byteBuffer.stream().mapToInt(f -> ((byte[])f).length).sum() >= this.length) {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            for (byte[] b : byteBuffer) {
                buffer.writeBytes(b);
            }
            this.finish(e, this.name, new Melody(buffer));
            FragmentedMessage.buffer.remove(identifier);
        }
    }

    protected abstract void finish(Player var1, String var2, Melody var3);
}

