/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.suppsquared.common;

import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LightableLanternBlock
extends LanternBlock {
    public final VoxelShape shapeDown;
    public final VoxelShape shapeUp;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public LightableLanternBlock(BlockBehaviour.Properties properties, VoxelShape shape) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_153460_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_153459_, (Comparable)Boolean.valueOf(false)));
        this.shapeDown = shape;
        this.shapeUp = this.shapeDown.m_83216_(0.0, 0.875 - shape.m_83215_().f_82292_, 0.0);
    }

    public LightableLanternBlock(BlockBehaviour.Properties properties) {
        this(properties, Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), (VoxelShape)Block.m_49796_((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext collisionContext) {
        return (Boolean)state.m_61143_((Property)f_153459_) != false ? this.shapeUp : this.shapeDown;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIT});
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Optional<BlockState> optional = LightableLanternBlock.toggleLight(state, worldIn, pos, player, handIn);
        if (optional.isPresent()) {
            if (!worldIn.f_46443_) {
                worldIn.m_46597_(pos, optional.get());
            }
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static Optional<BlockState> toggleLight(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn) {
        if (Utils.mayBuild((Player)player, (BlockPos)pos) && handIn == InteractionHand.MAIN_HAND) {
            ItemStack item = player.m_21120_(handIn);
            if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                if (item.m_41720_() instanceof FlintAndSteelItem) {
                    worldIn.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, worldIn.m_213780_().m_188501_() * 0.4f + 0.8f);
                    state = (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true));
                    item.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
                    return Optional.of(state);
                }
                if (item.m_41720_() instanceof FireChargeItem) {
                    worldIn.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, (worldIn.m_213780_().m_188501_() - worldIn.m_213780_().m_188501_()) * 0.2f + 1.0f);
                    state = (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true));
                    if (!player.m_7500_()) {
                        item.m_41774_(1);
                    }
                    return Optional.of(state);
                }
            } else if (item.m_41619_()) {
                worldIn.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 0.5f, 1.5f);
                state = (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
                return Optional.of(state);
            }
        }
        return Optional.empty();
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockUtil.addOptionalOwnership((LivingEntity)placer, (Level)world, (BlockPos)pos);
    }
}

