/*
 * Decompiled with CFR 0.152.
 */
package fuzs.airhop.handler;

import fuzs.airhop.AirHop;
import fuzs.airhop.capability.AirHopsCapability;
import fuzs.airhop.config.ServerConfig;
import fuzs.airhop.init.ModRegistry;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class PlayerFallHandler {
    public static EventResult onLivingFall(LivingEntity entity, MutableFloat fallDistance, MutableFloat damageMultiplier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ModRegistry.AIR_HOPS_CAPABILITY.maybeGet((Object)player).ifPresent(capability -> {
                if (!((ServerConfig)AirHop.CONFIG.get(ServerConfig.class)).fallDamage && capability.getAirHops() > 0) {
                    fallDistance.mapFloat(distance -> Float.valueOf(Math.max(0.0f, distance.floatValue() - (float)capability.getAirHops() * PlayerFallHandler.getJumpHeight(player))));
                }
            });
        }
        return EventResult.PASS;
    }

    public static void onStartPlayerTick(Player player) {
        if (player.m_20096_()) {
            ModRegistry.AIR_HOPS_CAPABILITY.maybeGet((Object)player).ifPresent(AirHopsCapability::resetAirHops);
        }
    }

    public static float getJumpHeight(Player player) {
        float jumpHeight = 1.25f;
        if (player.m_21023_(MobEffects.f_19603_)) {
            jumpHeight += 0.6875f * ((float)player.m_21124_(MobEffects.f_19603_).m_19564_() + 1.0f);
        }
        return jumpHeight;
    }
}

