/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.roofs;

import com.mcwroofs.kikoz.init.ItemInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RoofBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0), Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0), Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0), Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), Block.m_49796_((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0)};
    protected static final VoxelShape[] TOP_SHAPES = RoofBlock.createStairShapes(SHAPES[0], SHAPES[2], SHAPES[6], SHAPES[3], SHAPES[7]);
    protected static final VoxelShape[] BOTTOM_SHAPES = RoofBlock.createStairShapes(SHAPES[1], SHAPES[4], SHAPES[8], SHAPES[5], SHAPES[9]);
    private static final int[] SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    private static VoxelShape[] createStairShapes(VoxelShape baseShape, VoxelShape ... shapes) {
        VoxelShape[] stairShapes = new VoxelShape[16];
        for (int i = 0; i < 16; ++i) {
            stairShapes[i] = baseShape;
            for (int j = 0; j < shapes.length; ++j) {
                if ((i & 1 << j) == 0) continue;
                stairShapes[i] = Shapes.m_83110_((VoxelShape)stairShapes[i], (VoxelShape)shapes[j]);
            }
        }
        return stairShapes;
    }

    public RoofBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_(SHAPE, (Comparable)StairsShape.STRAIGHT));
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext collision) {
        VoxelShape[] shapes = state.m_61143_(HALF) == Half.TOP ? TOP_SHAPES : BOTTOM_SHAPES;
        int shapeIndex = this.getShapeIndex(state);
        return shapes[SHAPE_BY_STATE[shapeIndex]];
    }

    private int getShapeIndex(BlockState state) {
        return ((StairsShape)state.m_61143_(SHAPE)).ordinal() * 4 + ((Direction)state.m_61143_((Property)FACING)).m_122416_();
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!state.m_60713_(state.m_60734_())) {
            level.m_213960_(this.m_49966_(), pos, Blocks.f_50016_, pos, false);
            this.m_6807_(statetwo, level, pos, statetwo, false);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!state.m_60713_(statetwo.m_60734_())) {
            this.m_6810_(statetwo, level, pos, statetwo, bool);
        }
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter getter, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item == ItemInit.ROOFING_HAMMER.get()) {
            StairsShape shape = (StairsShape)state.m_61143_(SHAPE);
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            StairsShape nextShape = this.getNextShape(shape);
            if (nextShape == StairsShape.STRAIGHT) {
                facing = facing.m_122427_();
            }
            state = (BlockState)((BlockState)state.m_61124_(SHAPE, (Comparable)nextShape)).m_61124_((Property)FACING, (Comparable)facing);
            world.m_7731_(pos, state, 1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private StairsShape getNextShape(StairsShape currentShape) {
        switch (currentShape) {
            case STRAIGHT: {
                return StairsShape.INNER_LEFT;
            }
            case INNER_LEFT: {
                return StairsShape.INNER_RIGHT;
            }
            case INNER_RIGHT: {
                return StairsShape.OUTER_LEFT;
            }
            case OUTER_LEFT: {
                return StairsShape.OUTER_RIGHT;
            }
            case OUTER_RIGHT: {
                return StairsShape.STRAIGHT;
            }
        }
        return StairsShape.STRAIGHT;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        BlockPos blockpos = context.m_8083_();
        Direction horizontalDirection = context.m_8125_();
        Half half = !(direction == Direction.DOWN || direction != Direction.UP && context.m_43720_().f_82480_ - (double)blockpos.m_123342_() > 0.5) ? Half.BOTTOM : Half.TOP;
        StairsShape shape = RoofBlock.getStairsShape((BlockGetter)context.m_43725_(), blockpos, horizontalDirection, half);
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)horizontalDirection)).m_61124_(HALF, (Comparable)half)).m_61124_(SHAPE, (Comparable)shape);
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState statetwo, LevelAccessor access, BlockPos pos, BlockPos postwo) {
        return dir.m_122434_().m_122479_() ? (BlockState)state.m_61124_(SHAPE, (Comparable)RoofBlock.getStairsShape((BlockGetter)access, pos, (Direction)state.m_61143_((Property)FACING), (Half)state.m_61143_(HALF))) : super.m_7417_(state, dir, statetwo, access, pos, postwo);
    }

    private static StairsShape getStairsShape(BlockGetter reader, BlockPos pos, Direction facing, Half half) {
        Direction direction2;
        Direction direction1;
        Direction direction = facing;
        BlockState blockstate = reader.m_8055_(pos.m_121945_(direction));
        if (RoofBlock.isRoof(blockstate) && half == blockstate.m_61143_(HALF) && (direction1 = (Direction)blockstate.m_61143_((Property)FACING)).m_122434_() != facing.m_122434_() && RoofBlock.canTakeShape(direction1.m_122424_(), blockstate, reader, pos)) {
            return direction1 == direction.m_122428_() ? StairsShape.OUTER_LEFT : StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = reader.m_8055_(pos.m_121945_(direction.m_122424_()));
        if (RoofBlock.isRoof(blockstate1) && half == blockstate1.m_61143_(HALF) && (direction2 = (Direction)blockstate1.m_61143_((Property)FACING)).m_122434_() != facing.m_122434_() && RoofBlock.canTakeShape(direction2, blockstate1, reader, pos)) {
            return direction2 == direction.m_122428_() ? StairsShape.INNER_LEFT : StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(Direction dir, BlockState state, BlockGetter reader, BlockPos pos) {
        BlockState blockstate = reader.m_8055_(pos.m_121945_(dir));
        return !RoofBlock.isRoof(blockstate) || blockstate.m_61143_((Property)FACING) != state.m_61143_((Property)FACING) || blockstate.m_61143_(HALF) != state.m_61143_(HALF);
    }

    public static boolean isRoof(BlockState state) {
        return state.m_60734_() instanceof RoofBlock;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        if (mirror == Mirror.LEFT_RIGHT && direction.m_122434_() == Direction.Axis.Z) {
            return (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_122424_());
        }
        if (mirror == Mirror.FRONT_BACK && direction.m_122434_() == Direction.Axis.X) {
            return (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_122424_());
        }
        return super.m_6943_(state, mirror);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        state.m_61104_(new Property[]{FACING, HALF, SHAPE});
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }
}

