/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.client.emote;

import aurelienribon.tweenengine.BaseTween;
import aurelienribon.tweenengine.Timeline;
import aurelienribon.tweenengine.Tween;
import aurelienribon.tweenengine.TweenEquation;
import aurelienribon.tweenengine.TweenEquations;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.tweaks.client.emote.EmoteDescriptor;
import org.violetmoon.quark.content.tweaks.client.emote.EmoteSound;
import org.violetmoon.quark.content.tweaks.client.emote.ModelAccessor;

public class EmoteTemplate {
    private static final Map<String, Integer> parts;
    private static final Map<String, Integer> tweenables;
    private static final Map<String, Function> functions;
    private static final Map<String, TweenEquation> equations;
    public final String file;
    public List<String> readLines;
    public List<Integer> usedParts;
    public Stack<Timeline> timelineStack;
    public float speed;
    public int tier;
    public boolean compiled = false;
    public boolean compiledOnce = false;
    private List<EmoteSound> activeSounds = Lists.newArrayList();

    public EmoteTemplate(String file) {
        this.file = file;
        this.readAndMakeTimeline(null, null, null);
    }

    public Timeline getTimeline(EmoteDescriptor desc, Player player, HumanoidModel<?> model) {
        int i;
        this.compiled = false;
        this.speed = 1.0f;
        this.tier = 0;
        if (this.readLines == null) {
            return this.readAndMakeTimeline(desc, player, model);
        }
        Timeline timeline = null;
        this.timelineStack = new Stack();
        try {
            for (i = 0; i < this.readLines.size() && !this.compiled; ++i) {
                timeline = this.handle(model, player, timeline, this.readLines.get(i));
            }
        }
        catch (Exception e) {
            this.logError(e, i);
            return Timeline.createSequence();
        }
        if (timeline == null) {
            return Timeline.createSequence();
        }
        return timeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timeline readAndMakeTimeline(EmoteDescriptor desc, Player player, HumanoidModel<?> model) {
        Timeline timeline = null;
        this.usedParts = new ArrayList<Integer>();
        this.timelineStack = new Stack();
        int lines = 0;
        this.tier = 0;
        this.compiledOnce = false;
        this.compiled = false;
        this.readLines = new ArrayList<String>();
        try {
            Timeline timeline2;
            block23: {
                BufferedReader reader;
                block21: {
                    block22: {
                        reader = this.createReader();
                        try {
                            try {
                                String s;
                                while ((s = reader.readLine()) != null && !this.compiled) {
                                    ++lines;
                                    this.readLines.add(s);
                                    timeline = this.handle(model, player, timeline, s);
                                }
                            }
                            catch (Exception e) {
                                this.logError(e, lines);
                                Timeline timeline3 = this.fallback();
                                if (reader != null) {
                                    reader.close();
                                }
                                this.compiledOnce = true;
                                if (desc != null) {
                                    desc.updateTier(this);
                                }
                                return timeline3;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                if (reader != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                Quark.LOG.warn("Failed to load emote " + String.valueOf(desc), (Throwable)e);
                                timeline2 = this.fallback();
                                return timeline2;
                            }
                        }
                        if (timeline != null) break block21;
                        timeline2 = this.fallback();
                        if (reader == null) break block22;
                        reader.close();
                    }
                    return timeline2;
                }
                timeline2 = timeline;
                if (reader == null) break block23;
                reader.close();
            }
            return timeline2;
        }
        finally {
            this.compiledOnce = true;
            if (desc != null) {
                desc.updateTier(this);
            }
        }
    }

    protected BufferedReader createReader() throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader(Quark.class.getResourceAsStream("/assets/quark/emotes/" + this.file)));
    }

    protected Timeline fallback() {
        return Timeline.createSequence();
    }

    private void logError(Exception e, int line) {
        Quark.LOG.error("[Custom Emotes] Error loading line " + (line + 1) + " of emote " + this.file);
        if (!(e instanceof IllegalArgumentException)) {
            Quark.LOG.error("[Custom Emotes] This is an Internal Error, and not one in the emote file, please report it", (Throwable)e);
        } else {
            Quark.LOG.error("[Custom Emotes] " + e.getMessage());
        }
    }

    private Timeline handle(HumanoidModel<?> model, Player player, Timeline timeline, String s) throws IllegalArgumentException {
        if ((s = s.trim()).startsWith("#") || s.isEmpty()) {
            return timeline;
        }
        String[] tokens = s.trim().split(" ");
        String function = tokens[0];
        if (functions.containsKey(function)) {
            return functions.get(function).invoke(this, model, player, timeline, tokens);
        }
        throw new IllegalArgumentException("Illegal function name " + function);
    }

    protected void setName(String[] tokens) {
    }

    private static Timeline name(EmoteTemplate em, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        em.setName(tokens);
        return timeline;
    }

    private static Timeline use(EmoteTemplate em, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        if (em.compiledOnce) {
            return timeline;
        }
        EmoteTemplate.assertParamSize(tokens, 2);
        String part = tokens[1];
        if (!parts.containsKey(part)) {
            throw new IllegalArgumentException("Illegal part name for function use: " + part);
        }
        em.usedParts.add(parts.get(part));
        return timeline;
    }

    private static Timeline unit(EmoteTemplate em, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        EmoteTemplate.assertParamSize(tokens, 2);
        em.speed = Float.parseFloat(tokens[1]);
        return timeline;
    }

    private static Timeline tier(EmoteTemplate em, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        EmoteTemplate.assertParamSize(tokens, 2);
        em.tier = Integer.parseInt(tokens[1]);
        return timeline;
    }

    private static Timeline animation(EmoteTemplate em, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        String type;
        if (timeline != null) {
            throw new IllegalArgumentException("Illegal use of function animation, animation already started");
        }
        EmoteTemplate.assertParamSize(tokens, 2);
        Timeline newTimeline = switch (type = tokens[1]) {
            case "sequence" -> Timeline.createSequence();
            case "parallel" -> Timeline.createParallel();
            default -> throw new IllegalArgumentException("Illegal animation type: " + type);
        };
        newTimeline.addCallback(2, tween -> {
            EmoteSound.endAll(em.activeSounds);
            em.activeSounds = Lists.newArrayList();
        });
        return newTimeline;
    }

    private static Timeline section(EmoteTemplate em, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        String type;
        if (timeline == null) {
            throw new IllegalArgumentException("Illegal use of function section, animation not started");
        }
        EmoteTemplate.assertParamSize(tokens, 2);
        Timeline newTimeline = switch (type = tokens[1]) {
            case "sequence" -> Timeline.createSequence();
            case "parallel" -> Timeline.createParallel();
            default -> throw new IllegalArgumentException("Illegal section type: " + type);
        };
        em.timelineStack.push(timeline);
        return newTimeline;
    }

    private static Timeline end(EmoteTemplate em, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        if (timeline == null) {
            throw new IllegalArgumentException("Illegal use of function end, animation not started");
        }
        EmoteTemplate.assertParamSize(tokens, 1);
        if (em.timelineStack.isEmpty()) {
            em.compiled = true;
            return timeline;
        }
        Timeline poppedLine = em.timelineStack.pop();
        poppedLine.push(timeline);
        return poppedLine;
    }

    private static Timeline move(EmoteTemplate em, HumanoidModel<?> model, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        boolean valid;
        if (timeline == null) {
            throw new IllegalArgumentException("Illegal use of function move, animation not started");
        }
        if (tokens.length < 4) {
            throw new IllegalArgumentException(String.format("Illegal parameter amount for function move: %d (at least 4 are required)", tokens.length));
        }
        String partStr = tokens[1];
        if (!tweenables.containsKey(partStr)) {
            throw new IllegalArgumentException("Illegal part name for function move: " + partStr);
        }
        int part = tweenables.get(partStr);
        float time = Float.parseFloat(tokens[2]) * em.speed;
        float target = Float.parseFloat(tokens[3]);
        Tween tween = null;
        boolean bl = valid = model != null;
        if (valid) {
            tween = Tween.to(model, part, time).target(target);
        }
        if (tokens.length > 4) {
            int index = 4;
            block12: while (index < tokens.length) {
                String cmd;
                switch (cmd = tokens[index++]) {
                    case "delay": {
                        EmoteTemplate.assertParamSize("delay", tokens, 1, index);
                        float delay = Float.parseFloat(tokens[index++]) * em.speed;
                        if (!valid) continue block12;
                        tween = (Tween)tween.delay(delay);
                        break;
                    }
                    case "yoyo": {
                        EmoteTemplate.assertParamSize("yoyo", tokens, 2, index);
                        int times = Integer.parseInt(tokens[index++]);
                        float delay = Float.parseFloat(tokens[index++]) * em.speed;
                        if (!valid) continue block12;
                        tween = (Tween)tween.repeatYoyo(times, delay);
                        break;
                    }
                    case "repeat": {
                        EmoteTemplate.assertParamSize("repeat", tokens, 2, index);
                        int times = Integer.parseInt(tokens[index++]);
                        float delay = Float.parseFloat(tokens[index++]) * em.speed;
                        if (!valid) continue block12;
                        tween = (Tween)tween.repeat(times, delay);
                        break;
                    }
                    case "ease": {
                        EmoteTemplate.assertParamSize("ease", tokens, 1, index);
                        String easeType = tokens[index++];
                        if (equations.containsKey(easeType)) {
                            if (!valid) continue block12;
                            tween.ease(equations.get(easeType));
                            break;
                        }
                        throw new IllegalArgumentException("Easing type " + easeType + " doesn't exist");
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Invalid modifier %s for move function", cmd));
                    }
                }
            }
        }
        if (valid) {
            return timeline.push(tween);
        }
        return timeline;
    }

    private static Timeline sound(EmoteTemplate em, Player player, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        if (timeline == null) {
            throw new IllegalArgumentException("Illegal use of function sound, animation not started");
        }
        if (tokens.length < 2) {
            throw new IllegalArgumentException("Expected action (continuous, instant, stop) for function sound");
        }
        String playType = tokens[1];
        if (playType.equals("stop")) {
            List<BaseTween<?>> children = timeline.getChildren();
            BaseTween callbackTween = timeline;
            int tweenEvent = 2;
            if (!children.isEmpty()) {
                tweenEvent = 8;
                callbackTween = children.get(children.size() - 1);
            }
            callbackTween.addCallback(tweenEvent, tween -> EmoteSound.endAll(em.activeSounds));
        } else {
            boolean repeating = playType.equals("continuous");
            if (!repeating && !playType.equals("instant")) {
                throw new IllegalArgumentException(String.format("Invalid modifier %s for sound function", playType));
            }
            EmoteTemplate.assertParamSize(tokens, 4, 6);
            String endCondition = tokens[2];
            boolean endWithSequence = endCondition.equals("section");
            if (!endWithSequence && !endCondition.equals("emote")) {
                throw new IllegalArgumentException(String.format("Invalid modifier %s for sound function", endCondition));
            }
            String type = tokens[3];
            float volume = 1.0f;
            float pitch = 1.0f;
            try {
                if (tokens.length >= 5) {
                    volume = Math.min(Float.parseFloat(tokens[4]), 1.5f);
                }
                if (tokens.length >= 6) {
                    pitch = Float.parseFloat(tokens[5]);
                }
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Illegal number in function sound", ex);
            }
            ResourceLocation soundEvent = new ResourceLocation(type);
            List<BaseTween<?>> children = timeline.getChildren();
            ArrayList sounds = Lists.newArrayList();
            float finalVolume = volume;
            float finalPitch = pitch;
            BaseTween callbackTween = timeline;
            int tweenEvent = 2;
            if (!children.isEmpty()) {
                tweenEvent = 8;
                callbackTween = children.get(children.size() - 1);
            }
            callbackTween.addCallback(tweenEvent, tween -> EmoteSound.add(em.activeSounds, sounds, player, em, soundEvent, finalVolume, finalPitch, repeating, endWithSequence));
            timeline.addCallback(8, tween -> EmoteSound.endSection(sounds));
        }
        return timeline;
    }

    private static Timeline reset(EmoteTemplate em, HumanoidModel<?> model, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        boolean off;
        if (tokens.length < 4) {
            throw new IllegalArgumentException(String.format("Illegal parameter amount for function reset: %d (at least 4 are required)", tokens.length));
        }
        String part = tokens[1];
        boolean allParts = part.equals("all");
        if (!allParts && !parts.containsKey(part)) {
            throw new IllegalArgumentException("Illegal part name for function reset: " + part);
        }
        String type = tokens[2];
        boolean all = type.equals("all");
        boolean rot = all || type.equals("rotation");
        boolean bl = off = all || type.equals("offset");
        if (!rot && !off) {
            throw new IllegalArgumentException("Illegal reset type: " + type);
        }
        int partInt = allParts ? 0 : parts.get(part);
        float time = Float.parseFloat(tokens[3]) * em.speed;
        if (model != null) {
            int lower;
            Timeline parallel = Timeline.createParallel();
            int n = allParts ? 0 : (lower = partInt + (rot ? 0 : 3));
            int upper = allParts ? 21 : partInt + (off ? 21 : 3);
            for (int i = lower; i < upper; ++i) {
                int piece = i / 3 * 3;
                if (!em.usedParts.contains(piece)) continue;
                parallel.push(Tween.to(model, i, time));
            }
            timeline.push(parallel);
        }
        return timeline;
    }

    private static Timeline pause(EmoteTemplate em, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        EmoteTemplate.assertParamSize(tokens, 2);
        float ms = Float.parseFloat(tokens[1]) * em.speed;
        return timeline.pushPause(ms);
    }

    private static Timeline yoyo(EmoteTemplate em, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        EmoteTemplate.assertParamSize(tokens, 3);
        int times = Integer.parseInt(tokens[1]);
        float delay = Float.parseFloat(tokens[2]) * em.speed;
        return (Timeline)timeline.repeatYoyo(times, delay);
    }

    private static Timeline repeat(EmoteTemplate em, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        EmoteTemplate.assertParamSize(tokens, 3);
        int times = Integer.parseInt(tokens[1]);
        float delay = Float.parseFloat(tokens[2]) * em.speed;
        return (Timeline)timeline.repeat(times, delay);
    }

    private static void assertParamSize(String[] tokens, int expect) throws IllegalArgumentException {
        if (tokens.length != expect) {
            throw new IllegalArgumentException(String.format("Illegal parameter amount for function %s: %d (expected %d)", tokens[0], tokens.length, expect));
        }
    }

    private static void assertParamSize(String[] tokens, int expectMin, int expectMax) throws IllegalArgumentException {
        if (tokens.length > expectMax || tokens.length < expectMin) {
            throw new IllegalArgumentException(String.format("Illegal parameter amount for function %s: %d (expected between %d and %d)", tokens[0], tokens.length, expectMin, expectMax));
        }
    }

    private static void assertParamSize(String mod, String[] tokens, int expect, int startingFrom) throws IllegalArgumentException {
        if (tokens.length - startingFrom < expect) {
            throw new IllegalArgumentException(String.format("Illegal parameter amount for move modifier %s: %d (expected at least %d)", mod, tokens.length, expect));
        }
    }

    public boolean usesBodyPart(int part) {
        return this.usedParts.contains(part);
    }

    static {
        Field[] fields;
        parts = new HashMap<String, Integer>();
        tweenables = new HashMap<String, Integer>();
        functions = new HashMap<String, Function>();
        equations = new HashMap<String, TweenEquation>();
        functions.put("name", (em, model, player, timeline, tokens) -> EmoteTemplate.name(em, timeline, tokens));
        functions.put("use", (em, model, player, timeline, tokens) -> EmoteTemplate.use(em, timeline, tokens));
        functions.put("unit", (em, model, player, timeline, tokens) -> EmoteTemplate.unit(em, timeline, tokens));
        functions.put("animation", (em, model, player, timeline, tokens) -> EmoteTemplate.animation(em, timeline, tokens));
        functions.put("section", (em, model, player, timeline, tokens) -> EmoteTemplate.section(em, timeline, tokens));
        functions.put("end", (em, model, player, timeline, tokens) -> EmoteTemplate.end(em, timeline, tokens));
        functions.put("move", (em, model, player, timeline, tokens) -> EmoteTemplate.move(em, model, timeline, tokens));
        functions.put("reset", (em, model, player, timeline, tokens) -> EmoteTemplate.reset(em, model, timeline, tokens));
        functions.put("pause", (em, model, player, timeline, tokens) -> EmoteTemplate.pause(em, timeline, tokens));
        functions.put("yoyo", (em, model, player, timeline, tokens) -> EmoteTemplate.yoyo(em, timeline, tokens));
        functions.put("repeat", (em, model, player, timeline, tokens) -> EmoteTemplate.repeat(em, timeline, tokens));
        functions.put("tier", (em, model, player, timeline, tokens) -> EmoteTemplate.tier(em, timeline, tokens));
        functions.put("sound", (em, model, player, timeline, tokens) -> EmoteTemplate.sound(em, player, timeline, tokens));
        Class clazz = ModelAccessor.class;
        for (Field f : fields = clazz.getDeclaredFields()) {
            int modifiers;
            if (f.getType() != Integer.TYPE || !Modifier.isPublic(modifiers = f.getModifiers()) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
            try {
                int val = f.getInt(null);
                String name = f.getName().toLowerCase(Locale.ROOT);
                if (name.matches("^.+?_[xyz]$")) {
                    tweenables.put(name, val);
                    continue;
                }
                parts.put(name, val);
            }
            catch (Exception e) {
                Quark.LOG.error("Failed while attempting to set up model parameters for emotes", (Throwable)e);
            }
        }
        clazz = TweenEquations.class;
        for (Field f : fields = clazz.getDeclaredFields()) {
            String name = f.getName().replaceAll("[A-Z]", "_$0").substring(5).toLowerCase(Locale.ROOT);
            try {
                TweenEquation eq = (TweenEquation)f.get(null);
                equations.put(name, eq);
                if (!name.equals("none")) continue;
                equations.put("linear", eq);
            }
            catch (Exception e) {
                Quark.LOG.error("Failed while attempting to set up tween equations for emotes", (Throwable)e);
            }
        }
    }

    private static interface Function {
        public Timeline invoke(EmoteTemplate var1, HumanoidModel<?> var2, Player var3, Timeline var4, String[] var5) throws IllegalArgumentException;
    }
}

