/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.network;

import com.hypherionmc.craterlib.CraterConstants;
import com.hypherionmc.craterlib.core.networking.PacketRegistry;
import com.hypherionmc.craterlib.core.networking.data.PacketContext;
import com.hypherionmc.craterlib.core.networking.data.PacketHolder;
import com.hypherionmc.craterlib.core.networking.data.PacketSide;
import com.hypherionmc.craterlib.nojang.network.BridgedFriendlyByteBuf;
import com.hypherionmc.craterlib.nojang.world.entity.player.BridgedPlayer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class CraterForgeNetworkHandler
extends PacketRegistry {
    private final Map<Class<?>, SimpleChannel> CHANNELS = new HashMap();

    public CraterForgeNetworkHandler(PacketSide side) {
        super(side);
    }

    @Override
    protected <T> void registerPacket(PacketHolder<T> holder) {
        if (this.CHANNELS.get(holder.messageType()) == null) {
            SimpleChannel channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)holder.type().toMojang()).clientAcceptedVersions(a -> true).serverAcceptedVersions(a -> true).networkProtocolVersion(() -> "1").simpleChannel();
            channel.registerMessage(0, holder.messageType(), this.mojangEncoder(holder.encoder()), this.mojangDecoder(holder.decoder()), this.buildHandler(holder.handler()));
            this.CHANNELS.put(holder.messageType(), channel);
        } else {
            CraterConstants.LOG.error("Trying to register duplicate packet for type {}", holder.messageType());
        }
    }

    @Override
    public <T> void sendToServer(T packet) {
        this.sendToServer(packet, false);
    }

    @Override
    public <T> void sendToServer(T packet, boolean ignoreCheck) {
        Connection connection;
        SimpleChannel channel = this.CHANNELS.get(packet.getClass());
        if (channel.isRemotePresent(connection = Minecraft.m_91087_().m_91403_().m_104910_()) || ignoreCheck) {
            channel.sendToServer(packet);
        }
    }

    @Override
    public <T> void sendToClient(T packet, BridgedPlayer player) {
        SimpleChannel channel = this.CHANNELS.get(packet.getClass());
        ServerGamePacketListenerImpl connection = player.getConnection();
        if (connection == null) {
            return;
        }
        if (channel.isRemotePresent(connection.f_9742_)) {
            channel.sendTo(packet, player.getConnection().f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    private <T> Function<FriendlyByteBuf, T> mojangDecoder(Function<BridgedFriendlyByteBuf, T> handler) {
        return byteBuf -> handler.apply(BridgedFriendlyByteBuf.of(byteBuf));
    }

    private <T> BiConsumer<T, FriendlyByteBuf> mojangEncoder(BiConsumer<T, BridgedFriendlyByteBuf> handler) {
        return (t, byteBuf) -> handler.accept(t, BridgedFriendlyByteBuf.of(byteBuf));
    }

    private <T> BiConsumer<T, Supplier<NetworkEvent.Context>> buildHandler(Consumer<PacketContext<T>> handler) {
        return (message, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> CraterForgeNetworkHandler.lambda$buildHandler$5((Supplier)ctx, handler, message));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        };
    }

    private static /* synthetic */ void lambda$buildHandler$5(Supplier ctx, Consumer handler, Object message) {
        PacketSide side = ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer() ? PacketSide.SERVER : PacketSide.CLIENT;
        ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
        handler.accept(new PacketContext<Object>(BridgedPlayer.of((Player)player), message, side));
    }
}

