/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.common.minecraft.blockEntity;

import cc.tweaked_programs.cccbridge.common.CCCRegistries;
import cc.tweaked_programs.cccbridge.common.computercraft.peripherals.RedRouterBlockPeripheral;
import cc.tweaked_programs.cccbridge.common.minecraft.blockEntity.PeripheralBlockEntity;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedRouterBlockEntity
extends BlockEntity
implements PeripheralBlockEntity {
    private final HashMap<String, Integer> outputDir = new HashMap();
    private final HashMap<String, Integer> inputDir = new HashMap();
    private boolean blockupdate = false;
    private boolean newInputs = false;
    private RedRouterBlockPeripheral peripheral;
    private Direction facing;

    public RedRouterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CCCRegistries.REDROUTER_BLOCK_ENTITY.get(), pos, state);
        this.facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        this.outputDir.put("up", 0);
        this.outputDir.put("down", 0);
        this.outputDir.put("north", 0);
        this.outputDir.put("east", 0);
        this.outputDir.put("south", 0);
        this.outputDir.put("west", 0);
        this.inputDir.put("up", 0);
        this.inputDir.put("down", 0);
        this.inputDir.put("north", 0);
        this.inputDir.put("east", 0);
        this.inputDir.put("south", 0);
        this.inputDir.put("west", 0);
    }

    public static void tick(Level world, BlockPos blockPos, BlockState state, BlockEntity be) {
        if (!(be instanceof RedRouterBlockEntity)) {
            return;
        }
        RedRouterBlockEntity redrouter = (RedRouterBlockEntity)be;
        if (state.m_61143_((Property)BlockStateProperties.f_61374_) != redrouter.facing) {
            redrouter.blockupdate = true;
            redrouter.facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        }
        if (redrouter.blockupdate) {
            world.m_46672_(blockPos, state.m_60734_());
            for (Direction dir : Direction.values()) {
                BlockPos relative = blockPos.m_121945_(dir);
                world.m_46672_(relative, world.m_8055_(relative).m_60734_());
            }
            redrouter.blockupdate = false;
        }
        RedRouterBlockEntity.updateInputs(world, blockPos, redrouter);
        if (redrouter.newInputs && redrouter.peripheral != null) {
            redrouter.peripheral.sendEvent("redstone", new Object[0]);
            redrouter.newInputs = false;
        }
    }

    public static void updateInputs(Level world, BlockPos blockPos, RedRouterBlockEntity redrouter) {
        for (Map.Entry<String, Integer> entry : redrouter.inputDir.entrySet()) {
            String side = entry.getKey();
            Direction dir = Direction.m_122402_((String)side).m_122424_();
            BlockPos offsetPos = blockPos.m_121945_(dir);
            BlockState block = world.m_8055_(offsetPos);
            int power = block.m_60734_().m_6378_(block, (BlockGetter)world, offsetPos, dir);
            redrouter.inputDir.put(side, power);
        }
    }

    public Direction getFacing() {
        if (this.facing == null) {
            return Direction.NORTH;
        }
        return this.facing;
    }

    public int getRedstoneInput(Direction side) {
        int value = 0;
        try {
            value = this.inputDir.get(side.m_122433_());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return value;
    }

    public int getPower(Direction side) {
        int value = 0;
        try {
            value = this.outputDir.get(side.m_122433_());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return value;
    }

    public void setPower(String side, int power) {
        this.outputDir.put(side, power);
        this.m_6596_();
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        for (Map.Entry<String, Integer> entry : this.outputDir.entrySet()) {
            String side = entry.getKey();
            this.outputDir.put(side, nbt.m_128451_(side));
        }
    }

    public void m_183515_(@NotNull CompoundTag nbt) {
        for (Map.Entry<String, Integer> entry : this.outputDir.entrySet()) {
            nbt.m_128405_(entry.getKey(), entry.getValue().intValue());
        }
        super.m_183515_(nbt);
    }

    public void m_6596_() {
        super.m_6596_();
        this.blockupdate = true;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Override
    public IPeripheral getPeripheral(@NotNull Direction side) {
        if (this.peripheral == null) {
            this.peripheral = new RedRouterBlockPeripheral(this);
        }
        return this.peripheral;
    }
}

