/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.common.minecraft.blockEntity;

import cc.tweaked_programs.cccbridge.client.RustyMovement;
import cc.tweaked_programs.cccbridge.common.CCCRegistries;
import cc.tweaked_programs.cccbridge.common.computercraft.peripherals.AnimatronicPeripheral;
import cc.tweaked_programs.cccbridge.common.minecraft.blockEntity.PeripheralBlockEntity;
import dan200.computercraft.api.peripheral.IPeripheral;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimatronicBlockEntity
extends BlockEntity
implements PeripheralBlockEntity {
    private Rotations headPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Rotations bodyPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Rotations leftArmPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Rotations rightArmPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Rotations current_headPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Rotations current_bodyPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Rotations current_leftArmPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Rotations current_rightArmPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Rotations start_headPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Rotations start_bodyPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Rotations start_leftArmPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Rotations start_rightArmPose = new Rotations(0.0f, 0.0f, 0.0f);
    private boolean isMoving = true;
    private double step = 0.0;
    private long start_animation = 0L;
    private String face = "normal";
    private AnimatronicPeripheral peripheral;

    public AnimatronicBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)CCCRegistries.ANIMATRONIC_BLOCK_ENTITY.get(), pos, blockState);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateCurrentPoses(float partialTicks) {
        this.step = (double)((float)(this.m_58904_().m_46467_() - this.start_animation) + partialTicks) * 0.10500000000000001;
        this.current_headPose = this.updatePose(this.start_headPose, this.getDestinationHeadPose(), false);
        this.current_bodyPose = this.updatePose(this.start_bodyPose, this.getDestinationBodyPose(), true);
        this.current_leftArmPose = this.updatePose(this.start_leftArmPose, this.getDestinationLeftArmPose(), false);
        this.current_rightArmPose = this.updatePose(this.start_rightArmPose, this.getDestinationRightArmPose(), false);
        if (this.step >= 1.0) {
            this.isMoving = false;
            this.current_headPose = this.getDestinationHeadPose();
            this.current_bodyPose = this.getDestinationBodyPose();
            this.current_leftArmPose = this.getDestinationLeftArmPose();
            this.current_rightArmPose = this.getDestinationRightArmPose();
        }
    }

    @Override
    @Nullable
    public IPeripheral getPeripheral(@NotNull Direction side) {
        if (side.m_122433_().equals(Direction.DOWN.m_122433_())) {
            if (this.peripheral == null) {
                this.peripheral = new AnimatronicPeripheral(this);
            }
            return this.peripheral;
        }
        return null;
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        ListTag ltHead = nbt.m_128437_("headPose", 5);
        Rotations headRot = ltHead.isEmpty() ? new Rotations(0.0f, 0.0f, 0.0f) : new Rotations(ltHead);
        this.setHeadPose(headRot.m_123156_(), headRot.m_123157_(), headRot.m_123158_());
        ListTag ltBody = nbt.m_128437_("bodyPose", 5);
        Rotations bodyRot = ltBody.isEmpty() ? new Rotations(0.0f, 0.0f, 0.0f) : new Rotations(ltBody);
        this.setBodyPose(bodyRot.m_123156_(), bodyRot.m_123157_(), bodyRot.m_123158_());
        ListTag ltLeftArm = nbt.m_128437_("leftArmPose", 5);
        Rotations leftArmRot = ltLeftArm.isEmpty() ? new Rotations(0.0f, 0.0f, 0.0f) : new Rotations(ltLeftArm);
        this.setLeftArmPose(leftArmRot.m_123156_(), leftArmRot.m_123157_(), leftArmRot.m_123158_());
        ListTag ltRightArmPose = nbt.m_128437_("rightArmPose", 5);
        Rotations rightArmRot = ltRightArmPose.isEmpty() ? new Rotations(0.0f, 0.0f, 0.0f) : new Rotations(ltRightArmPose);
        this.setRightArmPose(rightArmRot.m_123156_(), rightArmRot.m_123157_(), rightArmRot.m_123158_());
        this.setFace(nbt.m_128461_("face"));
        super.m_142466_(nbt);
        if (this.m_58904_() != null && this.m_58904_().f_46443_) {
            this.startAnimation();
        }
    }

    public void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128365_("headPose", (Tag)this.getDestinationHeadPose().m_123155_());
        nbt.m_128365_("bodyPose", (Tag)this.getDestinationBodyPose().m_123155_());
        nbt.m_128365_("leftArmPose", (Tag)this.getDestinationLeftArmPose().m_123155_());
        nbt.m_128365_("rightArmPose", (Tag)this.getDestinationRightArmPose().m_123155_());
        if (this.face != null) {
            nbt.m_128359_("face", this.face);
        }
        super.m_183515_(nbt);
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.m_58904_() != null) {
            if (this.m_58904_().f_46443_) {
                this.startAnimation();
            } else {
                this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    private Rotations updatePose(Rotations start, Rotations destination, boolean lazyWay) {
        float x = RustyMovement.updateMovement(start.m_123156_(), destination.m_123156_(), this.step, false);
        float y = RustyMovement.updateMovement(start.m_123157_(), destination.m_123157_(), this.step, lazyWay);
        float z = RustyMovement.updateMovement(start.m_123158_(), destination.m_123158_(), this.step, false);
        return new Rotations(x, y, z);
    }

    public boolean isMoving() {
        return this.isMoving;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Level m_58904_() {
        Level level = super.m_58904_();
        if (level == null) {
            level = Minecraft.m_91087_().f_91073_;
        }
        return level;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void startAnimation() {
        if (this.m_58904_() == null) {
            this.current_headPose = this.getHeadPose();
            this.current_bodyPose = this.getBodyPose();
            this.current_leftArmPose = this.getLeftArmPose();
            this.current_rightArmPose = this.getRightArmPose();
            return;
        }
        this.start_animation = this.m_58904_().m_46467_();
        this.start_headPose = this.current_headPose;
        this.start_bodyPose = this.current_bodyPose;
        this.start_leftArmPose = this.current_leftArmPose;
        this.start_rightArmPose = this.current_rightArmPose;
        this.isMoving = true;
        this.step = 0.0;
    }

    public void setFace(String face) {
        this.face = face;
    }

    public void setRightArmPose(float x, float y, float z) {
        this.rightArmPose = new Rotations(x, y, z);
    }

    public void setLeftArmPose(float x, float y, float z) {
        this.leftArmPose = new Rotations(x, y, z);
    }

    public void setBodyPose(float x, float y, float z) {
        this.bodyPose = new Rotations(x, y, z);
    }

    public void setHeadPose(float x, float y, float z) {
        this.headPose = new Rotations(x, y, z);
    }

    public String getFace() {
        return this.face;
    }

    public Rotations getRightArmPose() {
        return this.current_rightArmPose;
    }

    public Rotations getLeftArmPose() {
        return this.current_leftArmPose;
    }

    public Rotations getBodyPose() {
        return this.current_bodyPose;
    }

    public Rotations getHeadPose() {
        return this.current_headPose;
    }

    public Rotations getDestinationHeadPose() {
        return this.headPose;
    }

    public Rotations getDestinationBodyPose() {
        return this.bodyPose;
    }

    public Rotations getDestinationLeftArmPose() {
        return this.leftArmPose;
    }

    public Rotations getDestinationRightArmPose() {
        return this.rightArmPose;
    }
}

