/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.common.computercraft.peripherals;

import cc.tweaked_programs.cccbridge.common.computercraft.TweakedPeripheral;
import cc.tweaked_programs.cccbridge.common.minecraft.blockEntity.RedRouterBlockEntity;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.core.computer.ComputerSide;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.Direction;

public class RedRouterBlockPeripheral
extends TweakedPeripheral<RedRouterBlockEntity> {
    public static final String REDSTONE_EVENT = "redstone";
    private final List<IComputerAccess> pcs = new LinkedList<IComputerAccess>();

    public static double getVersion() {
        return 1.0;
    }

    public RedRouterBlockPeripheral(RedRouterBlockEntity blockentity) {
        super("redrouter", blockentity);
    }

    public Direction getActualSide(ComputerSide side) {
        RedRouterBlockEntity be = (RedRouterBlockEntity)this.getTarget();
        if (be != null) {
            Direction facing = ((RedRouterBlockEntity)this.getTarget()).getFacing();
            return switch (side.getName()) {
                case "front" -> facing.m_122424_();
                case "back" -> facing;
                case "left" -> facing.m_122427_();
                case "right" -> facing.m_122428_();
                case "top" -> Direction.DOWN;
                case "bottom" -> Direction.UP;
                default -> Direction.NORTH;
            };
        }
        return Direction.NORTH;
    }

    @LuaFunction
    public final void setOutput(ComputerSide side, boolean on) {
        RedRouterBlockEntity be = (RedRouterBlockEntity)this.getTarget();
        if (be != null) {
            be.setPower(this.getActualSide(side).m_122433_(), on ? 15 : 0);
        }
    }

    @LuaFunction
    public final boolean getOutput(ComputerSide side) {
        RedRouterBlockEntity be = (RedRouterBlockEntity)this.getTarget();
        if (be != null) {
            return be.getPower(this.getActualSide(side)) > 0;
        }
        return false;
    }

    @LuaFunction
    public final boolean getInput(ComputerSide side) {
        RedRouterBlockEntity be = (RedRouterBlockEntity)this.getTarget();
        if (be != null) {
            return be.getRedstoneInput(this.getActualSide(side)) > 0;
        }
        return false;
    }

    @LuaFunction(value={"setAnalogOutput", "setAnalogueOutput"})
    public final void setAnalogOutput(ComputerSide side, int value) throws LuaException {
        if (value < 0 || value > 15) {
            throw new LuaException("Expected number in range 0-15");
        }
        RedRouterBlockEntity be = (RedRouterBlockEntity)this.getTarget();
        if (be != null) {
            be.setPower(this.getActualSide(side).m_122433_(), value);
        }
    }

    @LuaFunction(value={"getAnalogOutput", "getAnalogueOutput"})
    public final int getAnalogOutput(ComputerSide side) {
        RedRouterBlockEntity be = (RedRouterBlockEntity)this.getTarget();
        if (be != null) {
            return be.getPower(this.getActualSide(side));
        }
        return 0;
    }

    @LuaFunction(value={"getAnalogInput", "getAnalogueInput"})
    public final int getAnalogInput(ComputerSide side) {
        RedRouterBlockEntity be = (RedRouterBlockEntity)this.getTarget();
        if (be != null) {
            return be.getRedstoneInput(this.getActualSide(side));
        }
        return 0;
    }
}

