/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.integration.rei.categories.item;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.integration.rei.AetherREIServerPlugin;
import com.aetherteam.aether.integration.rei.categories.item.AetherCookingRecipeDisplay;
import com.aetherteam.aether.recipe.recipes.item.AltarRepairRecipe;
import com.aetherteam.aether.recipe.recipes.item.EnchantingRecipe;
import com.aetherteam.aether.recipe.recipes.item.FreezingRecipe;
import com.aetherteam.aether.recipe.recipes.item.IncubationRecipe;
import com.aetherteam.nitrogen.integration.rei.categories.AbstractRecipeCategory;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.mutable.MutableDouble;

public class AetherCookingRecipeCategory<R extends Recipe<?>>
extends AbstractRecipeCategory<AetherCookingRecipeDisplay<R>> {
    public static final ResourceLocation ALTAR_TEXTURE = new ResourceLocation("aether", "textures/gui/menu/altar.png");
    public static final ResourceLocation FREEZER_TEXTURE = new ResourceLocation("aether", "textures/gui/menu/freezer.png");
    public static final ResourceLocation INCUBATOR_TEXTURE = new ResourceLocation("aether", "textures/gui/menu/incubator.png");
    protected final Supplier<WidgetWithBounds> fuelIndicator = () -> AetherCookingRecipeCategory.fuelIndicator(texture);
    protected final Supplier<WidgetWithBounds> animatedProgressArrow;

    public AetherCookingRecipeCategory(String id, CategoryIdentifier<AetherCookingRecipeDisplay<R>> categoryIdentifier, int width, int height, Renderer icon, ResourceLocation texture) {
        this(id, categoryIdentifier, width, height, icon, texture, () -> AetherCookingRecipeCategory.animatedArrow(texture, 100));
    }

    public AetherCookingRecipeCategory(String id, CategoryIdentifier<AetherCookingRecipeDisplay<R>> categoryIdentifier, int width, int height, Renderer icon, ResourceLocation texture, Supplier<WidgetWithBounds> animatedProgressArrow) {
        super(id, categoryIdentifier, width, height, icon);
        this.animatedProgressArrow = animatedProgressArrow;
    }

    public static AetherCookingRecipeCategory<AltarRepairRecipe> altarRepair() {
        return new AetherCookingRecipeCategory<AltarRepairRecipe>("altar.repairing", AetherREIServerPlugin.ALTAR_REPAIR, 140, 39, (Renderer)EntryStacks.of((ItemLike)((ItemLike)AetherBlocks.ALTAR.get())), ALTAR_TEXTURE);
    }

    public static AetherCookingRecipeCategory<EnchantingRecipe> altarEnchanting() {
        return new AetherCookingRecipeCategory<EnchantingRecipe>("altar.enchanting", AetherREIServerPlugin.ALTAR_ENCHANTING, 140, 39, (Renderer)EntryStacks.of((ItemLike)((ItemLike)AetherBlocks.ALTAR.get())), ALTAR_TEXTURE);
    }

    public static AetherCookingRecipeCategory<FreezingRecipe> freezing() {
        return new AetherCookingRecipeCategory<FreezingRecipe>("freezing", AetherREIServerPlugin.FREEZING, 140, 39, (Renderer)EntryStacks.of((ItemLike)((ItemLike)AetherBlocks.FREEZER.get())), FREEZER_TEXTURE);
    }

    public static AetherCookingRecipeCategory<IncubationRecipe> incubating() {
        return new AetherCookingRecipeCategory<IncubationRecipe>("incubating", AetherREIServerPlugin.INCUBATING, 88, 54, (Renderer)EntryStacks.of((ItemLike)((ItemLike)AetherBlocks.INCUBATOR.get())), INCUBATOR_TEXTURE, () -> {
            MutableDouble lastTick = new MutableDouble(0.0);
            Rectangle widgetBound = new Rectangle(8, -13, 10, 54);
            return Widgets.wrapRenderer((Rectangle)widgetBound, (graphics, bound, mouseX, mouseY, delta) -> {
                lastTick.getAndAdd((double)delta);
                if (lastTick.getValue() > 5700.0) {
                    lastTick.setValue(0.0);
                }
                int textureLength = 54;
                int scissorOffset = (int)Math.round((double)textureLength * (lastTick.getValue() / 5700.0));
                graphics.m_280218_(INCUBATOR_TEXTURE, bound.x, bound.y, 103, 16, 9, 54);
                graphics.m_280588_(bound.x, bound.y + textureLength - scissorOffset, bound.x + 10, bound.y + textureLength * 2 - scissorOffset);
                graphics.m_280218_(INCUBATOR_TEXTURE, bound.x, bound.y, 179, 16, 10, 54);
                graphics.m_280618_();
            });
        });
    }

    private static WidgetWithBounds fuelIndicator(ResourceLocation texture) {
        return Widgets.wrapRenderer((Rectangle)new Rectangle(14, 13), (graphics, bounds, mouseX, mouseY, delta) -> graphics.m_280218_(texture, bounds.x, bounds.y, 176, 0, 14, 13));
    }

    private static WidgetWithBounds animatedArrow(ResourceLocation texture, int burnTime) {
        MutableDouble lastTick = new MutableDouble(0.0);
        return Widgets.wrapRenderer((Rectangle)new Rectangle(23, 16), (graphics, bound, mouseX, mouseY, delta) -> {
            lastTick.getAndAdd((double)delta);
            if (lastTick.getValue() > (double)burnTime) {
                lastTick.setValue(0.0);
            }
            int xOffset = 23 - (int)Math.round(23.0 * (lastTick.getValue() / (double)burnTime));
            ResourceLocation blankArrow = REIRuntime.getInstance().getDefaultDisplayTexture(false);
            graphics.m_280218_(blankArrow, bound.x, bound.y, 106, 91, 24, 17);
            graphics.m_280588_(bound.x - xOffset, bound.y, bound.x + 23 - xOffset, bound.y + 16);
            graphics.m_280218_(texture, bound.x, bound.y, 176, 14, 23, 16);
            graphics.m_280618_();
        });
    }

    public List<Widget> setupDisplay(AetherCookingRecipeDisplay<R> display, Rectangle bounds) {
        List widgets = super.setupDisplay(display, bounds);
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.y + 10);
        DecimalFormat df = new DecimalFormat("###.##");
        float experience = display.getExperience();
        int cookingTime = display.getCookingTime();
        MutableComponent cookInfo = experience > 0.0f ? Component.m_237110_((String)"category.rei.cooking.time&xp", (Object[])new Object[]{df.format(experience), df.format((double)cookingTime / 20.0)}) : Component.m_237110_((String)"category.rei.campfire.time", (Object[])new Object[]{df.format((double)cookingTime / 20.0)});
        Point labelPoint = new Point(bounds.x + bounds.width - 5, bounds.y + 5);
        if (display.isIncubation()) {
            int n = labelPoint.x;
            int n2 = bounds.getCenterY();
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            labelPoint.move(n, n2 - 9 / 2);
        }
        widgets.add(Widgets.createLabel((Point)labelPoint, (Component)cookInfo).noShadow().rightAligned().color(-12566464, -4473925));
        Point arrowPoint = new Point(startPoint.x + 24, startPoint.y + 8);
        WidgetWithBounds arrowWidget = this.animatedProgressArrow.get();
        arrowWidget.getBounds().translate(arrowPoint.x, arrowPoint.y);
        widgets.add(arrowWidget);
        if (display.isIncubation()) {
            startPoint.translate(6, 5);
        }
        WidgetWithBounds fuelWidget = this.fuelIndicator.get();
        fuelWidget.getBounds().move(startPoint.x + 2, startPoint.y + 20);
        widgets.add(fuelWidget);
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 1, startPoint.y + 1)).entries((Collection)display.getInputEntries().get(0)).markInput());
        List outputEntries = display.getOutputEntries();
        if (outputEntries.size() > 0) {
            widgets.add(Widgets.createResultSlotBackground((Point)new Point(startPoint.x + 61, startPoint.y + 9)));
            widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 61, startPoint.y + 9)).entries((Collection)outputEntries.get(0)).disableBackground().markOutput());
        }
        return widgets;
    }

    public Component getTitle() {
        return Component.m_237115_((String)("gui.aether.jei." + this.id));
    }
}

