/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.world.item.enchantment.serialize.entry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonSyntaxException;
import fuzs.universalenchants.world.item.enchantment.data.BuiltInEnchantmentDataManager;
import fuzs.universalenchants.world.item.enchantment.serialize.entry.IncompatibleEntry;
import fuzs.universalenchants.world.item.enchantment.serialize.entry.TypeEntry;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public abstract class DataEntry<T> {
    public abstract void dissolve(Set<T> var1) throws JsonSyntaxException;

    public abstract void serialize(JsonArray var1);

    public static Builder defaultBuilder(Enchantment enchantment) {
        Builder builder = new Builder(enchantment).add(BuiltInEnchantmentDataManager.INSTANCE.getVanillaCategory(enchantment));
        BuiltInRegistries.f_256876_.m_123024_().filter(Predicate.not(arg_0 -> ((Enchantment)enchantment).m_44695_(arg_0))).filter(other -> enchantment != other).forEach(builder::add);
        return builder;
    }

    public static class Builder {
        private final Enchantment enchantment;
        private final List<DataEntry<?>> entries = Lists.newArrayList();
        private final IncompatibleEntry incompatibleEntry = new IncompatibleEntry();

        private Builder(Enchantment enchantment) {
            this.enchantment = enchantment;
            this.entries.add(this.incompatibleEntry);
        }

        public Builder add(Item item) {
            return this.add(item, false);
        }

        public Builder add(Item item, boolean exclude) {
            Objects.requireNonNull(item, "item for enchantment %s is null".formatted(BuiltInRegistries.f_256876_.m_7981_((Object)this.enchantment)));
            TypeEntry.ItemEntry entry = new TypeEntry.ItemEntry(item);
            entry.setExclude(exclude);
            this.entries.add(entry);
            return this;
        }

        public Builder add(EnchantmentCategory category) {
            return this.add(category, false);
        }

        public Builder add(EnchantmentCategory category, boolean exclude) {
            Objects.requireNonNull(category, "category for enchantment %s is null".formatted(BuiltInRegistries.f_256876_.m_7981_((Object)this.enchantment)));
            if (!BuiltInEnchantmentDataManager.INSTANCE.testVanillaCategory(category)) {
                throw new IllegalArgumentException("Cannot add custom category %s to enchantment data entry builder for %s".formatted(category, BuiltInRegistries.f_256876_.m_7981_((Object)this.enchantment)));
            }
            TypeEntry.CategoryEntry entry = new TypeEntry.CategoryEntry(category);
            entry.setExclude(exclude);
            this.entries.add(entry);
            return this;
        }

        public Builder add(TagKey<Item> tag) {
            return this.add(tag, false);
        }

        public Builder add(TagKey<Item> tag, boolean exclude) {
            Objects.requireNonNull(tag, "tag for enchantment %s is null".formatted(BuiltInRegistries.f_256876_.m_7981_((Object)this.enchantment)));
            TypeEntry.TagEntry entry = new TypeEntry.TagEntry(tag);
            entry.setExclude(exclude);
            this.entries.add(entry);
            return this;
        }

        public Builder add(Enchantment incompatible) {
            Objects.requireNonNull(incompatible, "incompatible enchantment for %s is null".formatted(BuiltInRegistries.f_256876_.m_7981_((Object)this.enchantment)));
            this.incompatibleEntry.incompatibles.add(incompatible);
            return this;
        }

        public Builder remove(Enchantment incompatible) {
            Objects.requireNonNull(incompatible, "incompatible enchantment for %s is null".formatted(BuiltInRegistries.f_256876_.m_7981_((Object)this.enchantment)));
            this.incompatibleEntry.incompatibles.remove(incompatible);
            return this;
        }

        public List<DataEntry<?>> build() {
            return ImmutableList.copyOf(this.entries);
        }
    }
}

