/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.world.item.crafting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MendingRepairItemRecipeHelper {
    public static boolean matches(CraftingContainer craftingContainer, Level level) {
        ArrayList itemToRepair = Lists.newArrayList();
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack itemStack = craftingContainer.m_8020_(i);
            if (itemStack.m_41619_() || itemStack.m_41613_() != 1 || !itemStack.m_41720_().m_41465_() || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44962_, (ItemStack)itemStack) <= 0) continue;
            itemToRepair.add(itemStack);
        }
        if (itemToRepair.size() == 1) {
            ItemStack stackToRepair = (ItemStack)itemToRepair.get(0);
            ArrayList repairMaterialItems = Lists.newArrayList();
            for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
                ItemStack itemStack = craftingContainer.m_8020_(i);
                if (itemStack.m_41619_() || itemStack == stackToRepair) continue;
                if (stackToRepair.m_41720_().m_6832_(stackToRepair, itemStack)) {
                    repairMaterialItems.add(itemStack);
                    continue;
                }
                return false;
            }
            return !repairMaterialItems.isEmpty() && (double)repairMaterialItems.size() <= Math.ceil((float)stackToRepair.m_41773_() * 4.0f / (float)stackToRepair.m_41776_());
        }
        return false;
    }

    public static ItemStack assemble(CraftingContainer craftingContainer) {
        ArrayList itemsToRepair = Lists.newArrayList();
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack itemStack2;
            ItemStack itemStack = craftingContainer.m_8020_(i);
            if (itemStack.m_41619_() || itemStack.m_41613_() != 1 || !itemStack.m_41720_().m_41465_()) continue;
            itemsToRepair.add(itemStack);
            if (itemsToRepair.size() <= 1 || itemStack.m_150930_((itemStack2 = (ItemStack)itemsToRepair.get(0)).m_41720_())) continue;
            return ItemStack.f_41583_;
        }
        ArrayList repairMaterialItems = Lists.newArrayList();
        if (itemsToRepair.size() == 1) {
            ItemStack stackToRepair = (ItemStack)itemsToRepair.get(0);
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44962_, (ItemStack)stackToRepair) > 0) {
                for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
                    ItemStack itemStack = craftingContainer.m_8020_(i);
                    if (itemStack.m_41619_() || itemStack == stackToRepair) continue;
                    if (stackToRepair.m_41720_().m_6832_(stackToRepair, itemStack)) {
                        repairMaterialItems.add(itemStack);
                        continue;
                    }
                    return ItemStack.f_41583_;
                }
                if (!repairMaterialItems.isEmpty()) {
                    int repairAmount;
                    stackToRepair = stackToRepair.m_41777_();
                    if ((double)repairMaterialItems.size() <= Math.ceil((float)stackToRepair.m_41773_() * 4.0f / (float)stackToRepair.m_41776_()) && (repairAmount = Math.min(stackToRepair.m_41773_(), stackToRepair.m_41776_() / 4)) > 0) {
                        for (int i = 0; i < repairMaterialItems.size(); ++i) {
                            stackToRepair.m_41721_(stackToRepair.m_41773_() - repairAmount);
                            repairAmount = Math.min(stackToRepair.m_41773_(), stackToRepair.m_41776_() / 4);
                        }
                        return stackToRepair;
                    }
                }
            }
            return ItemStack.f_41583_;
        }
        if (itemsToRepair.size() == 2) {
            ItemStack itemStack;
            ItemStack stack = ItemStack.f_41583_;
            ItemStack otherStack = ItemStack.f_41583_;
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44962_, (ItemStack)((ItemStack)itemsToRepair.get(0))) > 0) {
                stack = (ItemStack)itemsToRepair.get(0);
                otherStack = (ItemStack)itemsToRepair.get(1);
            } else if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44962_, (ItemStack)((ItemStack)itemsToRepair.get(1))) > 0) {
                stack = (ItemStack)itemsToRepair.get(1);
                otherStack = (ItemStack)itemsToRepair.get(0);
            }
            if (!stack.m_41619_()) {
                Map otherEnchantments;
                stack = stack.m_41777_();
                int l = stack.m_41776_() - stack.m_41773_();
                int m = otherStack.m_41776_() - otherStack.m_41773_();
                int n = m + stack.m_41776_() * 12 / 100;
                int o = l + n;
                int p = stack.m_41776_() - o;
                if (p < 0) {
                    p = 0;
                }
                if (p < stack.m_41773_()) {
                    stack.m_41721_(p);
                }
                if (!(otherEnchantments = (Map)EnchantmentHelper.m_44831_((ItemStack)otherStack).entrySet().stream().filter(e -> ((Enchantment)e.getKey()).m_6589_()).collect(Util.m_137448_())).isEmpty()) {
                    Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
                    for (Map.Entry entry : otherEnchantments.entrySet()) {
                        enchantments.merge((Enchantment)entry.getKey(), (Integer)entry.getValue(), Math::max);
                    }
                    EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)stack);
                }
                return stack;
            }
            ItemStack itemStack3 = (ItemStack)itemsToRepair.get(0);
            if (itemStack3.m_150930_((itemStack = (ItemStack)itemsToRepair.get(1)).m_41720_()) && itemStack3.m_41613_() == 1 && itemStack.m_41613_() == 1 && itemStack3.m_41720_().m_41465_()) {
                Item item = itemStack3.m_41720_();
                int j = item.m_41462_() - itemStack3.m_41773_();
                int k = item.m_41462_() - itemStack.m_41773_();
                int l = j + k + item.m_41462_() * 5 / 100;
                int m = item.m_41462_() - l;
                if (m < 0) {
                    m = 0;
                }
                ItemStack itemStack4 = new ItemStack((ItemLike)itemStack3.m_41720_());
                itemStack4.m_41721_(m);
                HashMap map = Maps.newHashMap();
                Map map2 = EnchantmentHelper.m_44831_((ItemStack)itemStack3);
                Map map3 = EnchantmentHelper.m_44831_((ItemStack)itemStack);
                BuiltInRegistries.f_256876_.m_123024_().filter(Enchantment::m_6589_).forEach(enchantment -> {
                    int i = Math.max(map2.getOrDefault(enchantment, 0), map3.getOrDefault(enchantment, 0));
                    if (i > 0) {
                        map.put(enchantment, i);
                    }
                });
                if (!map.isEmpty()) {
                    EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemStack4);
                }
                return itemStack4;
            }
        }
        return ItemStack.f_41583_;
    }
}

