/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.core;

import fuzs.universalenchants.core.CommonAbstractions;
import fuzs.universalenchants.world.item.enchantment.data.BuiltInEnchantmentDataManager;
import fuzs.universalenchants.world.item.enchantment.serialize.entry.DataEntry;
import java.util.function.Predicate;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ForgeAbstractions
implements CommonAbstractions {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isArrowInfinite(LivingEntity entity, ItemStack rangedStack, ItemStack arrowStack) {
        Item item = arrowStack.m_41720_();
        if (!(item instanceof ArrowItem)) return false;
        ArrowItem item2 = (ArrowItem)item;
        if (!(entity instanceof Player)) return false;
        Player player = (Player)entity;
        if (!item2.isInfinite(arrowStack, rangedStack, player)) return false;
        return true;
    }

    @Override
    public EnchantmentCategory createEnchantmentCategory(String enumConstantName, Predicate<Item> predicate) {
        return EnchantmentCategory.create((String)enumConstantName, predicate);
    }

    @Override
    public int getMobLootingLevel(Entity target, @Nullable Entity killer, @Nullable DamageSource cause) {
        return ForgeHooks.getLootingLevel((Entity)target, (Entity)killer, (DamageSource)cause);
    }

    @Override
    public DataEntry.Builder defaultEnchantmentDataBuilder(Enchantment enchantment) {
        DataEntry.Builder builder = CommonAbstractions.super.defaultEnchantmentDataBuilder(enchantment);
        for (Item item : ForgeRegistries.ITEMS) {
            if (BuiltInEnchantmentDataManager.INSTANCE.getVanillaCategory(enchantment).m_7454_(item) || !item.canApplyAtEnchantingTable(new ItemStack((ItemLike)item), enchantment)) continue;
            builder.add(item);
        }
        return builder;
    }
}

