/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.recipe;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.mysticalagriculture.api.crafting.IEnchanterRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchanterRecipe
implements ISpecialRecipe,
IEnchanterRecipe {
    private final ResourceLocation recipeId;
    private final NonNullList<Ingredient> inputs;
    private final List<Integer> inputCounts;
    private final Enchantment enchantment;

    public EnchanterRecipe(ResourceLocation recipeId, NonNullList<Ingredient> inputs, List<Integer> inputCounts, Enchantment enchantment) {
        this.recipeId = recipeId;
        this.inputs = inputs;
        this.inputCounts = inputCounts;
        this.enchantment = enchantment;
    }

    public ItemStack assemble(IItemHandler inventory, RegistryAccess access) {
        return this.getEnchantedOutputItemStack(inventory);
    }

    public ItemStack m_5874_(Container inventory, RegistryAccess access) {
        return this.assemble((IItemHandler)new InvWrapper(inventory), access);
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return ItemStack.f_41583_;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.ENCHANTER.get();
    }

    public RecipeType<? extends IEnchanterRecipe> m_6671_() {
        return (RecipeType)ModRecipeTypes.ENCHANTER.get();
    }

    public boolean matches(IItemHandler inventory) {
        for (int i = 0; i < this.inputs.size(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            Ingredient ingredient = (Ingredient)this.inputs.get(i);
            Integer count = this.inputCounts.get(i);
            if (ingredient.test(stack) && stack.m_41613_() >= count) continue;
            return false;
        }
        return true;
    }

    public boolean m_5818_(Container inv, Level level) {
        return this.matches((IItemHandler)new InvWrapper(inv));
    }

    public NonNullList<ItemStack> getRemainingItems(IItemHandler inventory) {
        NonNullList remaining = NonNullList.m_122780_((int)inventory.getSlots(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < 2; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            int count = this.inputCounts.get(i) * this.getOutputEnchantmentLevel(inventory);
            remaining.set(i, (Object)stack.m_255036_(stack.m_41613_() - count));
        }
        ItemStack stack = inventory.getStackInSlot(2);
        if (stack.m_41613_() > 1) {
            remaining.set(2, (Object)stack.m_255036_(stack.m_41613_() - 1));
        }
        return remaining;
    }

    @Override
    public List<Integer> getIngredientCounts() {
        return this.inputCounts;
    }

    @Override
    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    private ItemStack getEnchantedOutputItemStack(IItemHandler inventory) {
        ItemStack stack = inventory.getStackInSlot(2);
        if (this.enchantment.m_6081_(stack)) {
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
            int newLevel = this.getOutputEnchantmentLevel(inventory);
            for (Enchantment enchantment : enchantments.keySet()) {
                if (enchantment == this.enchantment && (Integer)enchantments.get(enchantment) >= newLevel) {
                    return ItemStack.f_41583_;
                }
                if (enchantment == this.enchantment || enchantment.m_44695_(this.enchantment)) continue;
                return ItemStack.f_41583_;
            }
            enchantments.put(this.enchantment, newLevel);
            ItemStack result = stack.m_255036_(1);
            EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)result);
            return result;
        }
        if (stack.m_150930_(Items.f_42517_)) {
            return EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(this.enchantment, this.getOutputEnchantmentLevel(inventory)));
        }
        return ItemStack.f_41583_;
    }

    private int getOutputEnchantmentLevel(IItemHandler inventory) {
        int level = 0;
        for (int i = 0; i < this.inputs.size(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            Integer count = this.inputCounts.get(i);
            int newLevel = stack.m_41613_() / count;
            if (level != 0 && newLevel >= level) continue;
            level = Math.min(newLevel, this.enchantment.m_6586_());
        }
        return level;
    }

    public static class Serializer
    implements RecipeSerializer<EnchanterRecipe> {
        public EnchanterRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList inputs = NonNullList.m_122780_((int)2, (Object)Ingredient.f_43901_);
            ArrayList<Integer> inputCounts = new ArrayList<Integer>(2);
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
                inputCounts.add(GsonHelper.m_13824_((JsonObject)ingredients.get(i).getAsJsonObject(), (String)"count", (int)1));
            }
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"enchantment")));
            return new EnchanterRecipe(recipeId, (NonNullList<Ingredient>)inputs, inputCounts, enchantment);
        }

        public EnchanterRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            NonNullList inputs = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
            ArrayList<Integer> inputCounts = new ArrayList<Integer>(size);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
                inputCounts.add(buffer.m_130242_());
            }
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(buffer.m_130281_());
            return new EnchanterRecipe(recipeId, (NonNullList<Ingredient>)inputs, inputCounts, enchantment);
        }

        public void toNetwork(FriendlyByteBuf buffer, EnchanterRecipe recipe) {
            buffer.m_130130_(recipe.inputs.size());
            for (int i = 0; i < recipe.inputs.size(); ++i) {
                ((Ingredient)recipe.inputs.get(i)).m_43923_(buffer);
                buffer.m_130130_(i < recipe.inputCounts.size() ? recipe.inputCounts.get(i) : 1);
            }
            ResourceLocation enchantment = Objects.requireNonNull(ForgeRegistries.ENCHANTMENTS.getKey((Object)recipe.enchantment));
            buffer.m_130085_(enchantment);
        }
    }
}

