/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.client.gui;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.woodcutter.inventory.WoodcutterContainer;
import ovh.corail.woodcutter.recipe.WoodcuttingRecipe;

@OnlyIn(value=Dist.CLIENT)
public class WoodcutterScreen
extends AbstractContainerScreen<WoodcutterContainer> {
    private static final ResourceLocation BG_LOCATION = new ResourceLocation("textures/gui/container/stonecutter.png");
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;

    public WoodcutterScreen(WoodcutterContainer containerIn, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)containerIn, playerInv, title);
        containerIn.registerUpdateListener(this::containerChanged);
        --this.f_97729_;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(guiGraphics);
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(BG_LOCATION, i, j, 0, 0, this.f_97726_, this.f_97727_);
        int k = (int)(41.0f * this.scrollOffs);
        guiGraphics.m_280218_(BG_LOCATION, i + 119, j + 15 + k, 176 + (this.isScrollBarActive() ? 0 : 12), 0, 12, 15);
        int l = this.f_97735_ + 52;
        int i1 = this.f_97736_ + 14;
        int j1 = this.startIndex + 12;
        this.renderButtons(guiGraphics, mouseX, mouseY, l, i1, j1);
        this.renderRecipes(guiGraphics, l, i1, j1);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int x, int y) {
        super.m_280072_(guiGraphics, x, y);
        if (this.displayRecipes) {
            int i = this.f_97735_ + 52;
            int j = this.f_97736_ + 14;
            int k = this.startIndex + 12;
            List<WoodcuttingRecipe> list = ((WoodcutterContainer)this.f_97732_).getRecipes();
            for (int l = this.startIndex; l < k && l < ((WoodcutterContainer)this.f_97732_).getNumRecipes(); ++l) {
                int i1 = l - this.startIndex;
                int j1 = i + i1 % 4 * 16;
                int k1 = j + i1 / 4 * 18 + 2;
                if (x < j1 || x >= j1 + 16 || y < k1 || y >= k1 + 18) continue;
                assert (this.f_96541_ != null && this.f_96541_.f_91073_ != null);
                guiGraphics.m_280153_(this.f_96547_, list.get(l).m_8043_(this.f_96541_.f_91073_.m_9598_()), x, y);
            }
        }
    }

    private void renderButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y, int scrollOffset) {
        for (int i = this.startIndex; i < scrollOffset && i < ((WoodcutterContainer)this.f_97732_).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = x + j % 4 * 16;
            int l = j / 4;
            int i1 = y + l * 18 + 2;
            int j1 = this.f_97727_;
            if (i == ((WoodcutterContainer)this.f_97732_).getSelectedRecipeIndex()) {
                j1 += 18;
            } else if (mouseX >= k && mouseY >= i1 && mouseX < k + 16 && mouseY < i1 + 18) {
                j1 += 36;
            }
            guiGraphics.m_280218_(BG_LOCATION, k, i1 - 1, 0, j1, 16, 18);
        }
    }

    private void renderRecipes(GuiGraphics guiGraphics, int x, int y, int scrollOffset) {
        List<WoodcuttingRecipe> list = ((WoodcutterContainer)this.f_97732_).getRecipes();
        for (int i = this.startIndex; i < scrollOffset && i < ((WoodcutterContainer)this.f_97732_).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = x + j % 4 * 16;
            int l = j / 4;
            int i1 = y + l * 18 + 2;
            assert (this.f_96541_ != null && this.f_96541_.f_91073_ != null);
            guiGraphics.m_280480_(list.get(i).m_8043_(this.f_96541_.f_91073_.m_9598_()), k, i1);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int buttonId) {
        this.scrolling = false;
        if (this.displayRecipes) {
            int i = this.f_97735_ + 52;
            int j = this.f_97736_ + 14;
            int k = this.startIndex + 12;
            for (int l = this.startIndex; l < k; ++l) {
                int i1 = l - this.startIndex;
                double d0 = mouseX - (double)(i + i1 % 4 * 16);
                double d1 = mouseY - (double)(j + i1 / 4 * 18);
                assert (this.f_96541_ != null && this.f_96541_.f_91074_ != null);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((WoodcutterContainer)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, l)) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                assert (this.f_96541_.f_91072_ != null);
                this.f_96541_.f_91072_.m_105208_(((WoodcutterContainer)this.f_97732_).f_38840_, l);
                return true;
            }
            i = this.f_97735_ + 119;
            j = this.f_97736_ + 14;
            if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
                this.scrolling = true;
                this.scrollOffs = Mth.m_14036_((float)((float)(mouseY - (double)j - 7.5) / 40.0f), (float)0.0f, (float)1.0f);
                this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            }
        }
        return super.m_6375_(mouseX, mouseY, buttonId);
    }

    public boolean m_7979_(double mouseX, double mouseY, int buttonId, double dragX, double dragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.f_97736_ + 14;
            int j = i + 54;
            this.scrollOffs = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, buttonId, dragX, dragY);
    }

    public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)p_mouseScrolled_5_ / (float)i;
            this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && ((WoodcutterContainer)this.f_97732_).getNumRecipes() > 12;
    }

    private int getOffscreenRows() {
        return (((WoodcutterContainer)this.f_97732_).getNumRecipes() + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        this.displayRecipes = ((WoodcutterContainer)this.f_97732_).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
    }

    protected void m_6597_(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (!(type != ClickType.PICKUP || slotId != 0 || mouseButton != 0 || slotIn == null || slotIn.f_40219_ != 0 || ((WoodcutterContainer)this.f_97732_).m_142621_().m_41619_() || slotIn.m_7993_().m_41619_() || ItemStack.m_150942_((ItemStack)((WoodcutterContainer)this.f_97732_).m_142621_(), (ItemStack)slotIn.m_7993_()))) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
        super.m_6597_(slotIn, slotId, mouseButton, type);
    }
}

