/*
 * Decompiled with CFR 0.152.
 */
package fuzs.permanentsponges.util;

import fuzs.permanentsponges.core.CommonAbstractions;
import fuzs.permanentsponges.init.ModRegistry;
import fuzs.permanentsponges.world.level.block.SpongeMaterial;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public class LiquidAbsorptionHelper {
    private static final Int2ObjectMap<List<BlockPos>> SPONGE_RADIUS = new Int2ObjectOpenHashMap();

    public static List<BlockPos> getSpongeRadius(int depth) {
        return (List)SPONGE_RADIUS.computeIfAbsent(depth, LiquidAbsorptionHelper::getSortedSpongeRadius);
    }

    private static List<BlockPos> getSortedSpongeRadius(int depth) {
        return BlockPos.m_121886_((int)(-depth), (int)(-depth), (int)(-depth), (int)depth, (int)depth, (int)depth).map(BlockPos::m_7949_).sorted(Comparator.comparingInt(blockPos -> Math.max(Math.max(Math.abs(blockPos.m_123341_()), Math.abs(blockPos.m_123342_())), Math.abs(blockPos.m_123343_()))).thenComparingInt(arg_0 -> ((BlockPos)BlockPos.f_121853_).m_123333_(arg_0))).toList();
    }

    public static boolean removeAllLiquid(ServerLevel level, BlockPos blockPos, int spongeRadius, boolean destroySource, @Nullable Holder.Reference<PoiType> poiType) {
        List<BlockPos> positions = LiquidAbsorptionHelper.getSpongeRadius(spongeRadius);
        BoundingBox boundingBox = new BoundingBox(-spongeRadius, -spongeRadius, -spongeRadius, spongeRadius, spongeRadius, spongeRadius);
        level.m_183324_().m_193234_(boundingBox.m_162373_((Vec3i)blockPos));
        boolean hasDestroyedSource = false;
        for (BlockPos currentBlockPos : positions) {
            currentBlockPos = blockPos.m_121955_((Vec3i)currentBlockPos);
            BlockState blockState = level.m_8055_(currentBlockPos);
            FluidState fluidState = level.m_6425_(currentBlockPos);
            if (fluidState.m_76178_() && !blockState.m_60795_()) continue;
            if (!hasDestroyedSource && LiquidAbsorptionHelper.isHotFluid(fluidState.m_76152_())) {
                if (destroySource) {
                    LiquidAbsorptionHelper.destroySpongeBlock(level, blockPos, poiType);
                }
                hasDestroyedSource = true;
            }
            LiquidAbsorptionHelper.removeLiquid((Level)level, currentBlockPos, blockState, fluidState);
        }
        return hasDestroyedSource;
    }

    private static boolean isHotFluid(Fluid fluid) {
        return CommonAbstractions.INSTANCE.getFluidTemperature(fluid) >= 1000;
    }

    private static void destroySpongeBlock(ServerLevel level, BlockPos blockPos, @Nullable Holder.Reference<PoiType> poiType) {
        if (level.m_8055_(blockPos).m_204336_(ModRegistry.PERMANENT_SPONGES_BLOCK_TAG)) {
            if (poiType != null && !level.m_8904_().m_217874_(poiType.m_205785_(), blockPos)) {
                level.m_8904_().m_217919_(blockPos, poiType);
            }
            level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
            level.m_46796_(2009, blockPos, 0);
            level.m_5594_(null, blockPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, (1.0f + level.m_213780_().m_188501_() * 0.2f) * 0.7f);
        }
    }

    private static void removeLiquid(Level level, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
        if (!(blockState.m_60734_() instanceof BucketPickup) || ((BucketPickup)blockState.m_60734_()).m_142598_((LevelAccessor)level, blockPos, blockState).m_41619_()) {
            boolean setToAir = false;
            if (blockState.m_60734_() instanceof LiquidBlock || blockState.m_60795_()) {
                setToAir = true;
            } else if (blockState.m_60713_(Blocks.f_50575_) || blockState.m_60713_(Blocks.f_50576_) || blockState.m_60713_(Blocks.f_50037_) || blockState.m_60713_(Blocks.f_50038_)) {
                BlockEntity blockentity = blockState.m_155947_() ? level.m_7702_(blockPos) : null;
                Block.m_49892_((BlockState)blockState, (LevelAccessor)level, (BlockPos)blockPos, (BlockEntity)blockentity);
                setToAir = true;
            }
            if (setToAir && !blockState.m_60795_()) {
                level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
                if (!fluidState.m_76178_() && level.m_213780_().m_188503_(5) == 0) {
                    if (LiquidAbsorptionHelper.isHotFluid(fluidState.m_76152_())) {
                        level.m_46796_(1501, blockPos, 0);
                    } else {
                        level.m_46796_(2009, blockPos, 0);
                        level.m_5594_(null, blockPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, (1.0f + level.m_213780_().m_188501_() * 0.2f) * 0.7f);
                    }
                }
            }
        }
    }

    public static boolean tryPreventLiquidFromEntering(ServerLevel serverLevel, BlockPos pos, Fluid fluid) {
        Map.Entry<SpongeMaterial, BlockPos> entry = LiquidAbsorptionHelper.keepPositionFreeFromLiquid(serverLevel, pos);
        if (entry != null) {
            if (entry.getKey().shouldDestroyTouchingHot() && LiquidAbsorptionHelper.isHotFluid(fluid)) {
                LiquidAbsorptionHelper.destroySpongeBlock(serverLevel, entry.getValue(), null);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static Map.Entry<SpongeMaterial, BlockPos> keepPositionFreeFromLiquid(ServerLevel serverLevel, BlockPos pos) {
        PoiManager poiManager = serverLevel.m_8904_();
        for (SpongeMaterial spongeMaterial : SpongeMaterial.values()) {
            ResourceKey resourceKey = spongeMaterial.getPoiType().m_205785_();
            int distance = (int)Math.ceil((double)(spongeMaterial.getBlockDistance() + 1) * 1.42);
            Optional<BlockPos> optional = poiManager.m_27138_(poiTypeHolder -> poiTypeHolder.m_203565_(resourceKey), $ -> true, pos, distance, PoiManager.Occupancy.ANY).filter(blockPos -> Math.abs((blockPos = blockPos.m_121996_((Vec3i)pos)).m_123341_()) <= spongeMaterial.getBlockDistance() && Math.abs(blockPos.m_123342_()) <= spongeMaterial.getBlockDistance() && Math.abs(blockPos.m_123343_()) <= spongeMaterial.getBlockDistance()).min(Comparator.comparingInt(arg_0 -> ((BlockPos)pos).m_123333_(arg_0)));
            if (!optional.isPresent()) continue;
            return Map.entry(spongeMaterial, optional.get());
        }
        return null;
    }
}

