/*
 * Decompiled with CFR 0.152.
 */
package fuzs.permanentsponges.mixin;

import fuzs.permanentsponges.util.LiquidAbsorptionHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FlowingFluid.class})
abstract class FlowingFluidMixin
extends Fluid {
    FlowingFluidMixin() {
    }

    @Inject(method={"canHoldFluid"}, at={@At(value="HEAD")}, cancellable=true)
    private void canHoldFluid(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid, CallbackInfoReturnable<Boolean> callback) {
        ServerLevel serverLevel;
        if (level instanceof ServerLevel && LiquidAbsorptionHelper.tryPreventLiquidFromEntering(serverLevel = (ServerLevel)level, pos, fluid)) {
            callback.setReturnValue((Object)false);
        }
    }
}

