/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.world.phys.shapes;

import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelUtils {
    private static final double SCALE = 16.0;
    private static final double SCALED_DOWN = 0.0625;

    public static Vec3[] scale(Vec3[] edges) {
        return (Vec3[])Stream.of(edges).map(edge -> edge.m_82490_(0.0625)).toArray(Vec3[]::new);
    }

    public static Vec3[] mirrorX(Vec3[] edges) {
        return (Vec3[])Stream.of(edges).map(edge -> new Vec3(16.0 - edge.f_82479_, edge.f_82480_, edge.f_82481_)).toArray(Vec3[]::new);
    }

    public static Vec3[] mirrorY(Vec3[] edges) {
        return (Vec3[])Stream.of(edges).map(edge -> new Vec3(edge.f_82479_, 16.0 - edge.f_82480_, edge.f_82481_)).toArray(Vec3[]::new);
    }

    public static Vec3[] mirrorZ(Vec3[] edges) {
        return (Vec3[])Stream.of(edges).map(edge -> new Vec3(edge.f_82479_, edge.f_82480_, 16.0 - edge.f_82481_)).toArray(Vec3[]::new);
    }

    public static Vec3[] flipXZ(Vec3[] edges) {
        return (Vec3[])Stream.of(edges).map(edge -> new Vec3(edge.f_82481_, edge.f_82480_, edge.f_82479_)).toArray(Vec3[]::new);
    }

    public static Vec3[] flipXY(Vec3[] edges) {
        return (Vec3[])Stream.of(edges).map(edge -> new Vec3(edge.f_82480_, edge.f_82479_, edge.f_82481_)).toArray(Vec3[]::new);
    }

    public static Vec3[] flipYZ(Vec3[] edges) {
        return (Vec3[])Stream.of(edges).map(edge -> new Vec3(edge.f_82479_, edge.f_82481_, edge.f_82480_)).toArray(Vec3[]::new);
    }

    public static Vec3[] rotate(Direction direction, Vec3[] edges) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> VoxelUtils.mirrorY(edges);
            case Direction.UP -> edges;
            case Direction.NORTH -> VoxelUtils.mirrorZ(VoxelUtils.flipYZ(edges));
            case Direction.SOUTH -> VoxelUtils.flipYZ(edges);
            case Direction.EAST -> VoxelUtils.flipXY(edges);
            case Direction.WEST -> VoxelUtils.mirrorX(VoxelUtils.flipXY(edges));
        };
    }

    public static VoxelShape makeCombinedShape(Vec3[] corners) {
        if (corners.length == 0 || corners.length % 2 != 0) {
            throw new IllegalArgumentException("Incorrect number of provided corners");
        }
        VoxelShape shape = null;
        for (int i = 0; i < corners.length / 2; ++i) {
            int index = 2 * i;
            VoxelShape boxShape = VoxelUtils.makeBoxShape(corners[index], corners[index + 1]);
            shape = i == 0 ? boxShape : Shapes.m_83110_((VoxelShape)shape, (VoxelShape)boxShape);
        }
        return shape;
    }

    public static VoxelShape makeBoxShape(Vec3 start, Vec3 end) {
        double startX = Math.min(start.f_82479_, end.f_82479_);
        double startY = Math.min(start.f_82480_, end.f_82480_);
        double startZ = Math.min(start.f_82481_, end.f_82481_);
        double endX = Math.max(start.f_82479_, end.f_82479_);
        double endY = Math.max(start.f_82480_, end.f_82480_);
        double endZ = Math.max(start.f_82481_, end.f_82481_);
        return Block.m_49796_((double)startX, (double)startY, (double)startZ, (double)endX, (double)endY, (double)endZ);
    }

    public static Vec3[] makeVectors(double ... values) {
        if (values.length % 3 != 0) {
            throw new IllegalArgumentException("Unable to create proper number of vectors");
        }
        Vec3[] array = new Vec3[values.length / 3];
        for (int i = 0; i < array.length; ++i) {
            int index = 3 * i;
            array[i] = new Vec3(values[index], values[index + 1], values[index + 2]);
        }
        return array;
    }

    public static Vec3[] makePyramidEdges(Vec3[] corners) {
        if (corners.length != 5) {
            throw new IllegalArgumentException("Constructing a pyramid requires 5 corners");
        }
        return new Vec3[]{corners[0], corners[1], corners[1], corners[2], corners[2], corners[3], corners[3], corners[0], corners[0], corners[4], corners[1], corners[4], corners[2], corners[4], corners[3], corners[4]};
    }

    public static Vec3[] makeCuboidEdges(Vec3[] corners) {
        if (corners.length != 8) {
            throw new IllegalArgumentException("Constructing a cuboid requires 8 corners");
        }
        return new Vec3[]{corners[0], corners[1], corners[1], corners[2], corners[2], corners[3], corners[3], corners[0], corners[0], corners[4], corners[1], corners[5], corners[2], corners[6], corners[3], corners[7], corners[4], corners[5], corners[5], corners[6], corners[6], corners[7], corners[7], corners[4]};
    }
}

