/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.world.level.block.entity;

import com.google.common.collect.Maps;
import fuzs.spikyspikes.init.ModRegistry;
import fuzs.spikyspikes.world.damagesource.LootingDamageSource;
import fuzs.spikyspikes.world.level.block.SpikeBlock;
import fuzs.spikyspikes.world.level.block.SpikeMaterial;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.SweepingEdgeEnchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SpikeBlockEntity
extends BlockEntity {
    public static final String ENCHANTMENTS_TAG = "Enchantments";
    public static final String REPAIR_COST_TAG = "RepairCost";
    private Map<Enchantment, Integer> enchantments = Maps.newHashMap();
    private int repairCost;

    public SpikeBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModRegistry.SPIKE_BLOCK_ENTITY_TYPE.get(), p_155229_, p_155230_);
    }

    public static ListTag serializeEnchantments(Map<Enchantment, Integer> p_44866_) {
        ListTag listtag = new ListTag();
        for (Map.Entry<Enchantment, Integer> entry : p_44866_.entrySet()) {
            Enchantment enchantment = entry.getKey();
            if (enchantment == null) continue;
            int i = entry.getValue();
            listtag.add((Object)EnchantmentHelper.m_182443_((ResourceLocation)EnchantmentHelper.m_182432_((Enchantment)enchantment), (int)i));
        }
        return listtag;
    }

    public static void attackPlayerLike(Level level, BlockPos pos, BlockState state, SpikeBlockEntity blockEntity, LivingEntity entity, SpikeMaterial material) {
        SpikeBlockEntity.attackPlayerLike((Entity)entity, material.damageAmount(), level, pos, (Direction)state.m_61143_((Property)SpikeBlock.FACING), blockEntity.enchantments, material.hurtsPlayers());
    }

    private static void attackPlayerLike(Entity target, float attackDamage, Level level, BlockPos pos, Direction direction, Map<Enchantment, Integer> enchantments, boolean hurtPlayers) {
        if (target.m_6097_()) {
            MobType mobType = target instanceof LivingEntity ? ((LivingEntity)target).m_6336_() : MobType.f_21640_;
            float damageBonus = 0.0f;
            for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
                damageBonus += entry.getKey().m_7335_(entry.getValue().intValue(), mobType);
            }
            if (attackDamage > 0.0f || damageBonus > 0.0f) {
                attackDamage += damageBonus;
                int fireAspect = enchantments.getOrDefault(Enchantments.f_44981_, 0);
                boolean setOnFire = false;
                if (target instanceof LivingEntity && fireAspect > 0 && !target.m_6060_()) {
                    setOnFire = true;
                    target.m_20254_(1);
                }
                int looting = enchantments.getOrDefault(Enchantments.f_44982_, 0);
                Vec3 oldMovement = target.m_20184_();
                if (SpikeBlockEntity.hurtPlayerLike(level, target, attackDamage, looting)) {
                    int sweeping;
                    target.m_20256_(oldMovement);
                    int knockback = enchantments.getOrDefault(Enchantments.f_44980_, 0);
                    if (knockback > 0) {
                        SpikeBlockEntity.applyLivingKnockback(direction, target, (float)knockback * 0.5f, level.m_213780_());
                    }
                    if ((sweeping = enchantments.getOrDefault(Enchantments.f_44983_, 0).intValue()) > 0) {
                        SpikeBlockEntity.applySweepingDamage(target, attackDamage, level, pos, direction, looting, knockback, sweeping, hurtPlayers);
                    }
                    if (damageBonus > 0.0f && level instanceof ServerLevel) {
                        ((ServerLevel)level).m_7726_().m_8394_(target, (Packet)new ClientboundAnimatePacket(target, 5));
                    }
                    if (target instanceof LivingEntity && fireAspect > 0) {
                        target.m_20254_(fireAspect * 4);
                    }
                } else if (setOnFire) {
                    target.m_20095_();
                }
            }
        }
    }

    private static boolean hurtPlayerLike(Level level, Entity entity, float attackDamage, int looting) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_6703_(null);
            mob.m_6598_(null);
            mob.m_6710_(null);
        }
        return entity.m_6469_(LootingDamageSource.source((LevelReader)level, ModRegistry.SPIKE_DAMAGE_TYPE, looting), attackDamage);
    }

    private static void applyLivingKnockback(Direction direction, Entity target, float strength, RandomSource random) {
        if (target instanceof LivingEntity) {
            strength = (float)((double)strength * (1.0 - ((LivingEntity)target).m_21133_(Attributes.f_22278_)));
        }
        if ((double)strength > 0.0) {
            Vec3 deltaMovement = target.m_20184_();
            Vec3 normalVec = new Vec3((double)direction.m_122436_().m_123341_(), (double)direction.m_122436_().m_123342_(), (double)direction.m_122436_().m_123343_());
            int axisStep = direction.m_122424_().m_122421_().m_122540_();
            Vec3 offsetVec = new Vec3((double)axisStep, (double)axisStep, (double)axisStep).m_82549_(normalVec).m_82542_(random.m_188583_(), random.m_188583_(), random.m_188583_());
            Vec3 knockbackVec = normalVec.m_82549_(offsetVec).m_82541_().m_82490_((double)strength);
            target.m_20334_(deltaMovement.f_82479_ / 2.0 + knockbackVec.f_82479_, Math.min(0.4, deltaMovement.f_82480_ / 2.0 + knockbackVec.f_82480_), deltaMovement.f_82481_ / 2.0 + knockbackVec.f_82481_);
            target.f_19812_ = true;
        }
    }

    private static void applySweepingDamage(Entity target, float attackDamage, Level level, BlockPos pos, Direction direction, int looting, int knockback, int sweeping, boolean hurtPlayers) {
        float f3 = 1.0f + SweepingEdgeEnchantment.m_45193_((int)sweeping) * attackDamage;
        for (LivingEntity livingentity : level.m_6443_(LivingEntity.class, target.m_20191_().m_82377_(1.0, 0.25, 1.0), hurtPlayers ? EntitySelector.f_20408_ : entity -> !(entity instanceof Player))) {
            if (livingentity == target || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).m_31677_() || !(pos.m_203193_((Position)livingentity.m_20182_()) < 9.0)) continue;
            if (knockback > 0) {
                SpikeBlockEntity.applyLivingKnockback(direction, (Entity)livingentity, 0.4f, level.m_213780_());
            }
            livingentity.m_6469_(LootingDamageSource.source((LevelReader)level, ModRegistry.SPIKE_DAMAGE_TYPE, looting), f3);
        }
        if (level instanceof ServerLevel) {
            BlockPos offsetPos = pos.m_121945_(direction);
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123766_, (double)offsetPos.m_123341_() + 0.5, (double)offsetPos.m_123342_() + 0.5, (double)offsetPos.m_123343_() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_(ENCHANTMENTS_TAG, 9)) {
            ListTag enchantments = tag.m_128437_(ENCHANTMENTS_TAG, 10);
            this.enchantments = EnchantmentHelper.m_44882_((ListTag)enchantments);
        } else {
            this.enchantments = Maps.newHashMap();
        }
        if (tag.m_128425_(REPAIR_COST_TAG, 3)) {
            this.repairCost = tag.m_128451_(REPAIR_COST_TAG);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag enchantments = SpikeBlockEntity.serializeEnchantments(this.enchantments);
        if (!enchantments.isEmpty()) {
            tag.m_128365_(ENCHANTMENTS_TAG, (Tag)enchantments);
        }
        if (this.repairCost != 0) {
            tag.m_128405_(REPAIR_COST_TAG, this.repairCost);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void setEnchantmentData(Map<Enchantment, Integer> enchantments, int repairCost) {
        this.enchantments = enchantments;
        this.repairCost = repairCost;
        this.m_6596_();
    }

    public boolean hasFoil() {
        return this.enchantments != null && !this.enchantments.isEmpty();
    }
}

