/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.client.renderer.blockentity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.spikyspikes.client.model.geom.PureModelPart;
import fuzs.spikyspikes.client.model.geom.ShapeModelPart;
import fuzs.spikyspikes.world.level.block.SpikeBlock;
import fuzs.spikyspikes.world.level.block.SpikeMaterial;
import fuzs.spikyspikes.world.level.block.entity.SpikeBlockEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.properties.Property;

public class SpikeRenderer
implements BlockEntityRenderer<SpikeBlockEntity> {
    private static final Map<SpikeMaterial, Material> MATERIAL_BY_TYPE = (Map)new HashMap<SpikeMaterial, ResourceLocation>(){
        {
            this.put(SpikeMaterial.WOOD, new ResourceLocation("block/stripped_oak_log"));
            this.put(SpikeMaterial.STONE, new ResourceLocation("block/smooth_stone"));
            this.put(SpikeMaterial.IRON, new ResourceLocation("block/iron_block"));
            this.put(SpikeMaterial.GOLD, new ResourceLocation("block/gold_block"));
            this.put(SpikeMaterial.DIAMOND, new ResourceLocation("block/diamond_block"));
            this.put(SpikeMaterial.NETHERITE, new ResourceLocation("block/netherite_block"));
        }
    }.entrySet().stream().collect(Maps.toImmutableEnumMap(Map.Entry::getKey, entry -> new Material(InventoryMenu.f_39692_, (ResourceLocation)entry.getValue())));
    private static final PureModelPart MODEL = ShapeModelPart.pyramid(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f, false);
    private static final PureModelPart INVENTORY_MODEL = ShapeModelPart.pyramid(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f, true);

    public void render(SpikeBlockEntity p_112307_, float p_112308_, PoseStack poseStack, MultiBufferSource p_112310_, int p_112311_, int p_112312_) {
        Direction direction = (Direction)p_112307_.m_58900_().m_61143_((Property)SpikeBlock.FACING);
        SpikeMaterial spikeMaterial = ((SpikeBlock)p_112307_.m_58900_().m_60734_()).spikeMaterial;
        SpikeRenderer.renderSpike(direction, spikeMaterial, poseStack, p_112310_, p_112311_, p_112312_, false, p_112307_.hasFoil());
    }

    public static void renderSpike(Direction direction, SpikeMaterial spikeMaterial, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int overlay, boolean inventoryRendering, boolean withFoil) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_85841_(0.9995f, 0.9995f, 0.9995f);
        poseStack.m_252781_(direction.m_122424_().m_253075_());
        poseStack.m_85841_(1.0f, -1.0f, -1.0f);
        Material material = MATERIAL_BY_TYPE.get((Object)spikeMaterial);
        VertexConsumer vertexconsumer = material.m_119204_().m_118381_(ItemRenderer.m_115222_((MultiBufferSource)bufferSource, (RenderType)material.m_119201_(RenderType::m_110446_), (boolean)true, (boolean)withFoil));
        PureModelPart model = inventoryRendering ? INVENTORY_MODEL : MODEL;
        model.render(poseStack, vertexconsumer, combinedLight, overlay);
        poseStack.m_85849_();
    }
}

