/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.reactor.reactorfuelacceptor;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.antarcticgardens.newage.CreateNewAge;
import org.antarcticgardens.newage.content.reactor.RodFindingReactorBlockEntity;
import org.antarcticgardens.newage.content.reactor.reactorrod.ReactorRodBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactorFuelAcceptorBlockEntity
extends RodFindingReactorBlockEntity
implements Container {
    public static final TagKey<Item> fuel = new TagKey(Registries.f_256913_, new ResourceLocation("create_new_age", "nuclear/is_nuclear_fuel"));
    private LazyOptional<IItemHandlerModifiable> chestHandler;
    public SimpleContainer container = new SimpleContainer(3);
    int ticks = 0;

    public ReactorFuelAcceptorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public int m_6643_() {
        return this.container.m_6643_();
    }

    public boolean m_7983_() {
        return this.container.m_7983_();
    }

    public ItemStack m_8020_(int slot) {
        return this.container.m_8020_(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return this.container.m_7407_(slot, amount);
    }

    public ItemStack m_8016_(int slot) {
        return this.container.m_8016_(slot);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        this.container.m_6836_(slot, stack);
    }

    public boolean m_6542_(Player player) {
        return this.container.m_6542_(player);
    }

    public void m_6211_() {
        this.container.m_6211_();
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return stack.m_204117_(fuel);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.container.m_7797_(tag.m_128437_("contents", 10));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("contents", (Tag)this.container.m_7927_());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            if (this.chestHandler == null) {
                this.chestHandler = LazyOptional.of(this::createHandler);
            }
            return this.chestHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    private IItemHandlerModifiable createHandler() {
        BlockState state = this.m_58900_();
        if (!(state.m_60734_() instanceof ChestBlock)) {
            return new InvWrapper((Container)this);
        }
        Container inv = ChestBlock.m_51511_((ChestBlock)((ChestBlock)state.m_60734_()), (BlockState)state, (Level)this.m_58904_(), (BlockPos)this.m_58899_(), (boolean)true);
        return new InvWrapper((Container)(inv == null ? this : inv));
    }

    public void tick(BlockPos pos, Level world, BlockState state) {
        --this.ticks;
        if (this.ticks <= 0) {
            this.ticks = 20;
            LinkedList<ReactorRodBlockEntity> rods = new LinkedList<ReactorRodBlockEntity>();
            for (Direction dir : Direction.values()) {
                this.findRods(rods, dir);
            }
            if (rods.isEmpty()) {
                return;
            }
            AtomicInteger have = new AtomicInteger();
            int hadBefore = 0;
            for (ReactorRodBlockEntity rod : rods) {
                hadBefore += rod.fuel;
            }
            AtomicInteger totalNeeded = new AtomicInteger(345600 * rods.size() - hadBefore);
            for (int i = 0; i < this.container.m_6643_(); ++i) {
                ItemStack stack = this.container.m_8020_(i);
                if (!stack.m_204117_(fuel)) continue;
                stack.m_204131_().forEach(itemTagKey -> {
                    String path;
                    if (itemTagKey.f_203868_().m_135827_().equals("create_new_age") && (path = itemTagKey.f_203868_().m_135815_()).startsWith("nuclear/time_")) {
                        try {
                            int time = Integer.parseInt(path.substring(13));
                            int total = (int)Math.min((double)stack.m_41613_(), (double)(totalNeeded.get() / time));
                            totalNeeded.addAndGet(-time * total);
                            have.addAndGet(time * total);
                            stack.m_41774_(total);
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                            CreateNewAge.LOGGER.error("BAD TAG " + itemTagKey + " on item " + stack.m_41611_().getString());
                        }
                    }
                });
            }
            this.m_6596_();
            int target = (hadBefore + have.get()) / rods.size();
            for (ReactorRodBlockEntity rod : rods) {
                rod.fuel = target;
            }
        }
    }
}

