/*
 * Decompiled with CFR 0.152.
 */
package fuzs.plentyplates.world.level.block.entity.data;

import fuzs.plentyplates.world.level.block.entity.data.DataProvider;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class RegistryDataProvider<T>
implements DataProvider<T> {
    private final Registry<T> registry;
    private final Function<Entity, T> extractor;
    private final Predicate<T> filter;

    public RegistryDataProvider(Registry<T> registry, Function<Entity, T> extractor, Predicate<T> filter) {
        this.registry = registry;
        this.extractor = extractor;
        this.filter = filter;
    }

    public static RegistryDataProvider<EntityType<?>> entityType(boolean filterMisc) {
        return new RegistryDataProvider((Registry<EntityType<?>>)BuiltInRegistries.f_256780_, (Function<Entity, EntityType<?>>)((Function<Entity, EntityType>)Entity::m_6095_), (Predicate<EntityType<?>>)((Predicate<EntityType>)entityType -> !filterMisc || entityType.m_20674_() != MobCategory.MISC));
    }

    public static RegistryDataProvider<Item> item() {
        return new RegistryDataProvider<Item>((Registry<Item>)BuiltInRegistries.f_257033_, entity -> {
            Item item;
            if (entity instanceof ItemEntity) {
                ItemEntity item2 = (ItemEntity)entity;
                item = item2.m_32055_().m_41720_();
            } else {
                item = Items.f_41852_;
            }
            return item;
        }, item -> item != Items.f_41852_);
    }

    public static RegistryDataProvider<VillagerProfession> villagerProfession() {
        return new RegistryDataProvider<VillagerProfession>((Registry<VillagerProfession>)BuiltInRegistries.f_256735_, entity -> {
            if (entity instanceof Villager) {
                Villager villager = (Villager)entity;
                return villager.m_7141_().m_35571_();
            }
            return null;
        }, profession -> true);
    }

    @Override
    @Nullable
    public T fromString(String value) {
        ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)value);
        if (resourceLocation != null && this.registry.m_7804_(resourceLocation)) {
            return (T)this.registry.m_7745_(resourceLocation);
        }
        return null;
    }

    @Override
    public String toString(T value) {
        return this.registry.m_7981_(value).toString();
    }

    @Override
    public List<? extends T> getAllValues() {
        return this.registry.m_123024_().filter(this.filter).toList();
    }

    @Override
    public T fromTag(Tag tag) {
        if (tag.m_7060_() == 8) {
            return this.fromString(tag.m_7916_());
        }
        return null;
    }

    @Override
    public Tag toTag(T value) {
        return StringTag.m_129297_((String)this.toString(value));
    }

    @Override
    @Nullable
    public T fromEntity(Entity entity) {
        return this.extractor.apply(entity);
    }
}

