/*
 * Decompiled with CFR 0.152.
 */
package fuzs.plentyplates.world.level.block.entity.data;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public interface DataProvider<T> {
    public static final String TAG_DATA = "Data";

    @Nullable
    public T fromString(String var1);

    public String toString(T var1);

    public List<? extends T> getAllValues();

    default public Collection<String> getSerializedValues() {
        return (Collection)this.getAllValues().stream().map(this::toString).collect(ImmutableSet.toImmutableSet());
    }

    public T fromTag(Tag var1);

    public Tag toTag(T var1);

    @Nullable
    public T fromEntity(Entity var1);

    default public List<T> loadFrom(CompoundTag tag) {
        Tag data = tag.m_128423_(TAG_DATA);
        if (data != null && data.m_7060_() == 9) {
            ListTag list = (ListTag)data;
            return list.stream().map(this::fromTag).filter(Objects::nonNull).toList();
        }
        return List.of();
    }

    default public void saveTo(CompoundTag tag, List<T> data) {
        ListTag list = new ListTag();
        for (T datum : data) {
            list.add((Object)this.toTag(datum));
        }
        tag.m_128365_(TAG_DATA, (Tag)list);
    }
}

